/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

public class UtilSmallDecimal {
    long mValue;
    int mScale;
    private static final char[] Zeroes = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final double[] Scale = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20};
    private static final long[] ScaleL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final boolean Debug = false;

    public UtilSmallDecimal(int n2, int n3, int n4) {
        this.mValue = (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
        this.mScale = n4;
    }

    public UtilSmallDecimal(byte[] byArray, int n2, int n3) {
        this.init(byArray, n2, n3);
    }

    public UtilSmallDecimal(byte[] byArray, int n2) {
        this.init(byArray, n2);
    }

    private void init(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        this.mValue = n4 >= 8 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 & 0xFF0000000000L | (long)byArray[6] << 48 & 0xFF000000000000L | (long)byArray[7] << 56 & 0xFF00000000000000L : (n4 == 7 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 & 0xFF0000000000L | (long)byArray[6] << 48 & 0xFF000000000000L : (n4 == 6 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 & 0xFF0000000000L : (n4 == 5 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L : (n4 == 4 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L : (n4 == 3 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) : (n4 == 2 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00) : (n4 == 1 ? (long)(byArray[0] & 0xFF) : 0L)))))));
        if (n2 < 0) {
            this.mValue = -this.mValue;
        }
        this.mScale = n3;
    }

    private void init(byte[] byArray, int n2) {
        int n3 = byArray.length;
        this.mValue = n3 >= 8 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 & 0xFF0000000000L | (long)byArray[6] << 48 & 0xFF000000000000L | (long)byArray[7] << 56 : (n3 == 7 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 & 0xFF0000000000L | (long)byArray[6] << 48 : (n3 == 6 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 & 0xFF00000000L | (long)byArray[5] << 40 : (n3 == 5 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000) | (long)(byArray[3] << 24) & 0xFF000000L | (long)byArray[4] << 32 : (n3 == 4 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000 | byArray[3] << 24) : (n3 == 3 ? (long)(byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16) : (n3 == 2 ? (long)(byArray[0] & 0xFF | byArray[1] << 8) : (n3 == 1 ? (long)byArray[0] : 0L)))))));
        this.mScale = n2;
    }

    public void setDecimal(byte[] byArray, int n2, int n3) {
        this.init(byArray, n2, n3);
    }

    public void setDecimal(byte[] byArray, int n2) {
        this.init(byArray, n2);
    }

    public double doubleValue() {
        return (double)this.mValue / Scale[this.mScale];
    }

    public long longValue() {
        if (this.mScale > 18) {
            return 0L;
        }
        return this.mValue / ScaleL[this.mScale];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(24);
        stringBuffer.append(this.mValue);
        if (this.mScale > 0) {
            int n2 = this.mScale - stringBuffer.length();
            if (this.mValue < 0L) {
                ++n2;
            }
            if (n2 >= 0) {
                if (this.mValue >= 0L) {
                    stringBuffer.insert(0, Zeroes, 0, n2 + 1);
                } else {
                    stringBuffer.insert(1, Zeroes, 0, n2 + 1);
                }
            }
            stringBuffer.insert(stringBuffer.length() - this.mScale, '.');
        }
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[8];
        long l2 = this.mValue;
        byArray[7] = (byte)l2;
        byArray[6] = (byte)(l2 >>= 8);
        byArray[5] = (byte)(l2 >>= 8);
        byArray[4] = (byte)(l2 >>= 8);
        byArray[3] = (byte)(l2 >>= 8);
        byArray[2] = (byte)(l2 >>= 8);
        byArray[1] = (byte)(l2 >>= 8);
        byArray[0] = (byte)(l2 >>= 8);
        return byArray;
    }

    public int getScale() {
        return this.mScale;
    }

    private char hex(int n2) {
        switch (n2) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        return '?';
    }

    private String hex(byte by) {
        char[] cArray = new char[]{this.hex((by & 0xF0) >> 4), this.hex(by & 0xF)};
        return new String(cArray);
    }

    private String hex(long l2) {
        char[] cArray = new char[16];
        for (int i2 = 0; i2 < 8; ++i2) {
            String string = this.hex((byte)(l2 & 0xFFL));
            l2 >>= 8;
            cArray[14 - i2 * 2] = string.charAt(0);
            cArray[15 - i2 * 2] = string.charAt(1);
        }
        return new String(cArray);
    }
}

