/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs9;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AttributeValue;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import java.util.Enumeration;
import java.util.Set;

public class ExtensionRequest
extends AttributeValue {
    public static final ObjectID oid = ObjectID.extensionRequest;
    private X509Extensions a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null || this.a.countExtensions() == 0) {
            throw new CodingException("Extensions SEQUENCE is not allowed to be empty.");
        }
        try {
            return this.a.toASN1Object();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException("Error encoding extensions: " + x509ExtensionException.toString());
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.a == null) {
            return false;
        }
        return this.a.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.a != null) {
            this.a.removeAllExtensions();
        }
        this.a = null;
    }

    public Enumeration listExtensions() {
        if (this.a == null) {
            return null;
        }
        return this.a.listExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.a == null) {
            return false;
        }
        return this.a.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.a == null) {
            return false;
        }
        return this.a.hasExtensions();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.a == null) {
            return null;
        }
        return this.a.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        if (this.a == null) {
            return null;
        }
        return this.a.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.a == null) {
            return null;
        }
        return this.a.getExtension(objectID);
    }

    public Set getCriticalExtensionOIDs() {
        if (this.a == null) {
            return null;
        }
        return this.a.getCriticalExtensionOIDs();
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.a = new X509Extensions(aSN1Object);
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException("Error decoding extensions: " + x509ExtensionException.toString());
        }
    }

    public int countExtensions() {
        if (this.a == null) {
            return 0;
        }
        return this.a.countExtensions();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.a == null) {
            this.a = new X509Extensions();
        }
        this.a.addExtension(v3Extension);
    }

    public ExtensionRequest(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public ExtensionRequest() {
    }
}

