/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.utils.CipherInputStream;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class EncryptedContentInfoStream {
    int f = -1;
    int a = -1;
    Cipher e;
    InputStream b;
    AlgorithmID d;
    ObjectID c;

    public void writeTo(OutputStream outputStream) throws PKCSException, IOException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.c.getName() + "\n");
        stringBuffer.append("contentEncryptionAlgorithm: " + this.d + "\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.d == null) {
            throw new PKCSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(this.c);
        sEQUENCE.addComponent(this.d.toASN1Object());
        try {
            if (this.b != null) {
                OCTET_STRING oCTET_STRING = null;
                if (this.f > 0) {
                    if (this.e != null) {
                        this.b = new CipherInputStream(this.b, this.e, this.f);
                    }
                    oCTET_STRING = new OCTET_STRING(this.b, this.f);
                } else {
                    if (this.e != null) {
                        this.b = new CipherInputStream(this.b, this.e, 1024);
                    }
                    oCTET_STRING = new OCTET_STRING(this.b);
                }
                CON_SPEC cON_SPEC = new CON_SPEC(0, oCTET_STRING, true);
                sEQUENCE.addComponent(cON_SPEC);
            }
        }
        catch (Exception exception) {
            throw new PKCSException(exception.getMessage());
        }
        return sEQUENCE;
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.a == -1) {
            throw new InternalErrorException("Object not configured for en/decrypting!");
        }
        this.e = this.d.getCipherInstance();
        this.e.init(this.a, key, algorithmParameterSpec, null);
    }

    public void setupCipher(Key key) throws PKCSException, InvalidKeyException, NoSuchAlgorithmException {
        IvParameterSpec ivParameterSpec = null;
        try {
            ASN1Object aSN1Object = this.d.getParameter();
            ivParameterSpec = new IvParameterSpec((byte[])aSN1Object.getValue());
        }
        catch (Exception exception) {
            throw new PKCSException("Unable to get algorithm parameter!");
        }
        try {
            this.setupCipher(key, ivParameterSpec);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException("Wrong algorithm parameter!");
        }
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray;
        Object object;
        this.d = (AlgorithmID)algorithmID.clone();
        ASN1Object aSN1Object = algorithmID.getParameter();
        if (algorithmParameterSpec != null && aSN1Object == null) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                object = (IvParameterSpec)algorithmParameterSpec;
                aSN1Object = new OCTET_STRING(((IvParameterSpec)object).getIV());
                this.d.setParameter(aSN1Object);
            }
        } else if (algorithmParameterSpec == null && aSN1Object != null && aSN1Object instanceof OCTET_STRING) {
            object = (OCTET_STRING)aSN1Object;
            byArray = null;
            try {
                byArray = ((OCTET_STRING)object).getWholeValue();
            }
            catch (IOException iOException) {}
            if (byArray != null) {
                algorithmParameterSpec = new IvParameterSpec(byArray);
            }
        }
        this.e = this.d.getCipherInstance();
        this.e.init(1, key, algorithmParameterSpec, null);
        if (aSN1Object == null) {
            object = this.e.getParameters();
            if (object != null) {
                this.d.setAlgorithmParameters((AlgorithmParameters)object);
                return;
            }
            byArray = this.e.getIV();
            if (byArray != null) {
                this.d.setParameter(new OCTET_STRING(byArray));
            }
        }
    }

    public SecretKey setupCipher(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        String string = algorithmID.getImplementationName();
        int n3 = string.indexOf(47);
        if (n3 == -1) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " cannot be used with this method. " + "Please try another setup method!");
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string.substring(0, n3));
        keyGenerator.init(n2);
        SecretKey secretKey = keyGenerator.generateKey();
        try {
            this.setupCipher(algorithmID, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalErrorException("Internal Key problem.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException("We don't set an AlgorithmParameter.");
        }
        return secretKey;
    }

    public SecretKey setupCipher(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        return this.setupCipher(algorithmID, -1);
    }

    public void setBlockSize(int n2) {
        this.f = n2;
    }

    public boolean hasContent() {
        return this.b != null;
    }

    public InputStream getInputStream() {
        if (this.e == null) {
            throw new InternalErrorException("Cipher yet not initialized!");
        }
        if (this.b == null) {
            return null;
        }
        return new CipherInputStream(this.b, this.e);
    }

    public ObjectID getContentType() {
        return this.c;
    }

    public AlgorithmID getContentEncryptionAlgorithm() {
        return this.d;
    }

    public int getBlockSize() {
        return this.f;
    }

    protected void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        this.a = 2;
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? ((DerInputStream)inputStream).readSequence() : new DerInputStream(inputStream).readSequence();
        this.c = derInputStream.readObjectID();
        this.d = new AlgorithmID(derInputStream);
        if (derInputStream.nextTag() == -1) {
            return;
        }
        if (derInputStream.readContextSpecific(4) != 0) {
            throw new IOException("Error parsing encrypted content!");
        }
        this.b = derInputStream.readOctetString();
    }

    public EncryptedContentInfoStream(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public EncryptedContentInfoStream(ObjectID objectID, InputStream inputStream) {
        this();
        this.b = inputStream;
        this.c = objectID;
        this.a = 1;
    }

    public EncryptedContentInfoStream(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        this.c = objectID;
        this.d = algorithmID;
    }

    protected EncryptedContentInfoStream() {
    }
}

