/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.packet;

import com.metamatrix.common.comm.platform.socket.packet.MessagePacketSerializer;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import com.metamatrix.common.comm.platform.socket.packet.SynchronousPacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SynchronousPacketSerializer
extends MessagePacketSerializer {
    private Integer synchRequestID;

    public SynchronousPacketSerializer() {
    }

    public SynchronousPacketSerializer(int virtualSocketID, Integer synchRequestID) {
        super(virtualSocketID);
        this.synchRequestID = synchRequestID;
    }

    public Packet createPacket(ObjectInput in) throws IOException {
        return new SynchronousPacket(this.virtualSocketID, this.synchRequestID, this.readMessage(in));
    }

    public void writePacketBody(Packet packet, ObjectOutput out) throws IOException {
        out.writeObject(((SynchronousPacket)packet).message);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.synchRequestID = new Integer(in.readInt());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.synchRequestID);
    }
}

