/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilByteArray;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilResource;
import com.metamatrix.slutil.UtilResourceLocator;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;

public class UtilTransliteratorUsingTable
extends UtilTransliterator {
    private byte[] toServerArray;
    private char[] toClientArray;
    private byte[] unicodeBytes;
    private char[] unicodeChars;
    private int unicodeCount;
    private byte encodedUndefinedCharacter;
    private int[] rl;
    private static HashMap CachedConversionTables;
    private InputStream _in;

    public UtilTransliteratorUsingTable(String string) throws UtilException {
        ConversionTable conversionTable;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            InputStream inputStream = null;
            this.toClientArray = new char[256];
            UtilResource utilResource = new UtilResource(new UtilResourceLocator().getClass(), string);
            try {
                inputStream = utilResource.getAsStream();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new UtilException(1005, string);
            }
            if (inputStream == null) {
                throw new UtilException(1005, string);
            }
            this.loadTable(inputStream, string);
            this.buildConversionTables();
            this.cacheConversionTables(string);
        }
        this.setDefaultCacheSize();
    }

    public UtilTransliteratorUsingTable(String string, char[] cArray, byte by) throws UtilException {
        ConversionTable conversionTable;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            if (cArray.length != 256) {
                throw new UtilException(1008, "ctor 2");
            }
            this.toClientArray = cArray;
            this.encodedUndefinedCharacter = by;
            this.buildConversionTables();
            this.cacheConversionTables(string);
        }
        this.setDefaultCacheSize();
    }

    public static UtilTransliteratorUsingTable GetIfLoaded(String string) throws UtilException {
        if (CachedConversionTables == null) {
            return null;
        }
        if (CachedConversionTables.get(string) == null) {
            return null;
        }
        return new UtilTransliteratorUsingTable(string);
    }

    private void loadTable(InputStream inputStream, String string) throws UtilException {
        try {
            int n2;
            for (int i2 = 0; i2 < 256; ++i2) {
                n2 = inputStream.read();
                if (n2 == -1) {
                    throw new IOException();
                }
                int n3 = inputStream.read();
                if (n3 == -1) {
                    throw new IOException();
                }
                this.toClientArray[i2] = (char)(n2 * 256 + n3);
            }
            n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException();
            }
            this.encodedUndefinedCharacter = (byte)n2;
            if (inputStream.read() != -1) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1008, string);
        }
    }

    private void buildConversionTables() {
        int n2;
        int n3;
        int n4;
        this.unicodeCount = 0;
        this.toServerArray = new byte[256];
        for (n4 = 0; n4 < 256; ++n4) {
            this.toServerArray[n4] = this.encodedUndefinedCharacter;
            if ((this.toClientArray[n4] & 0xFF00) == 0) continue;
            ++this.unicodeCount;
        }
        this.unicodeBytes = new byte[this.unicodeCount];
        this.unicodeChars = new char[this.unicodeCount];
        this.unicodeCount = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            n3 = this.toClientArray[n4];
            if ((n3 & 0xFF00) == 0) {
                this.toServerArray[n3] = (byte)n4;
                continue;
            }
            this.unicodeChars[this.unicodeCount] = n3;
            this.unicodeBytes[this.unicodeCount] = (byte)n4;
            ++this.unicodeCount;
        }
        char[] cArray = new char[this.unicodeCount];
        for (n3 = 0; n3 < this.unicodeCount; ++n3) {
            cArray[n3] = this.unicodeChars[n3];
        }
        byte[] byArray = new byte[this.unicodeCount];
        for (n2 = 0; n2 < this.unicodeCount; ++n2) {
            byArray[n2] = this.unicodeBytes[n2];
        }
        Arrays.sort(this.unicodeChars);
        for (n2 = 0; n2 < this.unicodeCount; ++n2) {
            int n5 = Arrays.binarySearch(this.unicodeChars, cArray[n2]);
            this.unicodeBytes[n5] = byArray[n2];
        }
    }

    private void cacheConversionTables(Object object) {
        ConversionTable conversionTable = new ConversionTable();
        conversionTable.toServerArray = this.toServerArray;
        conversionTable.toClientArray = this.toClientArray;
        conversionTable.unicodeBytes = this.unicodeBytes;
        conversionTable.unicodeChars = this.unicodeChars;
        conversionTable.unicodeCount = this.unicodeCount;
        conversionTable.encodedUndefinedCharacter = this.encodedUndefinedCharacter;
        CachedConversionTables.put(object, conversionTable);
    }

    private void loadCachedConversionTable(ConversionTable conversionTable) {
        this.toServerArray = conversionTable.toServerArray;
        this.toClientArray = conversionTable.toClientArray;
        this.unicodeBytes = conversionTable.unicodeBytes;
        this.unicodeChars = conversionTable.unicodeChars;
        this.unicodeCount = conversionTable.unicodeCount;
        this.encodedUndefinedCharacter = conversionTable.encodedUndefinedCharacter;
    }

    private byte mapUnicodeChar(char c2) {
        int n2 = Arrays.binarySearch(this.unicodeChars, c2);
        if (n2 >= 0) {
            return this.unicodeBytes[n2];
        }
        return this.encodedUndefinedCharacter;
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length());
    }

    private void _encode(char[] cArray, byte[] byArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            byArray[i2] = (c2 & 0xFF00) == 0 ? this.toServerArray[c2] : this.mapUnicodeChar(c2);
        }
    }

    private void _encode(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.toServerArray[byArray[i2] & 0xFF];
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        this.setCacheSize(n2);
        string.getChars(0, n2, this.charsCache, 0);
        this._encode(this.charsCache, this.bytesCache, n2);
        nArray[0] = n2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                this._encode(this.bytesCache, n4);
                outputStream.write(this.bytesCache, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                this._encode(this.charsCache, this.bytesCache, n4);
                outputStream.write(this.bytesCache, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, char[] cArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n3; i2 >= 10; i2 -= 10) {
            cArray[n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            cArray[++n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            ++n4;
        }
        while (n4 < n3) {
            cArray[n4 + n2] = this.toClientArray[byArray[n4] & 0xFF];
            ++n4;
        }
    }

    private void _decode(byte[] byArray, int n2, char[] cArray, int n3) {
        int n4 = 0;
        for (int i2 = n3; i2 >= 10; i2 -= 10) {
            cArray[n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            cArray[++n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            ++n4;
        }
        while (n4 < n3) {
            cArray[n4] = this.toClientArray[byArray[n4 + n2] & 0xFF];
            ++n4;
        }
    }

    private void _decode(byte[] byArray, char[] cArray, int n2) {
        int n3 = 0;
        for (int i2 = n2; i2 >= 10; i2 -= 10) {
            cArray[n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            cArray[++n3] = this.toClientArray[byArray[n3] & 0xFF];
            ++n3;
        }
        while (n3 < n2) {
            cArray[n3] = this.toClientArray[byArray[n3] & 0xFF];
            ++n3;
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        this.setCacheSize(n3);
        if (n2 == 0) {
            this._decode(byArray, this.charsCache, n3);
        } else {
            this._decode(byArray, n2, this.charsCache, n3);
        }
        return new String(this.charsCache, 0, n3);
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        if (n2 == 0) {
            this._decode(byArray, cArray, n3);
        } else {
            this._decode(byArray, n2, cArray, n3);
        }
        return n3;
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5 = Math.max(n3, n4);
        this.setCacheSize(n5);
        if (n2 == 0) {
            this._decode(byArray, this.charsCache, n3);
        } else {
            this._decode(byArray, n2, this.charsCache, n3);
        }
        for (int i2 = n3; i2 < n4; ++i2) {
            this.charsCache[i2] = 32;
        }
        return new String(this.charsCache, 0, n4);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorUsingTable.this._in;
            }

            public int read() throws IOException {
                int n2 = this.in.read();
                if (n2 == -1) {
                    return -1;
                }
                return UtilTransliteratorUsingTable.this.toClientArray[n2 & 0xFF];
            }

            public int read(char[] cArray, int n2, int n3) throws IOException {
                int n4;
                if (this.cache == null || this.cache.length < n3) {
                    this.cache = new byte[n3];
                }
                if ((n4 = this.in.read(this.cache, 0, n3)) <= 0) {
                    return n4;
                }
                UtilTransliteratorUsingTable.this._decode(this.cache, cArray, n2, n4);
                return n4;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }

    private class ConversionTable {
        byte[] toServerArray;
        char[] toClientArray;
        byte[] unicodeBytes;
        char[] unicodeChars;
        int unicodeCount;
        byte encodedUndefinedCharacter;

        private ConversionTable() {
        }
    }
}

