/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseSQLNodeLocator;
import java.sql.SQLException;

public class BaseSQLTreeNode {
    static final int NODE_ESCAPE_ROOT = 8192;
    static final int NODE_TIME_ESCAPE = 8193;
    static final int NODE_DATE_ESCAPE = 8194;
    static final int NODE_TIMESTAMP_ESCAPE = 8196;
    static final int NODE_FUNCTION_ESCAPE = 8200;
    static final int NODE_OUTER_JOIN_ESCAPE = 8208;
    static final int NODE_CALL_PROCEDURE_ESCAPE = 8209;
    static final int NODE_CALL_FUNCTION_ESCAPE = 8210;
    static final int NODE_ESCAPE_ESCAPE = 8212;
    static final int NODE_ROOT = 1001;
    static final int NODE_STATEMENT_ROOT = 1002;
    static final int NODE_SELECT_STATEMENT = 1003;
    static final int NODE_INSERT_STATEMENT = 1004;
    static final int NODE_UPDATE_STATEMENT = 1005;
    static final int NODE_UNKNOWN_STATEMENT = 1006;
    static final int NODE_PAREN_ROOT = 1007;
    static final int NODE_FROM_CLAUSE = 1008;
    static final int NODE_WHERE_CLAUSE = 1009;
    static final int NODE_GROUPBY_CLAUSE = 1010;
    static final int NODE_SETOP_ROOT = 1011;
    static final int NODE_ORDERBY_CLAUSE = 1012;
    static final int NODE_HAVING_CLAUSE = 1013;
    static final int NODE_LIST_PART = 1014;
    static final int NODE_STATEMENT_SEPARATOR = 1015;
    static final int NODE_UNKNOWN = 1016;
    static final int NODE_PARAMETER = 1018;
    static final int NODE_COMMA = 1019;
    static final int NODE_WHITESPACE = 1020;
    static final int NODE_COMMENT = 1021;
    static final int NODE_QUERY_EXP = 1022;
    static final int NODE_TABLE_REFERENCE = 1023;
    static final int NODE_ESCAPE_PARAMETER = 1024;
    static final int NODE_LEFT_OUTER_JOIN_OP = 1035;
    static final int NODE_RIGHT_OUTER_JOIN_OP = 1036;
    static final int NODE_FULL_OUTER_JOIN_OP = 1037;
    static final int NODE_SEARCH_CONDITION = 1038;
    static final int NODE_CREATE_TABLE_STATEMENT = 1039;
    static final int NODE_FOR_CLAUSE = 1040;
    static final int NODE_PREDICATE_ROOT = 1041;
    static final int NODE_PREDICATE_TYPE_ROOT = 1042;
    static final int NODE_COMPARISON_PREDICATE_ROOT = 1043;
    static final int NODE_BETWEEN_PREDICATE_ROOT = 1044;
    static final int NODE_IN_PREDICATE_ROOT = 1045;
    static final int NODE_LIKE_PREDICATE_ROOT = 1046;
    static final int NODE_VALUE_EXPRESSION_ROOT = 1047;
    int type;
    String value;
    BaseSQLTreeNode parent;
    BaseSQLTreeNode rightSibling;
    BaseSQLTreeNode leftMostChild;

    BaseSQLTreeNode(int n2) {
        this.type = n2;
    }

    BaseSQLTreeNode(int n2, String string) {
        this.type = n2;
        this.value = string;
    }

    public void setParent(BaseSQLTreeNode baseSQLTreeNode) {
        this.parent = baseSQLTreeNode;
    }

    public BaseSQLTreeNode getParent() {
        return this.parent;
    }

    public void setNextChild(BaseSQLTreeNode baseSQLTreeNode) {
        if (baseSQLTreeNode != null) {
            baseSQLTreeNode.parent = this;
            if (this.leftMostChild == null) {
                this.leftMostChild = baseSQLTreeNode;
            } else {
                BaseSQLTreeNode baseSQLTreeNode2 = this.leftMostChild;
                while (baseSQLTreeNode2.rightSibling != null) {
                    baseSQLTreeNode2 = baseSQLTreeNode2.rightSibling;
                }
                baseSQLTreeNode2.rightSibling = baseSQLTreeNode;
            }
            while (baseSQLTreeNode.rightSibling != null) {
                baseSQLTreeNode.rightSibling.parent = this;
                baseSQLTreeNode = baseSQLTreeNode.rightSibling;
            }
        }
    }

    public void setRightSibling(BaseSQLTreeNode baseSQLTreeNode) {
        this.rightSibling = baseSQLTreeNode;
    }

    public void addNextSibling(BaseSQLTreeNode baseSQLTreeNode) {
        if (baseSQLTreeNode != null) {
            BaseSQLTreeNode baseSQLTreeNode2 = this;
            while (baseSQLTreeNode2.rightSibling != null) {
                baseSQLTreeNode2 = baseSQLTreeNode2.rightSibling;
            }
            baseSQLTreeNode2.rightSibling = baseSQLTreeNode;
            baseSQLTreeNode.parent = this.parent;
        }
    }

    public BaseSQLTreeNode leftMostChild() {
        return this.leftMostChild;
    }

    public BaseSQLTreeNode getRightSibling() {
        return this.rightSibling;
    }

    public BaseSQLTreeNode getPrevious() {
        BaseSQLTreeNode baseSQLTreeNode = null;
        if (this.parent != null) {
            BaseSQLTreeNode baseSQLTreeNode2 = this.parent.leftMostChild;
            while (baseSQLTreeNode2 != this) {
                baseSQLTreeNode = baseSQLTreeNode2;
                baseSQLTreeNode2 = baseSQLTreeNode2.rightSibling;
            }
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.parent;
            }
        }
        return baseSQLTreeNode;
    }

    public void removeChildren() {
        if (this.leftMostChild != null) {
            BaseSQLTreeNode baseSQLTreeNode = this.leftMostChild;
            this.leftMostChild = null;
            while (baseSQLTreeNode != null) {
                baseSQLTreeNode.parent = null;
                baseSQLTreeNode = baseSQLTreeNode.rightSibling;
            }
        }
    }

    public void replaceSubTreeWithSingleNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.leftMostChild = baseSQLTreeNode;
        baseSQLTreeNode.parent = this;
    }

    public void replaceRange(BaseSQLTreeNode baseSQLTreeNode, BaseSQLTreeNode baseSQLTreeNode2, BaseSQLTreeNode baseSQLTreeNode3, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreeNode baseSQLTreeNode4;
        BaseSQLTreeNode baseSQLTreeNode5 = baseSQLTreeNode.getParent();
        if (baseSQLTreeNode5.leftMostChild == baseSQLTreeNode) {
            baseSQLTreeNode5.leftMostChild = baseSQLTreeNode3;
            baseSQLTreeNode3.parent = baseSQLTreeNode5;
        } else {
            baseSQLTreeNode4 = baseSQLTreeNode5.leftMostChild;
            while (baseSQLTreeNode4.rightSibling != baseSQLTreeNode) {
                baseSQLTreeNode4 = baseSQLTreeNode4.rightSibling;
            }
            baseSQLTreeNode4.rightSibling = baseSQLTreeNode3;
            baseSQLTreeNode3.parent = baseSQLTreeNode4.parent;
        }
        baseSQLTreeNode4 = baseSQLTreeNode;
        while (!this.existsInSubtree(baseSQLTreeNode4, baseSQLTreeNode2, baseExceptions)) {
            baseSQLTreeNode4 = baseSQLTreeNode4.rightSibling;
        }
        baseSQLTreeNode3.rightSibling = baseSQLTreeNode4.rightSibling;
    }

    private boolean existsInSubtree(BaseSQLTreeNode baseSQLTreeNode, BaseSQLTreeNode baseSQLTreeNode2, BaseExceptions baseExceptions) throws SQLException {
        if (baseSQLTreeNode == baseSQLTreeNode2) {
            return true;
        }
        BaseSQLNodeLocator baseSQLNodeLocator = new BaseSQLNodeLocator();
        return baseSQLNodeLocator.exists(baseSQLTreeNode, baseSQLTreeNode2, baseExceptions);
    }
}

