/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.security.IAIKSecurityProvider;
import com.metamatrix.sequelink.security.SLCryptoJDK11;
import com.metamatrix.sequelink.security.SLCryptoJava2;
import com.metamatrix.sequelink.util.JDKVersionChecker;
import iaik.security.provider.IAIK;
import iaik.security.random.AutoSeedGenerator;
import iaik.security.random.MetaSeedGenerator;
import iaik.security.random.SecRandom;
import iaik.security.random.SeedGenerator;
import iaik.security.ssl.SecurityProvider;
import iaik.security.ssl.SessionManager;
import java.security.Provider;
import java.security.SecureRandom;

public abstract class SLCrypto {
    private static SLCrypto oneAndOnly;
    private static SecureRandom random;
    private static boolean prngSet;
    static /* synthetic */ Class class$iaik$security$random$MetaSeedGenerator;

    protected SLCrypto() {
        Provider[] providerArray = new Provider[]{new IAIK()};
        this.addProviders(providerArray);
        SecurityProvider.setSecurityProvider(new IAIKSecurityProvider());
        SessionManager.setDefault(null);
    }

    public static synchronized void init() {
        if (!prngSet) {
            SLCrypto.setRandom();
        }
    }

    public static synchronized void init(boolean bl) {
        if (!prngSet && bl) {
            SLCrypto.setRandom();
        }
    }

    private static void setRandom() {
        AutoSeedGenerator autoSeedGenerator = new AutoSeedGenerator();
        MetaSeedGenerator.setSeed((byte[])autoSeedGenerator.getSeed());
        SeedGenerator.setDefault((Class)(class$iaik$security$random$MetaSeedGenerator == null ? (class$iaik$security$random$MetaSeedGenerator = SLCrypto.class$("iaik.security.random.MetaSeedGenerator")) : class$iaik$security$random$MetaSeedGenerator));
        random = SecRandom.getDefault();
        prngSet = true;
    }

    public static synchronized SecureRandom getRandom() throws IllegalStateException {
        if (!prngSet) {
            throw new IllegalStateException();
        }
        return random;
    }

    protected abstract void addProviders(Provider[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        prngSet = false;
        oneAndOnly = JDKVersionChecker.isJava2() ? new SLCryptoJava2() : new SLCryptoJDK11();
    }
}

