/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkStreamColumn;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.SequeLinkInputStream;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilPagedTempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class SequeLinkLongvarbinaryColumn
extends SequeLinkStreamColumn {
    private UtilPagedTempBuffer temp;
    private boolean cached;
    private boolean cachedSQLNULL;

    public SequeLinkLongvarbinaryColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, 14);
    }

    protected void setBindInfo() {
        this.sqlnkType = 5;
        this.sqlnkSize = this.precision;
        if (this.maxFieldSize != 0) {
            this.sqlnkSize = Math.min(this.sqlnkSize, this.maxFieldSize);
        }
    }

    public int readLongData(SspInputStream sspInputStream, byte[] byArray, int n2, int n3) throws IOException {
        return sspInputStream.readSSPLongVarBinary(byArray, n2, n3);
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        InputStream inputStream;
        if (this.cached) {
            inputStream = this.cachedSQLNULL ? null : this.temp.getInputStream();
            this.cached = false;
        } else {
            inputStream = this.getBinaryStream(diagnosticList);
        }
        this.myBaseData.setBinaryStream(inputStream);
        return this.myBaseData;
    }

    public void cacheData(int n2, DiagnosticList diagnosticList) throws SQLException {
        InputStream inputStream = this.getBinaryStream(diagnosticList);
        if (inputStream == null) {
            this.cachedSQLNULL = true;
        } else {
            this.cachedSQLNULL = false;
            if (this.temp == null) {
                this.temp = new UtilPagedTempBuffer(2048);
            }
            byte[] byArray = new byte[1024];
            int n3 = 0;
            int n4 = 0;
            try {
                while (n3 != -1) {
                    n3 = inputStream.read(byArray);
                    if (n3 == -1) continue;
                    this.temp.write(n4, byArray, 0, n3);
                    n4 += n3;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            catch (UtilException utilException) {
                throw new SQLException(utilException.toString());
            }
        }
        this.cached = true;
    }

    public void clearCache() {
        this.cached = false;
        this.cachedSQLNULL = false;
        if (this.temp != null) {
            try {
                this.temp.truncate();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
    }

    public void cleanUp() {
        if (this.temp != null) {
            try {
                this.temp.truncate(true);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            this.temp = null;
        }
    }

    private InputStream getBinaryStream(DiagnosticList diagnosticList) throws SQLException {
        SequeLinkInputStream sequeLinkInputStream = new SequeLinkInputStream(this, diagnosticList);
        if (sequeLinkInputStream.isNull()) {
            return null;
        }
        return sequeLinkInputStream;
    }
}

