/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.OutputStream;

public class SybaseTDSBlobOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   3.0.6.0  $";
    public static final int CHUNKSIZE = 2048;
    private byte[] chunk = new byte[2048];
    private int chunkLength = 0;
    private long totalWritten = 0L;
    private boolean headerWritten;
    UtilByteOrderedDataWriter writer;

    SybaseTDSBlobOutputStream(UtilByteOrderedDataWriter utilByteOrderedDataWriter) {
        this.writer = utilByteOrderedDataWriter;
        this.headerWritten = false;
    }

    private void writeHeader() throws UtilException {
        if (!this.headerWritten) {
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.writer.writeInt8(0);
            this.headerWritten = true;
        }
    }

    public void write(int n) throws IOException {
        try {
            ++this.totalWritten;
            this.writeHeader();
            if (this.chunkLength == 2048) {
                this.writer.writeInt32(Integer.MIN_VALUE + this.chunkLength);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
                this.chunkLength = 0;
            }
            this.chunk[this.chunkLength++] = (byte)n;
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.writeHeader();
            this.totalWritten += (long)n2;
            if (this.chunkLength != 0 && n2 + this.chunkLength > 2048) {
                this.writer.writeInt32(-2147481600);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
                this.writer.writeBytes(byArray, n, 2048 - this.chunkLength);
                n += 2048 - this.chunkLength;
                n2 -= 2048 - this.chunkLength;
                this.chunkLength = 0;
            }
            while (n2 >= 2048) {
                this.writer.writeInt32(-2147481600);
                this.writer.writeBytes(byArray, n, 2048);
                n += 2048;
                n2 -= 2048;
            }
            if (n2 > 0) {
                System.arraycopy(byArray, n, this.chunk, this.chunkLength, n2);
                this.chunkLength += n2;
            }
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }

    public void close() throws IOException {
        try {
            this.writeHeader();
            if (this.totalWritten == 0L) {
                this.writer.writeInt32(Integer.MIN_VALUE);
            } else if (this.chunkLength > 0) {
                this.writer.writeInt32(Integer.MIN_VALUE + this.chunkLength);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
            }
            this.writer.writeInt32(0);
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }
}

