/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class DRDAStatementRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.57.1.6  $";
    public BaseColumns columnDescriptions;
    public UtilPagedTempBuffer lobBuffer;
    public boolean cursorIsScrollable;
    public short cursorUpdateAbility;
    public short cursorSensitivity;
    public int[] doubleByteColumns;
    public BaseParameters parameterDescriptions;
    private UtilVectorUnsynced fdocaMap;
    private boolean hasEarlyDesc;
    public int numResultSets;
    public DRDAPkgNamCsn[] packageNameCsnList;
    public DB2ImplResultSet[] resultSetArray;
    public boolean reExecutingWithParamInfos;
    public boolean reExecutingWithClobSubstitution;
    int[] lobColumns;
    int lobInsertPos = 0;
    public DRDAParameter lobLocParam;
    public boolean hasLobCols;
    public UtilVectorUnsynced storedProcedureParams;
    public boolean hasClobColumns = false;
    public int queryDataLen;
    int[] type;
    public int numParams;

    public DRDAStatementRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
        this.packageConsistencyToken = dRDAPkgNamCsn;
        this.chainCommit = true;
        this.hasLobCols = false;
    }

    public void setParameters(BaseParameters baseParameters) {
        this.parameterDescriptions = baseParameters;
        if (baseParameters != null) {
            this.numParams = this.parameterDescriptions.count();
        }
        this.lobInsertPos = 0;
        if (this.lobColumns != null) {
            int n = 0;
            while (n < this.lobColumns.length - 1) {
                this.lobColumns[n] = 0;
                ++n;
            }
        }
    }

    public BaseColumns getColumns() {
        return new BaseColumns();
    }

    public void setToPrepared() throws SQLException {
        try {
            this.clearExceptions();
            this.storedProcedureParams = null;
            this.writer.empty();
            this.lobLocParam = null;
            this.lobInsertPos = 0;
            this.fdocaMap = null;
            this.hasEarlyDesc = false;
            this.numRowsAffected = 0;
            this.checkingForAdditionalUpdateCounts = false;
            this.queryDataEndPosition = 0L;
            this.queryDataLen = 0;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void reset() throws SQLException {
        this.clearExceptions();
        this.chainCommit = true;
        this.hasClobColumns = false;
        this.columnDescriptions = null;
        this.isStoredProcedure = false;
        this.lobLocParam = null;
        this.numResultSets = 0;
        this.packageNameCsnList = null;
        this.parameterDescriptions = null;
        this.queryDataEndPosition = 0L;
        this.queryDataLen = 0;
        this.reExecutingWithClobSubstitution = false;
        this.reExecutingWithParamInfos = false;
        this.resultSetArray = null;
        if (this.storedProcedureParams != null) {
            this.storedProcedureParams.clear();
        }
        this.lobColumns = null;
        this.lobInsertPos = 0;
        if (this.fdocaMap != null) {
            this.fdocaMap.clear();
        }
        this.hasEarlyDesc = false;
    }

    public final void writePRPSQLSTT(String string, boolean bl, boolean bl2) throws SQLException {
        try {
            int n;
            int n2;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = this.writer.writePacketHeader((short)1, (short)64, 1);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = 2;
            }
            n = this.writer.writePacketHeader((short)1, (short)80, n2);
            int n3 = this.writer.writeCodePoint((short)8205);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8470);
            if (bl) {
                this.writer.writeInt8(241);
                if (this.comm.supportsExtendedTypSQLDA) {
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(8518);
                    this.writer.writeInt8(4);
                }
            } else {
                this.writer.writeInt8(240);
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n);
            int n4 = 0;
            n4 = bl2 ? this.writer.writePacketHeader((short)3, (short)0, n2) : this.writer.writePacketHeader((short)3, (short)64, n2);
            int n5 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt8(255);
            } else if (this.comm.serverType == 2) {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            } else {
                this.writer.writeEncodedStringWithLength16(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt16(0);
            }
            this.writer.writeCodePointLength(n5);
            this.writer.writePacketLength(n4);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public final void writeDSCSQLSTT() throws SQLException {
        try {
            int n;
            int n2;
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = this.writer.writePacketHeader((short)1, (short)0, n3);
            n = this.writer.writeCodePoint((short)8200);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8518);
            if (this.comm.supportsExtendedTypSQLDA) {
                this.writer.writeInt8(5);
            } else {
                this.writer.writeInt8(1);
            }
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public final void writeFDODSC(boolean bl) throws UtilException, SQLException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.numParams;
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = this.comm.drdaUtil.getRowLength(this.parameterDescriptions, this.numParams, this.comm.exceptions, this.implConn.db2Connection, this.doubleByteColumns);
            boolean bl4 = false;
            if (n5 > 32000 && this.comm.enableFullSizeLobs && this.comm.allowsInsertIntoVarcharAsClob) {
                bl3 = true;
            }
            if (n4 > 84) {
                n2 = n4 / 84;
                n3 = n4 % 84;
                if (n3 == 0) {
                    --n2;
                }
                n = 255;
            } else {
                n = n4 * 3 + 3;
            }
            this.writer.writeInt8(n);
            this.writer.writeBytes(DRDAConstants.GDA);
            int n6 = 0;
            while (n6 < n4) {
                int n7;
                bl2 = false;
                if (n2 != 0 && n6 % 84 == 0 && n6 != 0) {
                    n7 = 0;
                    n7 = n2 > 1 ? 255 : 3 * n3 + 3;
                    this.writer.writeInt8(n7);
                    this.writer.writeInt8(127);
                    this.writer.writeInt8(0);
                    --n2;
                }
                n7 = n6 + 1;
                BaseParameter baseParameter = this.parameterDescriptions.getInput(n7);
                BaseParameterInfo baseParameterInfo = this.parameterDescriptions.getParameterInfoOrNull(n6);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.getOutput(n7);
                    bl2 = true;
                } else if (this.isStoredProcedure) {
                    BaseParameter baseParameter2 = this.parameterDescriptions.getOutput(n7);
                    if (baseParameter2 != null) {
                        bl2 = true;
                    }
                    if (baseParameterInfo == null) {
                        baseParameterInfo = this.parameterDescriptions.getParameterInfo(n6);
                    }
                    if (baseParameter.sqlType != -3 && baseParameter.sqlType != -2 && baseParameter.sqlType != -4 && baseParameter.sqlType != 2004) {
                        baseParameter.sqlType = baseParameterInfo.sqlType;
                        baseParameter.scale = baseParameterInfo.scale;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("CHAR")) {
                        baseParameter.sqlType = -2;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("VARCHAR")) {
                        baseParameter.sqlType = -3;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("BLOB")) {
                        baseParameter.sqlType = 2004;
                        baseParameterInfo.sqlType = 2004;
                    } else {
                        baseParameter.sqlType = -4;
                    }
                }
                int n8 = 0;
                int n9 = -1;
                int n10 = 0;
                boolean bl5 = false;
                n10 = baseParameter.scale <= 0 ? 0 : (baseParameter.sqlType == 3 || baseParameter.sqlType == 2 ? baseParameter.scale : 0);
                if (baseParameter != null) {
                    switch (baseParameter.sqlType) {
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            long l = 0L;
                            int n11 = 1;
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        if (this.doubleByteColumns != null && this.doubleByteColumns[n6] != 0) {
                                            if (baseParameter.getType() == 17) {
                                                l = ((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                                break;
                                            }
                                            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                            baseParameter.setData(baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions));
                                            l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                            this.comm.DoubleByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                            l = utilPagedTempBuffer.getSize() / 2L;
                                            baseParameter.setData(17, new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), this.implConn.db2Connection, this.implConn.exceptions));
                                            break;
                                        }
                                        if (baseParameter.getType() == 16) {
                                            l = ((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                            break;
                                        }
                                        UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                        l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        this.comm.MultiByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                        l = utilPagedTempBuffer.getSize();
                                        baseParameter.setData(16, new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), this.implConn.db2Connection, this.implConn.exceptions));
                                        break;
                                    }
                                    case 2: {
                                        l = ((byte[])baseParameter.getObject()).length;
                                        break;
                                    }
                                    default: {
                                        if (this.lobLocParam != null) {
                                            baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                            l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                            break;
                                        }
                                        String string = baseParameter.getString(-1, this.comm.exceptions);
                                        if (this.comm.useMultiByteCPForParams) {
                                            baseParameter.setBytes(BaseParameter.stringToBytes(string, this.comm.MultiByteClientTransliterator, this.comm.exceptions));
                                        } else {
                                            baseParameter.setBytes(BaseParameter.stringToBytes(string, this.comm.SingleByteClientTransliterator, this.comm.exceptions));
                                        }
                                        l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (this.doubleByteColumns != null && this.doubleByteColumns[n6] != 0) {
                                if (this.doubleByteColumns[n6] == 412 || this.doubleByteColumns[n6] == 413 && l != 0L) {
                                    baseParameter.sqlType = 2005;
                                    if (this.lobColumns == null) {
                                        this.lobColumns = new int[84];
                                    }
                                    if (!baseParameter.isNull()) {
                                        this.lobColumns[this.lobInsertPos++] = n7;
                                    }
                                } else {
                                    if (l == 0L) {
                                        bl4 = true;
                                    }
                                    baseParameter.sqlType = -1;
                                }
                            } else if ((l <= 32704L || this.comm.serverOS == 8 && l <= 32740L) && !bl3) {
                                if (this.isStoredProcedure && !bl2 && l <= 254L && l != 0L) {
                                    if (!baseParameter.isNull() && baseParameterInfo.sqlType != 12 && baseParameterInfo.sqlType != -1) {
                                        baseParameter.sqlType = 1;
                                        n11 = 0;
                                    }
                                } else {
                                    baseParameter.sqlType = -1;
                                }
                            } else if (!this.comm.enableFullSizeLobs || l == 0L) {
                                baseParameter.sqlType = -1;
                            } else {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        break;
                                    }
                                    default: {
                                        if (baseParameter.isNull) break;
                                        baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, this.implConn.db2Connection, this.comm.exceptions));
                                    }
                                }
                                baseParameter.sqlType = 2005;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull()) {
                                    this.lobColumns[this.lobInsertPos++] = n7;
                                }
                            }
                            int n12 = this.doubleByteColumns != null && this.doubleByteColumns[n6] != 0 ? 1 : 0;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, n12 != 0, bl4);
                            n8 = this.type[0];
                            int n13 = this.type[1];
                            n9 = n11 != 0 ? n13 : (int)l;
                            if (this.lobLocParam != null) {
                                n8 = this.lobLocParam.fdocaType;
                                n9 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl5 = true;
                            bl4 = false;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            long l = 0L;
                            if (baseParameterInfo != null) {
                                baseParameter.sqlType = baseParameterInfo.sqlType;
                                if (baseParameterInfo.nativeTypeName == "ROWID") {
                                    baseParameter.nativeType = 30;
                                }
                            }
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 2: {
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                        break;
                                    }
                                    case 19: {
                                        l += ((BaseBlob)baseParameter.getObject()).length();
                                        break;
                                    }
                                    case 14: {
                                        if (this.comm.sendStreamAsBlob) {
                                            baseParameter.sqlType = 2004;
                                        }
                                        l += ((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        break;
                                    }
                                    default: {
                                        baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (l <= 32704L && baseParameter.sqlType != 2004) {
                                baseParameter.sqlType = -4;
                            } else if (this.comm.enableFullSizeLobs) {
                                baseParameter.sqlType = 2004;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull() && l != 0L) {
                                    this.lobColumns[this.lobInsertPos++] = n7;
                                }
                            } else {
                                baseParameter.sqlType = -4;
                            }
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n8 = this.type[0];
                            n9 = this.type[1];
                            if (this.lobLocParam != null) {
                                n8 = this.lobLocParam.fdocaType;
                                n9 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl5 = true;
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n13;
                            int n12;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n8 = this.type[0];
                            if (baseParameter.isNull()) {
                                if (bl2) {
                                    n10 = this.parameterDescriptions.getParameterInfo((int)n6).scale;
                                    n9 = this.parameterDescriptions.getParameterInfo((int)n6).precision;
                                } else {
                                    n9 = this.comm.serverOS == 8 ? 31 : 0;
                                    n10 = 0;
                                }
                                baseParameter.setNull(8);
                                break;
                            }
                            if (baseParameter.getType() == 2) {
                                n10 = baseParameter.scale;
                                n9 = baseParameter.getBytes(-1, this.comm.exceptions).length * 2 - 1;
                                break;
                            }
                            baseParameter.setBigDecimal(baseParameter.getBigDecimal(this.comm.exceptions));
                            BigDecimal bigDecimal = baseParameter.getBigDecimal(this.comm.exceptions);
                            baseParameter.scale = bigDecimal.scale();
                            n10 = bigDecimal.scale();
                            n9 = 0;
                            StringBuffer stringBuffer = null;
                            stringBuffer = (double)UtilJDKVersionChecker.getJVMVersion() >= 1.5 ? new StringBuffer(this.drdaUtil.bigDecToPlainString(bigDecimal)) : new StringBuffer(bigDecimal.toString());
                            if (stringBuffer.charAt(0) == '-') {
                                stringBuffer.append('D');
                            } else {
                                stringBuffer.append('C');
                            }
                            int n11 = 0;
                            while (n11 < stringBuffer.length()) {
                                if (stringBuffer.charAt(n11) == '.' || stringBuffer.charAt(n11) == '-') {
                                    stringBuffer.deleteCharAt(n11);
                                }
                                ++n11;
                            }
                            n9 = stringBuffer.length() - 1;
                            if (this.isStoredProcedure) {
                                n9 = baseParameterInfo.precision;
                                n10 = baseParameter.scale > baseParameterInfo.scale ? baseParameter.scale : baseParameterInfo.scale;
                                n12 = baseParameterInfo.scale - bigDecimal.scale();
                                n13 = stringBuffer.length() - 1;
                                int n14 = 0;
                                while (n14 < n12) {
                                    stringBuffer.insert(n13, 0);
                                    ++n14;
                                }
                                int n15 = n9 - (stringBuffer.length() - 1);
                                int n16 = 0;
                                while (n16 < n15) {
                                    stringBuffer.insert(0, 0);
                                    ++n16;
                                }
                            }
                            if (stringBuffer.length() % 2 != 0) {
                                stringBuffer.insert(0, 0);
                            }
                            baseParameter.setData(2, this.drdaUtil.convertStringBufferToDRDADecimal(stringBuffer));
                            break;
                        }
                        case -7: 
                        case -6: 
                        case 16: {
                            baseParameter.sqlType = 5;
                        }
                        case 5: {
                            n10 = 0;
                            break;
                        }
                        case 7: {
                            if (!baseParameter.isNull()) {
                                if (baseParameter.getType() == 6 && !this.isStoredProcedure) {
                                    baseParameter.setDouble(baseParameter.getDouble(this.comm.exceptions));
                                    baseParameter.sqlType = 6;
                                    break;
                                }
                                baseParameter.setFloat(baseParameter.getFloat(this.comm.exceptions));
                                break;
                            }
                            baseParameter.setNull(6);
                            break;
                        }
                        case -5: {
                            bl5 = true;
                            break;
                        }
                    }
                }
                if (n9 == -1) {
                    this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                    n8 = this.type[0];
                    n9 = this.type[1];
                }
                this.writer.writeInt8(n8);
                baseParameter.nativeType = n8;
                if (bl5) {
                    if (!this.comm.isServerBigEndianOS) {
                        this.reader.interpretAsBigEndian = false;
                    }
                    this.writer.writeInt16(n9);
                } else if (baseParameter.sqlType == 3 || baseParameter.sqlType == 2) {
                    this.writer.writeInt8(n9);
                    this.writer.writeInt8(n10);
                } else {
                    this.writer.writeInt8(n10);
                    this.writer.writeInt8(n9);
                }
                this.reader.interpretAsBigEndian = true;
                ++n6;
            }
            this.writer.writeBytes(DRDAConstants.ROWDESC);
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeFDODTA() throws SQLException {
        try {
            boolean bl = false;
            this.writer.writeInt8(0);
            int n = 0;
            while (true) {
                if (n >= this.numParams) {
                    return;
                }
                bl = false;
                int n2 = n + 1;
                BaseParameter baseParameter = this.parameterDescriptions.get(n2, 1);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.get(n2, 2);
                    bl = true;
                }
                if (baseParameter != null) {
                    if (baseParameter.isNull()) {
                        this.writer.writeInt8(255);
                    } else {
                        if (this.lobLocParam != null) {
                            if (this.lobLocParam.fdocaType % 2 != 0) {
                                this.writer.writeInt8(0);
                            }
                        } else {
                            this.writer.writeInt8(0);
                        }
                        block1 : switch (baseParameter.sqlType) {
                            case 2004: {
                                baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, this.implConn.db2Connection, this.comm.exceptions));
                                this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                                break;
                            }
                            case 2005: {
                                if (this.doubleByteColumns != null && this.doubleByteColumns[n] != 0) {
                                    this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength() / 2);
                                    break;
                                }
                                this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                                break;
                            }
                            case -7: {
                                if (baseParameter.getBoolean(this.comm.exceptions)) {
                                    if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                                        this.writer.writeInt8(49);
                                        break;
                                    }
                                    this.writer.writeInt8(241);
                                    break;
                                }
                                if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                                    this.writer.writeInt8(48);
                                    break;
                                }
                                this.writer.writeInt8(240);
                                break;
                            }
                            case 5: {
                                this.writer.writeInt16(baseParameter.getShort(this.comm.exceptions));
                                break;
                            }
                            case 4: {
                                this.writer.writeInt32(baseParameter.getInteger(this.comm.exceptions));
                                break;
                            }
                            case -5: {
                                if (baseParameter.nativeType == 23 || baseParameter.nativeType == 22) {
                                    this.writer.writeInt64(baseParameter.getLong(this.comm.exceptions));
                                    break;
                                }
                                this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                                break;
                            }
                            case 7: {
                                this.writer.writeIEEE32BitFloat(baseParameter.getFloat(this.comm.exceptions));
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                break;
                            }
                            case 91: {
                                this.writer.writeEncodedString(baseParameter.getDate(this.comm.exceptions).toString(), this.comm.SingleByteClientTransliterator);
                                break;
                            }
                            case 92: {
                                Object object = new StringBuffer(baseParameter.getTime(this.comm.exceptions).toString());
                                ((StringBuffer)object).setCharAt(2, '.');
                                ((StringBuffer)object).setCharAt(5, '.');
                                this.writer.writeEncodedString(((StringBuffer)object).toString(), this.comm.SingleByteClientTransliterator);
                                break;
                            }
                            case 93: {
                                Object object = baseParameter.getTimestamp(this.comm.exceptions);
                                String string = ((BaseTimestamp)object).toString();
                                int n3 = 20;
                                String string2 = string.substring(string.lastIndexOf(".") + 1);
                                if (string.length() > n3) {
                                    string = string.substring(0, n3);
                                }
                                if (string2.length() > 6) {
                                    string2 = string2.substring(0, 6);
                                } else {
                                    while (string2.length() < 6) {
                                        string2 = string2 + "0";
                                    }
                                }
                                StringBuffer stringBuffer = new StringBuffer(string + string2);
                                stringBuffer.setCharAt(10, '-');
                                stringBuffer.setCharAt(13, '.');
                                stringBuffer.setCharAt(16, '.');
                                this.writer.writeEncodedString(stringBuffer.toString(), this.comm.SingleByteClientTransliterator);
                                break;
                            }
                            case 1: {
                                switch (baseParameter.getType()) {
                                    case 18: {
                                        this.writer.writeReader(baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 16: {
                                        this.writer.writeStream(baseParameter.getUTF8InputStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 15: {
                                        this.writer.writeStream(baseParameter.getASCIIStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 17: {
                                        this.writer.writeStream(baseParameter.getUCS2InputStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                }
                                this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                break;
                            }
                            case -1: 
                            case 12: {
                                switch (baseParameter.getType()) {
                                    case 18: {
                                        this.writer.writeReaderWithLength16(baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 16: {
                                        this.writer.writeStreamWithLength16(baseParameter.getUTF8InputStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 15: {
                                        this.writer.writeStreamWithLength16(baseParameter.getASCIIStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                    case 17: {
                                        this.writer.writeStreamWithLength16(baseParameter.getUCS2InputStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                        break block1;
                                    }
                                }
                                this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                                this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                break;
                            }
                            case -2: {
                                this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                break;
                            }
                            case -4: 
                            case -3: {
                                if (baseParameter.getType() == 14) {
                                    this.writer.writeStreamWithLength16(baseParameter.getBinaryStream(-1, this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                    break;
                                }
                                this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                                this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                break;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8521: {
                    if (this.reader.readInt8() == 241) {
                        this.cursorIsScrollable = true;
                        return true;
                    }
                    this.cursorIsScrollable = false;
                    return true;
                }
                case 8528: {
                    this.cursorUpdateAbility = this.reader.readInt8();
                    return true;
                }
                case 8535: {
                    this.cursorSensitivity = this.reader.readInt8();
                    return true;
                }
                case 9243: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                    } else if ((short)(n + 4) == -32764) {
                        n = this.reader.queryDataLength;
                    }
                    this.queryDataLen = n;
                    this.queryDataEndPosition = this.reader.readPosition + n;
                    if (this.processMode == 1) return false;
                    if (this.processMode == 0) {
                        return false;
                    }
                }
                case 8706: {
                    this.isCursorOpen = false;
                    if (this.continuingQuery) {
                        this.exception = this.comm.exceptions.getException(7080);
                        return true;
                    }
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                case 8716: {
                    return true;
                }
                case 8715: 
                case 8722: {
                    this.moreData = false;
                    return true;
                }
                case 8719: {
                    this.reader.readAndDiscardBytes(n);
                    this.isCursorOpen = false;
                    this.moreData = false;
                    return true;
                }
                case 8479: {
                    if (this.reader.readUnsignedInt8() != 241) return true;
                    this.isCursorHeldOpen = true;
                    return true;
                }
                case 8469: {
                    this.implConn.endUnitOfWork(this.reader.readInt8());
                    return true;
                }
                case 9233: {
                    if (n == 32772) {
                        this.reader.readAndDiscardBytes(4);
                    }
                    this.processSQLCA(baseWarnings);
                    if (this.comm.SQLAMLevel >= 7) {
                        this.processSQLDH(baseWarnings);
                    }
                    this.processSQLDA(baseWarnings);
                    return this.processMode != 3;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void processEXTDTAParam(DRDAParameter dRDAParameter, boolean bl) throws SQLException {
        try {
            int n = new Long(dRDAParameter.lobLength).intValue();
            boolean bl2 = false;
            if (n != 0) {
                int n2 = 0;
                short s = this.reader.readInt16();
                if (s == -32760) {
                    this.reader.readAndDiscardBytes(2);
                    n2 = this.reader.readInt32();
                } else {
                    this.reader.readAndDiscardBytes(2);
                    n2 = s - 4;
                }
                if (dRDAParameter.isNullable && this.comm.SQLAMLevel >= 7) {
                    bl2 = this.reader.readUnsignedInt8() == 255;
                    --n2;
                }
                if (bl) {
                    this.reader.readAndDiscardBytes(n2);
                } else {
                    long l = 0L;
                    this.lobBuffer = new UtilPagedTempBuffer();
                    if (!bl2) {
                        if (dRDAParameter.baseParam.sqlType == 2005) {
                            int n3 = 0;
                            char[] cArray = new char[8192];
                            UtilTransliterator utilTransliterator = this.reader.transliterator;
                            this.reader.transliterator = dRDAParameter.baseParam.transliterator;
                            Reader reader = this.reader.getReader(n2);
                            while (n3 != -1) {
                                n3 = reader.read(cArray, 0, 8192);
                                if (n3 == -1) continue;
                                l += (long)this.lobBuffer.write(l, this.drdaUtil.UCS2CharsToBytes(cArray, n3));
                            }
                            dRDAParameter.baseParam.setData(20, new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                            this.reader.transliterator = utilTransliterator;
                        } else {
                            int n4 = 0;
                            byte[] byArray = new byte[16384];
                            while (n2 > 0) {
                                n4 = this.reader.readBytes(byArray, 0, Math.min(16384, n2));
                                l += (long)this.lobBuffer.write(l, byArray, 0, n4);
                                n2 -= n4;
                            }
                            dRDAParameter.baseParam.setData(19, new DB2ImplBlob(n, this.implConn, this.lobBuffer));
                        }
                    } else if (dRDAParameter.baseParam.sqlType == 2005) {
                        dRDAParameter.baseParam.setData(20, new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                    } else {
                        dRDAParameter.baseParam.setData(19, new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                    }
                }
            } else {
                this.lobBuffer = new UtilPagedTempBuffer();
                if (dRDAParameter.baseParam.sqlType == 2005) {
                    dRDAParameter.baseParam.setData(20, new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                } else {
                    dRDAParameter.baseParam.setData(19, new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                }
            }
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
        dRDAParameter.readExtendedData = true;
    }

    public final void processFDODSC(int n, boolean bl) throws UtilException {
        int n2 = this.reader.readPosition + n;
        String[] stringArray = new String[1];
        do {
            int n3 = this.reader.readUnsignedInt8asInt();
            byte by = this.reader.readInt8();
            n3 -= 2;
            switch (by) {
                case 118: {
                    this.reader.readAndDiscardBytes(1);
                    if (bl) {
                        this.updateParameterDescriptions();
                        break;
                    }
                    this.updateColumnDescriptions();
                    break;
                }
                case 127: {
                    if (bl) {
                        this.updateParameterDescriptions();
                        break;
                    }
                    this.updateColumnDescriptions();
                    break;
                }
                case 120: {
                    short s;
                    short s2 = this.reader.readInt16();
                    byte[] byArray = new byte[2];
                    this.reader.readBytes(byArray, 0, byArray.length);
                    if (byArray[0] != 1) {
                        s = this.reader.readInt8();
                        break;
                    }
                    s = this.reader.readUnsignedInt8();
                    byte by2 = this.reader.readInt8();
                    byte by3 = this.reader.readInt8();
                    int[] nArray = new int[]{this.reader.readUnsignedInt8(), s, this.reader.readUnsignedInt8(), this.reader.readInt32(), this.reader.readInt8(), this.reader.readInt8(), this.reader.readUnsignedInt16()};
                    if (this.fdocaMap == null) {
                        this.fdocaMap = new UtilVectorUnsynced();
                    }
                    int n4 = this.fdocaMap.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        if (((int[])this.fdocaMap.get(n5))[0] == nArray[0]) {
                            this.fdocaMap.set(n5, nArray);
                        }
                        ++n5;
                    }
                    this.fdocaMap.addElement(nArray);
                    this.hasEarlyDesc = true;
                    break;
                }
                case 112: 
                case 113: {
                    this.reader.readAndDiscardBytes(n3);
                    break;
                }
                default: {
                    stringArray[0] = Integer.toHexString(by);
                    this.exception = this.comm.exceptions.getException(7073, stringArray);
                    this.reader.readAndDiscardBytes(n3);
                }
            }
        } while (this.reader.readPosition < n2 && this.reader.readPosition != 0);
    }

    public void updateColumnDescriptions() throws UtilException {
        int n = this.columnDescriptions.count(0);
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            bl = false;
            n2 = -1;
            if (n3 % 84 == 0 && n3 != 0) {
                this.reader.readAndDiscardBytes(3);
            }
            DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(n3 + 1);
            dRDAColumn.fdocaType = this.reader.readUnsignedInt8();
            if (this.hasEarlyDesc) {
                n4 = this.fdocaMap.size();
                int n5 = 0;
                while (n5 < n4) {
                    if (((int[])this.fdocaMap.get(n5))[0] == dRDAColumn.fdocaType) {
                        bl = true;
                        n2 = n5;
                        dRDAColumn.fdocaType = ((int[])this.fdocaMap.get(n5))[1];
                    }
                    ++n5;
                }
            }
            if (this.hasClobColumns && !this.comm.enableFullSizeLobs) {
                if (dRDAColumn.type != 2005) {
                    dRDAColumn.type = this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false);
                }
            } else {
                dRDAColumn.type = this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" ? this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, true) : this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false);
            }
            dRDAColumn.fdocaScale = 0;
            dRDAColumn.setLongDataBuffer();
            dRDAColumn.isNullable = dRDAColumn.fdocaType % 2 == 0 ? 0 : 1;
            if (dRDAColumn.transliterator == null) {
                dRDAColumn.transliterator = this.comm.SingleByteServerTransliterator;
            }
            if (bl && ((int[])this.fdocaMap.get(n2))[3] != 0) {
                dRDAColumn.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n2))[3]));
            }
            switch (dRDAColumn.type) {
                case 2004: {
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    n4 = this.reader.readUnsignedInt16();
                    dRDAColumn.isSigned = false;
                    this.hasLobCols = true;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen * 2;
                    dRDAColumn.isSigned = false;
                    break;
                }
                case 3: {
                    dRDAColumn.precision = this.reader.readInt8();
                    dRDAColumn.fdocaLen = dRDAColumn.precision / 2 + 1;
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.readInt8();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    break;
                }
                case 2: {
                    dRDAColumn.fdocaLen = dRDAColumn.precision = (int)this.reader.readInt8();
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.readInt8();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    break;
                }
                case 5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 5;
                    dRDAColumn.displaySize = 6;
                    break;
                }
                case 4: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 10;
                    dRDAColumn.displaySize = 11;
                    break;
                }
                case -5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 20;
                    dRDAColumn.displaySize = 21;
                    break;
                }
                case 7: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 7;
                    dRDAColumn.displaySize = dRDAColumn.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 15;
                    dRDAColumn.displaySize = dRDAColumn.precision + 7;
                    break;
                }
                case 2005: {
                    if (this.comm.enableFullSizeLobs) {
                        if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                            this.useOUTOVRlob = true;
                        }
                        n4 = this.reader.readUnsignedInt16();
                        dRDAColumn.isSigned = false;
                        dRDAColumn.isCaseSensitive = true;
                        this.hasLobCols = true;
                        break;
                    }
                    this.hasClobColumns = true;
                    dRDAColumn.isCaseSensitive = true;
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    dRDAColumn.scale = dRDAColumn.fdocaScale;
                    dRDAColumn.isSigned = false;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    dRDAColumn.isCaseSensitive = true;
                }
                default: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    if (dRDAColumn.isDoubleByteColumn && dRDAColumn.type == 1) {
                        dRDAColumn.fdocaLen *= 2;
                    }
                    dRDAColumn.precision = dRDAColumn.fdocaLen;
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    dRDAColumn.isSigned = false;
                    dRDAColumn.scale = dRDAColumn.type == 93 ? 6 : dRDAColumn.fdocaScale;
                }
            }
            ++n3;
        }
    }

    public final void updateParameterDescriptions() throws UtilException {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.numParams) {
            int n5;
            bl2 = false;
            n3 = -1;
            if (n4 % 84 == 0 && n4 != 0) {
                this.reader.readAndDiscardBytes(3);
            }
            int n6 = n4 + 1;
            BaseParameter baseParameter = this.parameterDescriptions.getOutput(n6);
            bl = true;
            if (baseParameter == null) {
                baseParameter = this.parameterDescriptions.getInput(n6);
                bl = false;
            }
            n2 = this.reader.readUnsignedInt8();
            if (this.hasEarlyDesc) {
                n5 = this.fdocaMap.size();
                int n7 = 0;
                while (n7 < n5) {
                    if (((int[])this.fdocaMap.get(n7))[0] == n2) {
                        bl2 = true;
                        n3 = n7;
                        n2 = ((int[])this.fdocaMap.get(n7))[1];
                    }
                    ++n7;
                }
            }
            n5 = this.drdaUtil.Drda2JdbcType(n2, false);
            if (bl2) {
                if (((int[])this.fdocaMap.get(n3))[3] != 0) {
                    baseParameter.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n3))[3]));
                }
            } else {
                baseParameter.transliterator = this.comm.SingleByteServerTransliterator;
            }
            switch (n5) {
                case 2: 
                case 3: {
                    n = this.reader.readInt8();
                    by = this.reader.readInt8();
                    break;
                }
                default: {
                    by = 0;
                    n = this.reader.readUnsignedInt16();
                }
            }
            if (this.storedProcedureParams == null) {
                this.storedProcedureParams = new UtilVectorUnsynced();
            }
            this.storedProcedureParams.add(new DRDAParameter(baseParameter, n2, n, by, bl));
            ++n4;
        }
    }

    public final void updateParameterData() throws UtilException {
        int n = this.storedProcedureParams.size();
        boolean bl = false;
        byte by = this.reader.readInt8();
        if (by == -1) {
            bl = true;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            DRDAParameter dRDAParameter = (DRDAParameter)this.storedProcedureParams.get(n2);
            dRDAParameter.isNullable = dRDAParameter.fdocaType % 2 != 0;
            boolean bl2 = false;
            if (dRDAParameter.isNullable && !bl) {
                n3 = this.reader.readUnsignedInt8();
                bl2 = n3 == 255 || n3 == 128;
            }
            n3 = this.drdaUtil.Drda2JdbcType(dRDAParameter.fdocaType, false);
            if (!bl2 && !bl) {
                switch (n3) {
                    case 1: {
                        dRDAParameter.baseParam.setData(10, this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        break;
                    }
                    case -1: 
                    case 12: {
                        short s = this.reader.readInt16();
                        dRDAParameter.baseParam.setData(10, this.reader.readEncodedString(s, dRDAParameter.baseParam.transliterator));
                        break;
                    }
                    case 2005: {
                        dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        dRDAParameter.hasExtendedData = true;
                        if (dRDAParameter.fdocaType == 204 || dRDAParameter.fdocaType == 205) {
                            dRDAParameter.baseParam.transliterator = this.comm.DoubleByteServerTransliterator;
                            dRDAParameter.baseParam.sqlType = n3;
                            break;
                        }
                        dRDAParameter.baseParam.transliterator = dRDAParameter.baseParam.transliterator;
                        break;
                    }
                    case 2004: {
                        dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        dRDAParameter.hasExtendedData = true;
                        break;
                    }
                    case -5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(5, new Long(this.reader.readInt64()));
                        break;
                    }
                    case 5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(3, new Short(this.reader.readInt16()));
                        break;
                    }
                    case 4: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(4, new Integer(this.reader.readInt32()));
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            long l = this.drdaUtil.ibm2IeeeDoubleFloat(this.reader.readInt64());
                            dRDAParameter.baseParam.setData(7, new Double(Double.longBitsToDouble(l)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(7, new Double(this.reader.readIEEE64BitDouble()));
                        break;
                    }
                    case 7: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            int n4 = this.drdaUtil.ibm2IeeeSingleFloat(this.reader.readInt32());
                            dRDAParameter.baseParam.setData(6, new Float(Float.intBitsToFloat(n4)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(6, new Float(this.reader.readIEEE32BitFloat()));
                        break;
                    }
                    case 3: {
                        int n5 = dRDAParameter.fdocaLen / 2 + 1;
                        Object object = new byte[n5];
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        this.reader.readBytes((byte[])object, 0, n5);
                        StringBuffer stringBuffer = new StringBuffer();
                        if ((object[n5 - 1] & 0xF) == 13) {
                            stringBuffer.append('-');
                        }
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = false;
                        int n9 = 0;
                        while (n9 < n5 - 1) {
                            n8 = object[n9];
                            n6 = n8 >>> 4 & 0xF;
                            n7 = n8 & 0xF;
                            stringBuffer.append(String.valueOf(n6) + String.valueOf(n7));
                            ++n9;
                        }
                        stringBuffer.append(String.valueOf(object[n5 - 1] >>> 4 & 0xF));
                        dRDAParameter.baseParam.setData(8, new BigDecimal(new BigInteger(stringBuffer.toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 2: {
                        int n10 = dRDAParameter.fdocaLen;
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        Object object = new StringBuffer(this.reader.readEncodedString(n10 - 1, dRDAParameter.baseParam.transliterator));
                        byte by2 = this.reader.readInt8();
                        if ((by2 >>> 4 & 0xF) == 13) {
                            ((StringBuffer)object).insert(0, '-');
                        }
                        ((StringBuffer)object).append(String.valueOf(by2 & 0xF));
                        dRDAParameter.baseParam.setData(8, new BigDecimal(new BigInteger(((StringBuffer)object).toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 91: {
                        StringBuffer stringBuffer;
                        Object object;
                        Date date = null;
                        if (this.isStoredProcedure) {
                            object = this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator);
                            if (((String)object).charAt(4) != '-') {
                                stringBuffer = new StringBuffer(10);
                                stringBuffer.append(((String)object).substring(6));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(0, 2));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(3, 5));
                                date = Date.valueOf(stringBuffer.toString());
                            } else {
                                date = Date.valueOf((String)object);
                            }
                        } else {
                            date = Date.valueOf(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        }
                        dRDAParameter.baseParam.setData(11, date);
                        break;
                    }
                    case 92: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(2, ':');
                        stringBuffer.setCharAt(5, ':');
                        dRDAParameter.baseParam.setData(12, Time.valueOf(stringBuffer.toString()));
                        break;
                    }
                    case 93: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(10, ' ');
                        stringBuffer.setCharAt(13, ':');
                        stringBuffer.setCharAt(16, ':');
                        dRDAParameter.baseParam.setData(13, BaseTimestamp.valueOf(stringBuffer.toString()));
                        break;
                    }
                    case -2: {
                        byte[] byArray = new byte[dRDAParameter.fdocaLen];
                        this.reader.readBytes(byArray, 0, dRDAParameter.fdocaLen);
                        dRDAParameter.baseParam.setData(2, byArray);
                        break;
                    }
                    case -4: 
                    case -3: {
                        short s = this.reader.readInt16();
                        Object object = new byte[s];
                        if (s != 0) {
                            this.reader.readBytes((byte[])object, 0, s);
                        }
                        dRDAParameter.baseParam.setData(2, object);
                    }
                }
                this.reader.interpretAsBigEndian = true;
            } else if (dRDAParameter.isOutParam) {
                dRDAParameter.baseParam.setNull(BaseData.getJavaObjectType(null, dRDAParameter.baseParam.sqlType));
            }
            ++n2;
        }
    }

    public final void processSQLCINRD() throws UtilException, SQLException {
        if (this.comm.SQLAMLevel >= 7) {
            this.processSQLDH(this.implConn.warnings);
            this.processSQLDA(this.implConn.warnings);
        } else {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            int n = this.reader.readInt16();
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
            this.reader.interpretAsBigEndian = true;
            int n2 = 0;
            while (n2 < n) {
                DRDAColumn dRDAColumn = new DRDAColumn(1);
                dRDAColumn.baseDataObj = new BaseData(10, null, this.implConn.db2Connection);
                dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(n2 + 1);
                dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.columnDescriptions.add(dRDAColumn);
                this.reader.interpretAsBigEndian = true;
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void processSQLDA(BaseWarnings var1_1) throws UtilException, SQLException {
        if (!this.comm.isServerBigEndianOS) {
            this.reader.interpretAsBigEndian = false;
        }
        var2_2 = this.reader.readInt16();
        if (this.processMode != 4) {
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
        }
        var3_3 = 0;
        while (var3_3 < var2_2) {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            var4_4 = this.reader.readInt16();
            var5_5 = this.reader.readInt16();
            var6_6 = 0;
            var6_6 = this.comm.SQLAMLevel >= 6 ? new Long(this.reader.readInt64()).intValue() : this.reader.readInt32();
            var7_7 = this.reader.readInt16();
            if (var7_7 == 412 || var7_7 == 413) {
                if (this.doubleByteColumns == null) {
                    this.doubleByteColumns = new int[var2_2];
                } else if (var2_2 > this.doubleByteColumns.length) {
                    this.doubleByteColumns = new int[var2_2];
                }
                this.doubleByteColumns[var3_3] = var7_7;
            }
            this.reader.interpretAsBigEndian = true;
            var8_8 = this.reader.readInt16();
            var9_9 = (var8_8 & 65535) == 65535;
            var10_10 = false;
            if (this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" && var9_9) {
                var10_10 = true;
                var9_9 = false;
                var8_8 = 0;
            }
            var11_11 = this.drdaUtil.DB2ToJdbcType(var7_7, var9_9, var6_6);
            var12_12 = new DRDAColumn(var11_11);
            var12_12.typeName = this.drdaUtil.getDB2TypeName(var7_7, var9_9, var6_6);
            if (var8_8 != 0 && !var9_9) {
                if (var8_8 == 1200) {
                    var12_12.isDoubleByteColumn = true;
                }
                var12_12.transliteratorCharSet = Integer.toString(var8_8);
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else if (var10_10) {
                var12_12.transliteratorCharSet = this.implConn.charSetFor65535;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else {
                var12_12.transliterator = this.comm.defaultCCSIDTransliterator;
            }
            if (this.implConn.codePageOverride != null) {
                var12_12.transliteratorCharSet = this.implConn.codePageOverride;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            }
            var12_12.isNullable = var7_7 % 2 == 0 ? 0 : 1;
            var12_12.baseDataObj = new BaseData(10, null, this.implConn.db2Connection);
            switch (var11_11) {
                case 2004: {
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                }
                case -4: 
                case -3: 
                case -2: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6 * 2;
                    var12_12.isSigned = false;
                    break;
                }
                case 2: 
                case 3: {
                    var12_12.precision = var4_4;
                    var12_12.scale = var5_5;
                    var12_12.displaySize = var12_12.precision + 3;
                    var12_12.fdocaLen = var12_12.precision / 2 + 1;
                    break;
                }
                case 5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 5;
                    var12_12.displaySize = 6;
                    break;
                }
                case 4: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 10;
                    var12_12.displaySize = 11;
                    break;
                }
                case -5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 20;
                    var12_12.displaySize = 21;
                    break;
                }
                case 7: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 7;
                    var12_12.displaySize = var12_12.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 15;
                    var12_12.displaySize = var12_12.precision + 7;
                    break;
                }
                case 2005: {
                    if (!this.comm.enableFullSizeLobs) {
                        this.hasClobColumns = true;
                    }
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    if (var7_7 != 412) ** GOTO lbl99
                    var12_12.fdocaType = 205;
                    ** GOTO lbl101
lbl99:
                    // 1 sources

                    if (var7_7 == 413) {
                        var12_12.fdocaType = 204;
                    }
                }
lbl101:
                // 5 sources

                case -1: 
                case 1: 
                case 12: {
                    var12_12.isCaseSensitive = true;
                }
                default: {
                    var12_12.fdocaLen = var6_6;
                    if (var12_12.isDoubleByteColumn && var12_12.type == 1) {
                        var12_12.fdocaLen *= 2;
                    }
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6;
                    var12_12.isSigned = false;
                    var12_12.scale = var11_11 == 93 ? 6 : (int)var5_5;
                }
            }
            if (this.comm.SQLAMLevel < 7) {
                var12_12.name = this.reader.readMutuallyExclusiveFDOCAString(var3_3 + 1);
                var12_12.label = this.reader.readMutuallyExclusiveFDOCAString(var12_12.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                if (this.comm.SQLAMLevel >= 6) {
                    this.processSQLUDT(var12_12, var1_1);
                }
            } else {
                this.processSQLDOPT(var12_12, var3_3, var1_1);
            }
            if (this.processMode == 4) {
                this.drdaUtil.convertColumnDescToParamDesc(var12_12, this.parameterDescriptions.getParameterInfo(var3_3));
            } else {
                this.columnDescriptions.add(var12_12);
            }
            ++var3_3;
        }
    }

    public final void processSQLDH(BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            String string = this.reader.readMutuallyExclusiveFDOCAString(this.implConn.user);
        }
    }

    public final void processSQLDOPT(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(n + 1);
            dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.processSQLUDT(dRDAColumn, baseWarnings);
            this.processSQLDX(dRDAColumn, n, baseWarnings);
        }
    }

    public final void processSQLUDT(DRDAColumn dRDAColumn, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.comm.SQLAMLevel >= 7) {
                this.reader.readAndDiscardBytes(4);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            } else {
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            }
        }
    }

    public final void processSQLDX(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.reader.readInt16() == 1) {
                dRDAColumn.isKey = true;
            }
            this.reader.readAndDiscardBytes(2);
            short s = this.reader.readInt16();
            if (s != 0) {
                dRDAColumn.isAutoIncrement = true;
            }
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readMutuallyExclusiveFDOCAString(0);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
        }
    }
}

