/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform;

import com.metamatrix.common.comm.platform.socket.PrintStreamSocketLog;
import com.metamatrix.common.comm.platform.socket.SocketLog;

public class SocketConstants {
    public static final String SOCKET_LOG_LEVEL = "metamatrix.sockets.log.level";
    public static final String SOCKET_MAX_THREADS = "metamatrix.sockets.max.threads";
    public static final String SOCKET_TTL = "metamatrix.sockets.ttl";
    public static final String SYNCH_SOCKET_TTL = "metamatrix.synchronous.sockets.ttl";
    public static final String SOCKET_INPUT_BUFFER_SIZE = "metamatrix.sockets.inputBufferSize";
    public static final String SOCKET_OUTPUT_BUFFER_SIZE = "metamatrix.sockets.outputBufferSize";
    public static final String SOCKET_CONSERVE_BANDWIDTH = "metamatrix.sockets.conserveBandwidth";
    public static final String DEFAULT_SOCKET_LOG_LEVEL = "ERROR";
    public static final int DEFAULT_MAX_THREADS = 15;
    public static final long DEFAULT_TTL = 120000L;
    public static final long DEFAULT_SYNCH_TTL = 120000L;
    public static final int DEFAULT_SOCKET_INPUT_BUFFER_SIZE = 102400;
    public static final int DEFAULT_SOCKET_OUTPUT_BUFFER_SIZE = 102400;

    public static long getTTL() {
        return Long.getLong(SOCKET_TTL, 120000L);
    }

    public static long getSynchronousTTL() {
        return Long.getLong(SYNCH_SOCKET_TTL, 120000L);
    }

    public static int getMaxThreads() {
        return Integer.getInteger(SOCKET_MAX_THREADS, 15);
    }

    public static SocketLog getLog(String contextName) {
        PrintStreamSocketLog result = new PrintStreamSocketLog(System.out, contextName, SocketConstants.getLogLevel());
        return result;
    }

    public static int getLogLevel() {
        String logLevelString = System.getProperty(SOCKET_LOG_LEVEL, DEFAULT_SOCKET_LOG_LEVEL);
        return PrintStreamSocketLog.getLogLevelInt(logLevelString);
    }

    public static int getInputBufferSize() {
        return Integer.getInteger(SOCKET_INPUT_BUFFER_SIZE, 102400);
    }

    public static int getOutputBufferSize() {
        return Integer.getInteger(SOCKET_OUTPUT_BUFFER_SIZE, 102400);
    }

    public static boolean getConserveBandwidth() {
        return Boolean.getBoolean(SOCKET_CONSERVE_BANDWIDTH);
    }
}

