/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.SecureConnectorState;
import com.metamatrix.connector.xml.TrustedPayloadHandler;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.XMLConnectorStateImpl;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public abstract class SecureConnectorStateImpl
extends XMLConnectorStateImpl
implements SecureConnectorState {
    private String securityDeserializerClass;

    public void setState(Properties props) throws ConnectorException {
        super.setState(props);
        String secure = props.getProperty("TrustDeserializerClass");
        if (secure == null || secure.equals("")) {
            throw new ConnectorException(Messages.getString("SecureConnectorStateImpl.empty.trust.deserializer"));
        }
        this.setSecurityDeserializerClass(secure);
        this.getTrustDeserializerInstance();
    }

    public Properties getState() {
        Properties props = super.getState();
        props.setProperty("TrustDeserializerClass", this.getSecurityDeserializerClass());
        return props;
    }

    private void setSecurityDeserializerClass(String secClass) {
        this.securityDeserializerClass = secClass;
    }

    public String getSecurityDeserializerClass() {
        return this.securityDeserializerClass;
    }

    public TrustedPayloadHandler getTrustDeserializerInstance() throws ConnectorException {
        Object secObj;
        try {
            secObj = Class.forName(this.getSecurityDeserializerClass()).newInstance();
        }
        catch (Exception e) {
            String message = Messages.getString("SecureConnectorStateImpl.error.loading.trust.deserializer");
            throw new ConnectorException((Throwable)e, message);
        }
        return (TrustedPayloadHandler)secObj;
    }
}

