/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingBaseNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingSourceNode;
import com.metamatrix.query.mapping.xml.MappingVisitor;
import com.metamatrix.query.mapping.xml.Navigator;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.xml.QueryUtil;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Drop;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.visitor.StaticSymbolMappingVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMLQueryPlanner {
    static void prePlanQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            public void visit(MappingBaseNode baseNode) {
                try {
                    List stagingTables = baseNode.getStagingTables();
                    Iterator i = stagingTables.iterator();
                    while (i.hasNext()) {
                        String tableName = (String)i.next();
                        XMLQueryPlanner.planStagingTable(tableName, planEnv);
                    }
                    if (baseNode instanceof MappingSourceNode) {
                        XMLQueryPlanner.planQueries((MappingSourceNode)baseNode, planEnv);
                    }
                }
                catch (Exception e) {
                    throw new MetaMatrixRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    static void optimizeQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            public void visit(MappingSourceNode sourceNode) {
                try {
                    ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
                    if (rsInfo.isJoinedWithParent()) {
                        return;
                    }
                    Query command = (Query)rsInfo.getCommand();
                    XMLQueryPlanner.prepareQuery(sourceNode, planEnv, (QueryCommand)command);
                    QueryUtil.rewriteQuery((Command)command, (QueryMetadataInterface)planEnv.getGlobalMetadata(), (CommandContext)planEnv.context);
                    List references = QueryUtil.getReferences((Command)command, (boolean)false);
                    rsInfo.setReferences(references);
                    ProcessorPlan queryPlan = XMLQueryPlanner.optimizePlan((Command)command, planEnv);
                    rsInfo.setPlan(queryPlan);
                }
                catch (Exception e) {
                    throw new MetaMatrixRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor((MappingVisitor)walker);
        }
        catch (MetaMatrixRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)e.getCause();
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)e.getCause();
            }
            if (e.getCause() instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e.getCause();
            }
            throw e;
        }
    }

    static void planQueries(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        Query rsQuery = (Query)rsInfo.getCommand();
        rsQuery.setOrderBy(rsInfo.getOrderBy());
        Criteria crit = rsInfo.getCriteria();
        try {
            if (crit != null) {
                XMLQueryPlanner.planQueryWithCriteria(sourceNode, planEnv);
            }
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        if (rsInfo.getUserRowLimit() != -1) {
            int limit = rsInfo.getUserRowLimit();
            if (rsInfo.exceptionOnRowlimit()) {
                ++limit;
            }
            rsQuery.setLimit(new Limit(null, (Expression)new Constant((Object)new Integer(limit))));
        }
        rsInfo.setCommand((Command)rsQuery);
    }

    static ProcessorPlan optimizePlan(Command query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        TempMetadataAdapter metadata = planEnv.getGlobalMetadata();
        ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)query, (QueryMetadataInterface)metadata, (IDGenerator)planEnv.idGenerator, (CapabilitiesFinder)planEnv.capFinder, (AnalysisRecord)planEnv.analysisRecord, (CommandContext)planEnv.context);
        return plan;
    }

    static void prepareQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv, QueryCommand rsQuery) throws MetaMatrixComponentException, QueryPlannerException {
        Collection externalGroups = XMLQueryPlanner.getExternalGroups(sourceNode);
        rsQuery.setExternalGroupContexts(new GroupContext(null, externalGroups));
        QueryUtil.resolveQuery((Command)rsQuery, (TempMetadataAdapter)planEnv.getGlobalMetadata());
    }

    private static Collection getExternalGroups(MappingSourceNode sourceNode) {
        HashSet<GroupSymbol> externalGroups = new HashSet<GroupSymbol>();
        for (MappingSourceNode parentSource = sourceNode.getParentSourceNode(); parentSource != null; parentSource = parentSource.getParentSourceNode()) {
            externalGroups.add(new GroupSymbol(parentSource.getActualResultSetName()));
        }
        return externalGroups;
    }

    private static boolean getResultSets(MappingSourceNode contextNode, Set criteriaSourceNodes, LinkedHashSet allResultSets) throws QueryPlannerException {
        boolean singleParentage = true;
        Iterator i = criteriaSourceNodes.iterator();
        while (i.hasNext()) {
            MappingSourceNode node = (MappingSourceNode)i.next();
            LinkedList rsStack = XMLQueryPlanner.getResultSetStack(contextNode, (MappingBaseNode)node);
            if (allResultSets.containsAll(rsStack)) continue;
            if (!rsStack.containsAll(allResultSets)) {
                singleParentage = false;
            }
            allResultSets.addAll(rsStack);
        }
        return singleParentage;
    }

    private static LinkedList getResultSetStack(MappingSourceNode contextNode, MappingBaseNode node) {
        LinkedList<MappingBaseNode> rsStack = new LinkedList<MappingBaseNode>();
        while (node != null && node != contextNode) {
            if (node instanceof MappingSourceNode) {
                rsStack.add(0, node);
            }
            node = node.getParentNode();
        }
        return rsStack;
    }

    private static void planQueryWithCriteria(MappingSourceNode contextNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, MetaMatrixComponentException, QueryMetadataException, QueryResolverException {
        HashMap symbolMap = new HashMap();
        ResultSetInfo rsInfo = contextNode.getResultSetInfo();
        LinkedHashSet resultSets = new LinkedHashSet();
        boolean singleParentage = XMLQueryPlanner.getResultSets(contextNode, rsInfo.getCriteriaResultSets(), resultSets);
        Query contextQuery = null;
        if (rsInfo.isCriteriaRaised()) {
            contextQuery = (Query)QueryUtil.getQueryFromQueryNode((String)rsInfo.getResultSetName(), (XMLPlannerEnvironment)planEnv);
            String inlineViewName = planEnv.getAliasName(rsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, rsInfo.getResultSetName(), inlineViewName, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        } else {
            contextQuery = (Query)rsInfo.getCommand();
        }
        Query currentQuery = contextQuery;
        Iterator i = resultSets.iterator();
        while (i.hasNext()) {
            MappingSourceNode rsNode = (MappingSourceNode)i.next();
            ResultSetInfo childRsInfo = rsNode.getResultSetInfo();
            QueryNode planNode = QueryUtil.getQueryNode((String)childRsInfo.getResultSetName(), (QueryMetadataInterface)planEnv.getGlobalMetadata());
            Command command = QueryUtil.getQuery((QueryNode)planNode);
            String inlineViewName = planEnv.getAliasName(childRsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, childRsInfo.getResultSetName(), inlineViewName, (QueryMetadataInterface)planEnv.getGlobalMetadata());
            if (childRsInfo.hasInputSet() && childRsInfo.isCriteriaRaised()) {
                Query transformationQuery = (Query)command;
                SubqueryFromClause sfc = (SubqueryFromClause)transformationQuery.getFrom().getClauses().get(0);
                Criteria joinCriteria = ((Query)childRsInfo.getCommand()).getCriteria();
                joinCriteria = (Criteria)joinCriteria.clone();
                FromClause clause = (FromClause)currentQuery.getFrom().getClauses().remove(0);
                JoinPredicate join = null;
                join = new JoinPredicate(clause, (FromClause)sfc, JoinType.JOIN_LEFT_OUTER, Criteria.separateCriteriaByAnd((Criteria)joinCriteria));
                currentQuery.getFrom().addClause((FromClause)join);
                currentQuery.getSelect().setDistinct(true);
                continue;
            }
            if (!singleParentage) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("XMLQueryPlanner.cannot_plan", (Object)rsInfo.getCriteria()));
            }
            QueryUtil.handleBindings((LanguageObject)command, (QueryNode)planNode, (XMLPlannerEnvironment)planEnv);
            Query subQuery = QueryUtil.wrapQuery((FromClause)new SubqueryFromClause(inlineViewName, command), (String)inlineViewName);
            currentQuery.setCriteria(Criteria.combineCriteria((Criteria)currentQuery.getCriteria(), (Criteria)new ExistsCriteria((Command)subQuery)));
            currentQuery = subQuery;
        }
        Criteria userCrit = (Criteria)rsInfo.getCriteria().clone();
        currentQuery.setCriteria(Criteria.combineCriteria((Criteria)currentQuery.getCriteria(), (Criteria)userCrit));
        StaticSymbolMappingVisitor.mapSymbols((LanguageObject)contextQuery, symbolMap);
        if (rsInfo.isCriteriaRaised()) {
            XMLQueryPlanner.prepareQuery(contextNode, planEnv, (QueryCommand)contextQuery);
            QueryUtil.rewriteQuery((Command)contextQuery, (QueryMetadataInterface)planEnv.getGlobalMetadata(), (CommandContext)planEnv.context);
            List bindings = QueryUtil.getReferences((Command)contextQuery, (boolean)true);
            QueryNode modifiedNode = new QueryNode(rsInfo.getResultSetName(), null);
            modifiedNode.setCommand((Command)contextQuery);
            Iterator i2 = bindings.iterator();
            while (i2.hasNext()) {
                Reference ref = (Reference)i2.next();
                modifiedNode.addBinding(ref.getExpression().toString());
            }
            GroupSymbol groupSymbol = QueryUtil.createResolvedGroup((String)rsInfo.getResultSetName(), (QueryMetadataInterface)planEnv.getGlobalMetadata());
            planEnv.addQueryNodeToMetadata(groupSymbol.getMetadataID(), modifiedNode);
        }
    }

    private static void updateSymbolMap(Map symbolMap, String oldGroup, String newGroup, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol oldGroupSymbol = new GroupSymbol(oldGroup);
        ResolveGroupsVisitor.resolveGroups((LanguageObject)oldGroupSymbol, (QueryMetadataInterface)metadata);
        HashSet projectedElements = new HashSet(ResolverUtil.resolveElementsInGroup((GroupSymbol)oldGroupSymbol, (QueryMetadataInterface)metadata));
        symbolMap.putAll(QueryUtil.createSymbolMap((GroupSymbol)oldGroupSymbol, (String)newGroup, projectedElements));
    }

    static void planStagingTable(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(groupName);
        UnaryFromClause fromClause = new UnaryFromClause(new GroupSymbol(groupName));
        Query query = QueryUtil.wrapQuery((FromClause)fromClause, (String)groupName);
        if (rsInfo.getCriteria() != null) {
            query.setCriteria(rsInfo.getCriteria());
        }
        XMLQueryPlanner.planStagaingQuery(false, groupName, groupName, query, planEnv);
    }

    static boolean planStagaingQuery(boolean implicit, String srcGroupName, String stageGroupName, Query query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Map tempMetadata;
        GroupSymbol srcGroup = QueryUtil.createResolvedGroup((String)srcGroupName, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        String intoGroupName = "#" + stageGroupName.replace('.', '_');
        GroupSymbol intoGroupSymbol = new GroupSymbol(intoGroupName);
        query.setInto(new Into(intoGroupSymbol));
        QueryUtil.resolveQuery((Command)query, (TempMetadataAdapter)planEnv.getGlobalMetadata());
        QueryUtil.rewriteQuery((Command)query, (QueryMetadataInterface)planEnv.getGlobalMetadata(), (CommandContext)planEnv.context);
        ProcessorPlan plan = null;
        boolean debug = planEnv.analysisRecord.recordDebug();
        if (debug) {
            planEnv.analysisRecord.println("Attempting to create plan for staging table " + srcGroupName);
        }
        try {
            plan = XMLQueryPlanner.optimizePlan((Command)query, planEnv);
        }
        catch (QueryPlannerException e) {
            if (implicit) {
                if (debug) {
                    planEnv.analysisRecord.println("Failed to create plan for staging table " + srcGroupName + " due to " + e.getMessage());
                }
                return false;
            }
            throw e;
        }
        int cardinality = 0;
        if (plan instanceof RelationalPlan) {
            Number planCardinality;
            RelationalPlan relationalPlan = (RelationalPlan)plan;
            RelationalNode root = relationalPlan.getRootNode();
            if (root.getChildren()[0] != null) {
                root = root.getChildren()[0];
            }
            if ((planCardinality = root.getEstimateNodeCardinality()) == null || planCardinality.floatValue() == -1.0f) {
                if (implicit && query.getCriteria() == null) {
                    return false;
                }
            } else if (planCardinality.floatValue() < (float)planEnv.context.getProcessorBatchSize()) {
                cardinality = planCardinality.intValue();
            } else if (implicit) {
                return false;
            }
        }
        if ((tempMetadata = query.getTemporaryMetadata()) != null && !tempMetadata.isEmpty()) {
            planEnv.addToGlobalMetadata(tempMetadata);
        }
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(stageGroupName);
        rsInfo.setCommand((Command)query);
        rsInfo.setPlan(plan);
        TempMetadataID intoGroupID = (TempMetadataID)intoGroupSymbol.getMetadataID();
        intoGroupID.setCardinality(cardinality);
        planEnv.addStagingTable(srcGroup.getMetadataID(), (Object)intoGroupID);
        String unloadName = planEnv.unLoadResultName(stageGroupName);
        ResultSetInfo rsUnloadInfo = planEnv.getStagingTableResultsInfo(unloadName);
        Command command = XMLQueryPlanner.wrapStagingTableUnloadQuery(intoGroupSymbol);
        QueryUtil.resolveQuery((Command)command, (TempMetadataAdapter)planEnv.getGlobalMetadata());
        QueryUtil.rewriteQuery((Command)command, (QueryMetadataInterface)planEnv.getGlobalMetadata(), (CommandContext)planEnv.context);
        plan = XMLQueryPlanner.optimizePlan(command, planEnv);
        rsUnloadInfo.setCommand(command);
        rsUnloadInfo.setPlan(plan);
        return true;
    }

    private static Command wrapStagingTableUnloadQuery(GroupSymbol intoGroupSymbol) {
        Drop drop = new Drop();
        drop.setTable(intoGroupSymbol);
        return drop;
    }
}

