/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.AbstractSetCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NewCalculateCostUtil {
    public static final float UNKNOWN_VALUE = -1.0f;
    public static final int DEFAULT_STRONG_COST = 10;
    static final int DEFAULT_PROCESSOR_BATCH_SIZE = 2000;
    static final int DEFAULT_CONNECTOR_BATCH_SIZE = 2000;
    private static final float compareTime = 0.05f;
    private static final float readTime = 0.001f;
    private static final float procNewRequestTime = 100.0f;
    private static final float procMoreRequestTime = 15.0f;
    static /* synthetic */ Class class$java$lang$Number;

    static float computeCostForTree(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        NewCalculateCostUtil.recursiveComputeCost(node, metadata);
        Float cost = (Float)node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (cost != null) {
            return cost.floatValue();
        }
        return -1.0f;
    }

    private static void recursiveComputeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY) != null) {
            return;
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            PlanNode child = (PlanNode)children.next();
            NewCalculateCostUtil.recursiveComputeCost(child, metadata);
        }
        NewCalculateCostUtil.computeNodeCost(node, metadata);
    }

    private static void computeNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        switch (node.getType()) {
            case 19: {
                NewCalculateCostUtil.estimateSourceNodeCost(node, metadata);
                break;
            }
            case 13: {
                NewCalculateCostUtil.estimateSelectNodeCost(node, metadata);
                break;
            }
            case 7: {
                NewCalculateCostUtil.estimateJoinNodeCost(node, metadata);
                break;
            }
            case 5: {
                NewCalculateCostUtil.estimateNodeCost(node, NodeConstants.Info.TOP_COLS, metadata);
                break;
            }
            case 23: {
                NewCalculateCostUtil.estimateNodeCost(node, NodeConstants.Info.GROUP_COLS, metadata);
                break;
            }
            case 2: 
            case 3: 
            case 17: {
                PlanNode child = node.getFirstChild();
                Float childCost = (Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost);
                break;
            }
            case 31: {
                NewCalculateCostUtil.setCardinalityEstimate(node, new Float(0.0f));
                break;
            }
            case 11: {
                PlanNode child = null;
                Float childCost = null;
                if (node.getChildCount() != 0) {
                    child = node.getFirstChild();
                    childCost = (Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                } else {
                    childCost = new Float(1.0f);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost);
                break;
            }
            case 29: {
                float cost = 0.0f;
                Iterator i = node.getChildren().iterator();
                while (i.hasNext()) {
                    float childCost1 = ((Float)((PlanNode)i.next()).getProperty((Object)NodeConstants.Info.EST_CARDINALITY)).floatValue();
                    if (childCost1 == -1.0f) {
                        cost = -1.0f;
                        break;
                    }
                    cost += childCost1;
                }
                if (!node.hasBooleanProperty((Object)NodeConstants.Info.USE_ALL)) {
                    cost = NewCalculateCostUtil.getDistinctEstimate(node, null, metadata, cost).floatValue();
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost));
                break;
            }
            case 41: {
                Expression limit;
                PlanNode child = node.getFirstChild();
                Float childCost = (Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                Expression offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                Float cost = childCost;
                if (childCost.floatValue() != -1.0f && offset instanceof Constant) {
                    float offsetCost = childCost.floatValue() - ((Number)((Constant)offset).getValue()).floatValue();
                    cost = new Float(offsetCost < 0.0f ? 0.0f : offsetCost);
                }
                if ((limit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT)) instanceof Constant) {
                    float limitCost = ((Number)((Constant)limit).getValue()).floatValue();
                    cost = cost.floatValue() != -1.0f ? new Float(Math.min(limitCost, cost.floatValue())) : new Float(limitCost);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, cost);
            }
        }
    }

    private static void setCardinalityEstimate(PlanNode node, Float bestEstimate) {
        if (bestEstimate != null) {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)bestEstimate);
        } else {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Float(-1.0f));
        }
    }

    private static void estimateJoinNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator children = node.getChildren().iterator();
        PlanNode child1 = (PlanNode)children.next();
        Float childCost1 = (Float)child1.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        PlanNode child2 = (PlanNode)children.next();
        Float childCost2 = (Float)child2.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (childCost1 != null && childCost2 != null && childCost1.floatValue() != -1.0f && childCost2.floatValue() != -1.0f) {
            JoinType joinType = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            List joinCriteria = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            float baseCost = childCost1.floatValue() * childCost2.floatValue();
            if (joinCriteria != null && !joinCriteria.isEmpty()) {
                Criteria crit = Criteria.combineCriteria((List)joinCriteria);
                baseCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCost, node, crit, metadata);
            }
            Float cost = null;
            if (JoinType.JOIN_CROSS.equals((Object)joinType)) {
                cost = new Float(baseCost);
            } else if (JoinType.JOIN_FULL_OUTER.equals((Object)joinType)) {
                cost = new Float(Math.max(childCost1.floatValue() + childCost2.floatValue(), baseCost));
            } else if (JoinType.JOIN_LEFT_OUTER.equals((Object)joinType)) {
                cost = new Float(Math.max(childCost1.floatValue(), baseCost));
            } else if (JoinType.JOIN_RIGHT_OUTER.equals((Object)joinType)) {
                cost = new Float(Math.max(childCost2.floatValue(), baseCost));
            } else if (JoinType.JOIN_INNER.equals((Object)joinType)) {
                cost = new Float(baseCost);
            }
            NewCalculateCostUtil.setCardinalityEstimate(node, cost);
        } else {
            NewCalculateCostUtil.setCardinalityEstimate(node, null);
        }
    }

    private static void estimateSelectNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = node.getFirstChild();
        Float childCostFloat = (Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        float childCost = -1.0f;
        if (childCostFloat != null) {
            childCost = childCostFloat.floatValue();
        }
        Criteria selectCriteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        float newCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, node, selectCriteria, metadata);
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(newCost));
    }

    private static void estimateSourceNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        float cost = -1.0f;
        if (node.getChildCount() > 0) {
            PlanNode child = node.getFirstChild();
            Float childCostFloat = (Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
            if (childCostFloat != null) {
                cost = childCostFloat.floatValue();
            }
        } else {
            GroupSymbol group = (GroupSymbol)node.getGroups().iterator().next();
            float cardinality = metadata.getCardinality(group.getMetadataID());
            if (cardinality <= 0.0f) {
                cardinality = -1.0f;
            }
            cost = cardinality;
        }
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost));
    }

    private static void estimateNodeCost(PlanNode node, Integer elementProperty, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = (PlanNode)node.getChildren().iterator().next();
        float childCost = ((Float)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY)).floatValue();
        if (childCost == -1.0f) {
            NewCalculateCostUtil.setCardinalityEstimate(node, null);
            return;
        }
        Float newCost = NewCalculateCostUtil.getDistinctEstimate(node, (ArrayList)node.getProperty((Object)elementProperty), metadata, childCost);
        NewCalculateCostUtil.setCardinalityEstimate(node, newCost);
    }

    private static Float getDistinctEstimate(PlanNode node, List elements, QueryMetadataInterface metadata, float childCost) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements == null) {
            try {
                elements = ResolverUtil.getElementSybmolsFromGroups((Set)node.getGroups(), (QueryMetadataInterface)metadata);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixComponentException((Throwable)err);
            }
        } else {
            HashSet elems = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Expression expression = (Expression)iter.next();
                ElementCollectorVisitor.getElements((LanguageObject)expression, elems);
            }
            elements = new ArrayList(elems);
        }
        float ndvCost = NewCalculateCostUtil.getMaxNDV(elements, node, childCost, metadata);
        if (ndvCost == -1.0f) {
            ndvCost = childCost;
        }
        Float newCost = new Float(Math.min(childCost, ndvCost));
        return newCost;
    }

    static float recursiveEstimateCostOfCriteria(float childCost, PlanNode currentNode, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        float cost = childCost;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 1) {
                cost = 0.0f;
            } else {
                HashSet elements = new HashSet();
                Iterator crits = compCrit.getCriteria().iterator();
                while (crits.hasNext()) {
                    Criteria aCrit = (Criteria)crits.next();
                    NewCalculateCostUtil.collectElementsOfValidCriteria(aCrit, elements);
                }
                if (NewCalculateCostUtil.usesKey(elements, metadata)) {
                    return 1.0f;
                }
            }
            Iterator iter = compCrit.getCriteria().iterator();
            while (iter.hasNext()) {
                float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, (Criteria)iter.next(), metadata);
                if (compCrit.getOperator() == 0) {
                    if (nextCost == -1.0f) continue;
                    cost = childCost != -1.0f ? (cost *= nextCost / childCost) : (cost == -1.0f ? nextCost : Math.min(cost, nextCost));
                    if (!(cost <= 1.0f)) continue;
                    return 1.0f;
                }
                if (nextCost == -1.0f) {
                    return childCost;
                }
                cost += nextCost;
                if (childCost == -1.0f) continue;
                cost = Math.min(cost, childCost);
            }
            if (cost == -1.0f) {
                return childCost;
            }
        } else if (crit instanceof NotCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, ((NotCriteria)crit).getCriteria(), metadata);
            if (nextCost == -1.0f) {
                return childCost;
            }
            cost -= nextCost;
        } else {
            cost = NewCalculateCostUtil.estimatePredicateCost(childCost, currentNode, (PredicateCriteria)crit, metadata);
            if (cost == -1.0f) {
                return childCost;
            }
        }
        cost = Math.max(cost, 1.0f);
        return cost;
    }

    private static void collectElementsOfValidCriteria(Criteria criteria, Collection elements) {
        IsNullCriteria isNullCriteria;
        if (criteria instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)criteria;
            if (compCrit.getOperator() == 0) {
                Iterator iter = compCrit.getCriteria().iterator();
                while (iter.hasNext()) {
                    NewCalculateCostUtil.collectElementsOfValidCriteria((Criteria)iter.next(), elements);
                }
            }
        } else if (criteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)criteria;
            if (compCrit.getOperator() == 1) {
                ElementCollectorVisitor.getElements((LanguageObject)compCrit, (Collection)elements);
            }
        } else if (criteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)criteria;
            if (!matchCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)matchCriteria, (Collection)elements);
            }
        } else if (criteria instanceof AbstractSetCriteria) {
            AbstractSetCriteria setCriteria = (AbstractSetCriteria)criteria;
            if (!setCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), (Collection)elements);
            }
        } else if (criteria instanceof IsNullCriteria && !(isNullCriteria = (IsNullCriteria)criteria).isNegated()) {
            ElementCollectorVisitor.getElements((LanguageObject)isNullCriteria.getExpression(), (Collection)elements);
        }
    }

    private static float estimatePredicateCost(float childCost, PlanNode currentNode, PredicateCriteria predicateCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        HashSet elements = new HashSet();
        ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, elements);
        Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)predicateCriteria);
        boolean multiGroup = groups.size() > 1;
        float cost = childCost;
        float ndv = NewCalculateCostUtil.getMaxNDV(elements, currentNode, childCost, metadata);
        boolean unknownChildCost = childCost == -1.0f;
        boolean usesKey = NewCalculateCostUtil.usesKey(elements, metadata);
        if (childCost == -1.0f) {
            childCost = 1.0f;
        }
        if (ndv == -1.0f) {
            ndv = 3.0f;
            if (multiGroup) {
                ndv = usesKey ? (float)Math.ceil(Math.sqrt(childCost)) : (float)Math.ceil(Math.sqrt(childCost) / 4.0);
                ndv = Math.max(ndv, 1.0f);
            } else if (usesKey) {
                ndv = childCost;
            }
        }
        boolean isNegatedPredicateCriteria = false;
        if (predicateCriteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
            if (compCrit.getOperator() == 1 || compCrit.getOperator() == 2) {
                if (unknownChildCost && (!usesKey || multiGroup)) {
                    return -1.0f;
                }
                cost = childCost / ndv;
                if (compCrit.getOperator() == 2) {
                    isNegatedPredicateCriteria = true;
                }
            } else {
                cost = NewCalculateCostUtil.getCostForComparison(childCost, metadata, compCrit, unknownChildCost);
            }
        } else if (predicateCriteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = NewCalculateCostUtil.estimateMatchCost(childCost, ndv, matchCriteria);
            isNegatedPredicateCriteria = matchCriteria.isNegated();
        } else if (predicateCriteria instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = Math.min(childCost, childCost * (float)setCriteria.getNumberOfValues() / ndv);
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof SubquerySetCriteria) {
            SubquerySetCriteria setCriteria = (SubquerySetCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = childCost / 3.0f;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof IsNullCriteria) {
            IsNullCriteria isNullCriteria = (IsNullCriteria)predicateCriteria;
            if (NewCalculateCostUtil.isNullable(elements, metadata)) {
                float nnv = NewCalculateCostUtil.getNNV(elements, metadata);
                if (unknownChildCost) {
                    return nnv;
                }
                cost = nnv == -1.0f ? childCost / ndv : childCost * (nnv / Math.max(1.0f, NewCalculateCostUtil.getCardinality(elements, metadata)));
            } else {
                cost = 0.0f;
            }
            isNegatedPredicateCriteria = isNullCriteria.isNegated();
        }
        if (cost == -1.0f) {
            return -1.0f;
        }
        if (cost > childCost) {
            cost = childCost;
        }
        if (isNegatedPredicateCriteria) {
            cost = cost != -1.0f ? Math.max(childCost - cost, 1.0f) : -1.0f;
        }
        return cost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float estimateMatchCost(float childCost, float ndv, MatchCriteria criteria) {
        Expression matchExpression = criteria.getRightExpression();
        if (matchExpression instanceof Constant && ((Constant)matchExpression).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            String compareValue = (String)((Constant)matchExpression).getValue();
            if (compareValue == null) return childCost / 3.0f;
            if (compareValue.indexOf(37) < 0) return childCost / ndv;
            if (compareValue.length() != 1) return childCost / 3.0f;
            return childCost;
        }
        if (!EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)criteria.getLeftExpression())) return childCost / 3.0f;
        return childCost / ndv;
    }

    private static float getCostForComparison(float childCost, QueryMetadataInterface metadata, CompareCriteria compCrit, boolean unknownChildCost) throws MetaMatrixComponentException, QueryMetadataException {
        if (!(compCrit.getLeftExpression() instanceof ElementSymbol) || !(compCrit.getRightExpression() instanceof Constant)) {
            if (unknownChildCost) {
                return -1.0f;
            }
            return childCost / 3.0f;
        }
        ElementSymbol element = (ElementSymbol)compCrit.getLeftExpression();
        Class dataType = compCrit.getRightExpression().getType();
        String max = (String)metadata.getMaximumValue(element.getMetadataID());
        String min = (String)metadata.getMinimumValue(element.getMetadataID());
        if (max == null || min == null) {
            if (unknownChildCost) {
                return -1.0f;
            }
            return childCost / 3.0f;
        }
        float cost = childCost;
        try {
            float maxValue = 0.0f;
            float minValue = 0.0f;
            Constant value = (Constant)compCrit.getRightExpression();
            float compareValue = 0.0f;
            if (dataType.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                compareValue = ((Timestamp)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                compareValue = ((Time)value.getValue()).getTime();
                maxValue = Time.valueOf(max).getTime();
                minValue = Time.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                compareValue = ((Date)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else {
                if (!(class$java$lang$Number == null ? (class$java$lang$Number = NewCalculateCostUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(dataType)) {
                    if (unknownChildCost) {
                        return -1.0f;
                    }
                    return childCost / 3.0f;
                }
                compareValue = ((Number)value.getValue()).floatValue();
                maxValue = Integer.parseInt(max);
                minValue = Integer.parseInt(min);
            }
            float range = Math.max(maxValue - minValue, 1.0f);
            float costMultiple = 1.0f;
            if (compCrit.getOperator() == 4 || compCrit.getOperator() == 6) {
                costMultiple = (maxValue - compareValue) / range;
                if (compareValue < 0.0f && maxValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            } else if (compCrit.getOperator() == 3 || compCrit.getOperator() == 5) {
                costMultiple = (compareValue - minValue) / range;
                if (compareValue < 0.0f && minValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            }
            if (costMultiple > 1.0f) {
                costMultiple = 1.0f;
            } else if (costMultiple < 0.0f) {
                costMultiple = 0.0f;
            }
            cost = childCost * costMultiple;
        }
        catch (IllegalArgumentException e) {
            LogManager.logWarning((String)"QUERY_PLANNER", (Throwable)e, (Object[])new Object[]{"Unexpected format encountered for max or min value"});
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = childCost / 3.0f;
        }
        return cost;
    }

    private static boolean usesKey(Collection allElements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList<Object> elements;
        GroupSymbol group;
        if (allElements == null || allElements.size() == 0) {
            return false;
        }
        HashMap<GroupSymbol, ArrayList<Object>> groupMap = new HashMap<GroupSymbol, ArrayList<Object>>();
        Iterator elementIter = allElements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            group = element.getGroupSymbol();
            elements = (ArrayList<Object>)groupMap.get(group);
            if (elements == null) {
                elements = new ArrayList<Object>();
                groupMap.put(group, elements);
            }
            elements.add(element.getMetadataID());
        }
        Iterator groupIter = groupMap.keySet().iterator();
        while (groupIter.hasNext()) {
            group = (GroupSymbol)groupIter.next();
            elements = (List)groupMap.get(group);
            Collection keys = metadata.getUniqueKeysInGroup(group.getMetadataID());
            if (keys == null || keys.size() <= 0) continue;
            Iterator keyIter = keys.iterator();
            while (keyIter.hasNext()) {
                List keyElements = metadata.getElementIDsInKey(keyIter.next());
                if (!elements.containsAll(keyElements)) continue;
                return true;
            }
        }
        return false;
    }

    private static float getCardinality(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return -1.0f;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object groupID = elem.getGroupSymbol().getMetadataID();
        return metadata.getCardinality(groupID);
    }

    private static float getMaxNDV(Collection elements, PlanNode currentNode, float estNodeCardinality, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.isEmpty()) {
            return -1.0f;
        }
        float ndv = -1.0f;
        Iterator elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            ElementSymbol elem = (ElementSymbol)elementIterator.next();
            if ((ndv = Math.max(ndv, NewCalculateCostUtil.estimateNDVForSymbol(elem, currentNode, estNodeCardinality, metadata))) != -1.0f) continue;
            return -1.0f;
        }
        return ndv;
    }

    private static boolean isNullable(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return true;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object elemID = elem.getMetadataID();
        return metadata.elementSupports(elemID, 4) || metadata.elementSupports(elemID, 10);
    }

    private static float getNNV(HashSet elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (elements.size() != 1) {
            return -1.0f;
        }
        ElementSymbol elem = (ElementSymbol)elements.iterator().next();
        Object elemID = elem.getMetadataID();
        return metadata.getNullValues(elemID);
    }

    public static float computeCostForJoin(PlanNode leftChildNode, PlanNode rightChildNode, JoinStrategyType joinStrategy, QueryMetadataInterface metadata, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        float leftChildCardinality = NewCalculateCostUtil.computeCostForTree(leftChildNode, metadata);
        float rightChildCardinality = NewCalculateCostUtil.computeCostForTree(rightChildNode, metadata);
        boolean merge = JoinStrategyType.MERGE.equals((Object)joinStrategy);
        if (leftChildCardinality == -1.0f || rightChildCardinality == -1.0f) {
            return -1.0f;
        }
        float numberComparisons = merge ? leftChildCardinality + rightChildCardinality : leftChildCardinality * rightChildCardinality;
        float connectorBatchSize = 2000.0f;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
        }
        float totalReadTime = (leftChildCardinality + rightChildCardinality) * 0.001f;
        float totalCompareTime = numberComparisons * 0.05f;
        float totalProcMoreRequestLeftTime = (float)Math.floor(leftChildCardinality / connectorBatchSize) * 15.0f;
        float totalProcMoreRequestRightTime = (float)Math.floor(rightChildCardinality / connectorBatchSize) * 15.0f;
        float cost = totalReadTime + totalCompareTime + totalProcMoreRequestLeftTime + totalProcMoreRequestRightTime;
        if (merge) {
            cost += (leftChildCardinality * NewCalculateCostUtil.safeLog(leftChildCardinality) + rightChildCardinality * NewCalculateCostUtil.safeLog(rightChildCardinality)) * 0.001f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(rightChildNode)) {
            cost += 100.0f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(leftChildNode)) {
            cost += 100.0f;
        }
        return cost;
    }

    private static float safeLog(float x) {
        return (float)Math.max(1.0, Math.log(x));
    }

    public static float computeCostForDepJoin(PlanNode joinNode, boolean leftIndependent, JoinStrategyType joinStrategy, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws MetaMatrixComponentException, QueryMetadataException {
        PlanNode node;
        PlanNode independentNode = leftIndependent ? joinNode.getFirstChild() : joinNode.getLastChild();
        PlanNode dependentNode = leftIndependent ? joinNode.getLastChild() : joinNode.getFirstChild();
        List independentExpressions = (List)(leftIndependent ? joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS));
        List dependentExpressions = (List)(leftIndependent ? joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS));
        float independentCardinality = NewCalculateCostUtil.computeCostForTree(independentNode, metadata);
        float dependentCardinality = NewCalculateCostUtil.computeCostForTree(dependentNode, metadata);
        float indSymbolNDV = NewCalculateCostUtil.getNDV(independentNode, independentExpressions, metadata, independentCardinality, true);
        float depSymbolNDV = NewCalculateCostUtil.getNDV(dependentNode, dependentExpressions, metadata, dependentCardinality, false);
        if (indSymbolNDV == -1.0f || depSymbolNDV == -1.0f || independentCardinality == -1.0f || dependentCardinality == -1.0f) {
            return -1.0f;
        }
        float connectorBatchSize = 2000.0f;
        float processorBatchSize = 2000.0f;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
            processorBatchSize = context.getProcessorBatchSize();
        }
        float setCriteriaBatchSize = indSymbolNDV;
        for (node = FrameUtil.findJoinSourceNode((PlanNode)dependentNode); node != null && node.getType() != 3; node = node.getFirstChild()) {
            if (node.getType() != 7 && node.getType() != 29) continue;
            node = null;
            break;
        }
        if (node != null) {
            setCriteriaBatchSize = CapabilitiesUtil.getMaxInCriteriaSize(RuleRaiseAccess.getModelIDFromAccess((PlanNode)node, (QueryMetadataInterface)metadata), metadata, capFinder);
            if (setCriteriaBatchSize < 1.0f) {
                setCriteriaBatchSize = indSymbolNDV;
            }
        } else if (indSymbolNDV > Math.min(processorBatchSize, setCriteriaBatchSize)) {
            return -1.0f;
        }
        independentNode.setProperty((Object)NodeConstants.Info.EST_SET_SIZE, (Object)new Float(indSymbolNDV));
        float dependentAccessCardinality = Math.min(dependentCardinality, dependentCardinality * indSymbolNDV / depSymbolNDV);
        boolean merge = false;
        if (JoinStrategyType.MERGE.equals((Object)joinStrategy)) {
            merge = true;
        } else if (!JoinStrategyType.NESTED_LOOP.equals((Object)joinStrategy)) {
            return -1.0f;
        }
        dependentNode.setProperty((Object)NodeConstants.Info.EST_DEP_CARDINALITY, (Object)new Float(dependentAccessCardinality));
        float numberComparisons = merge ? independentCardinality + dependentAccessCardinality : independentCardinality * dependentAccessCardinality;
        float totalLoadDataTime = independentCardinality * NewCalculateCostUtil.safeLog(independentCardinality) * 0.001f;
        if (merge) {
            totalLoadDataTime += dependentAccessCardinality * NewCalculateCostUtil.safeLog(dependentAccessCardinality) * 0.001f;
        }
        float totalReadTime = (2.0f * independentCardinality + dependentAccessCardinality) * 0.001f;
        float totalCompareTime = numberComparisons * 0.05f;
        float totalProcMoreRequestLeftTime = (float)Math.floor(independentCardinality / connectorBatchSize) * 15.0f;
        float newDependentQueries = (float)Math.ceil(indSymbolNDV / setCriteriaBatchSize);
        float totalProcMoreRequestRightTime = Math.max(dependentAccessCardinality / connectorBatchSize - newDependentQueries, 0.0f) * 15.0f;
        float cost = totalLoadDataTime + totalReadTime + totalCompareTime + totalProcMoreRequestLeftTime + totalProcMoreRequestRightTime;
        if (NewCalculateCostUtil.isPhysicalSource(independentNode)) {
            cost += 100.0f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(dependentNode)) {
            cost += newDependentQueries * (100.0f * Math.max(NewCalculateCostUtil.safeLog(dependentCardinality) - 10.0f, 1.0f) * Math.max(NewCalculateCostUtil.safeLog(Math.min(dependentCardinality, Math.min(setCriteriaBatchSize, indSymbolNDV))) - 2.0f, 1.0f));
        }
        return cost;
    }

    private static boolean isPhysicalSource(PlanNode node) {
        if ((node = FrameUtil.findJoinSourceNode((PlanNode)node)) != null) {
            return node.getType() == 3;
        }
        return false;
    }

    private static float getNDV(PlanNode node, List expressions, QueryMetadataInterface metadata, float nodeCardinality, boolean independent) throws QueryMetadataException, MetaMatrixComponentException {
        float result = -1.0f;
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            Collection symbols = ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true);
            float currentSymbolNDV = NewCalculateCostUtil.getMaxNDV(symbols, node, nodeCardinality, metadata);
            if (currentSymbolNDV == -1.0f) {
                if (NewCalculateCostUtil.usesKey(symbols, metadata)) {
                    return nodeCardinality;
                }
                currentSymbolNDV = independent ? nodeCardinality / 2.0f : nodeCardinality / 4.0f;
            }
            if (result != -1.0f && !(currentSymbolNDV > result)) continue;
            result = currentSymbolNDV;
        }
        return Math.max(1.0f, Math.min(nodeCardinality, result));
    }

    private static float getMappedPhysicalNDV(ElementSymbol currentDepSymbol, PlanNode dependentNode, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        PlanNode sourceNode;
        PlanNode currentNode = dependentNode;
        ElementSymbol currentExpr = currentDepSymbol;
        while ((sourceNode = FrameUtil.findOriginatingNode((PlanNode)currentNode, (Set)dependentNode.getGroups())) != null) {
            if (sourceNode.getType() == 19) {
                Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                if (symbolMap == null) {
                    return -1.0f;
                }
                if ((currentExpr = (Expression)symbolMap.get(currentExpr)) == null) {
                    return -1.0f;
                }
                if (!(currentExpr instanceof ElementSymbol)) {
                    Collection elements = ElementCollectorVisitor.getElements((LanguageObject)currentExpr, (boolean)false, (boolean)false);
                    switch (elements.size()) {
                        case 0: {
                            return 1.0f;
                        }
                        case 1: {
                            currentExpr = (ElementSymbol)elements.iterator().next();
                            break;
                        }
                        default: {
                            return -1.0f;
                        }
                    }
                }
            }
            try {
                ElementSymbol currentElem = currentExpr;
                if (!metadata.isVirtualGroup(currentElem.getGroupSymbol().getMetadataID())) {
                    return metadata.getDistinctValues(currentElem.getMetadataID());
                }
                currentNode = currentNode.getFirstChild();
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
        return -1.0f;
    }

    private static float estimateNDVForSymbol(ElementSymbol symbol, PlanNode currentNode, float estNodeCardinality, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (symbol == null) {
            return -1.0f;
        }
        float ndv = 0.0f;
        float tableCardinality = 0.0f;
        Object elemID = symbol.getMetadataID();
        Object groupID = symbol.getGroupSymbol().getMetadataID();
        if (metadata.isVirtualGroup(groupID)) {
            return NewCalculateCostUtil.getMappedPhysicalNDV(symbol, currentNode, metadata);
        }
        if (elemID != null && groupID != null) {
            ndv = metadata.getDistinctValues(elemID);
            tableCardinality = metadata.getCardinality(groupID);
        }
        if (ndv <= 0.0f) {
            return -1.0f;
        }
        float estNDV = estNodeCardinality * ndv / tableCardinality;
        if (estNDV < ndv) {
            return Math.max(1.0f, estNDV);
        }
        return Math.max(1.0f, ndv);
    }

    static boolean isNodeStrong(PlanNode accessNode, QueryMetadataInterface metadata, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        float result = NewCalculateCostUtil.computeCostForTree(accessNode, metadata);
        float strong_cost = 10.0f;
        if (context != null) {
            strong_cost = Math.min(strong_cost, (float)context.getProcessorBatchSize());
        }
        return result != -1.0f && result <= strong_cost;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

