/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing.command;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metabase.repository.internal.util.XsdToXmiUtil;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.exception.ProcessingException;
import com.metamatrix.metamodels.db.model.processing.MMUUIDXMIModelProcessorHandler;
import com.metamatrix.metamodels.db.model.processing.command.Command;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.service.IndexingService;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import com.metamatrix.repository.EcoreModelShredder;
import com.metamatrix.repository.exception.ShreddingException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AddFileCommand
implements Command {
    private static final String ECORE_EXTENSION = ".ECORE";
    private static final String VDB_EXTENSION = ".VDB";
    private static final String XSD_EXTENSION = ".XSD";
    private IDHelper helper;
    private StatementTarget target;
    private IDGenerator generator = new IDGenerator();
    private ObjectToDBMappingHelper insertMappingHelper;
    private MetabaseRepositoryShredderComponentRequest message;
    private MetabaseRepositoryShredderConfigSource config;
    private EcoreModelShredder ecoreModelShredder;

    public AddFileCommand(MetabaseRepositoryShredderComponentRequest message, IDHelper helper, StatementTarget target, ObjectToDBMappingHelper insertMappingHelper, MetabaseRepositoryShredderConfigSource config) {
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_ResponseCommand_used_to_create_an_AddFileCommand_cannot_be_null._1"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_IDHelper_instance_used_to_create_an_AddFileCommand_cannot_be_null._2"));
        }
        if (target == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_StatementTarget_instance_used_to_create_an_AddFileCommand_cannot_be_null._3"));
        }
        if (insertMappingHelper == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_ObjectToDBMappingHelper_instance_used_to_create_an_AddFileCommand_cannot_be_null._4"));
        }
        if (config == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("AddFileCommand.The_configuration_source_instance_used_to_instantiate_a_AddFileCommand_was_null.__Cannot_instantiate._1"));
        }
        this.config = config;
        this.helper = helper;
        this.message = message;
        this.target = target;
        this.insertMappingHelper = insertMappingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ProcessingException {
        this.message.setTransactionState(2);
        try {
            ProcessingException exception = null;
            if (this.config.enableDTC() && this.message.getShredderRequestKey().useDTC() && !this.message.getModelName().toUpperCase().endsWith(ECORE_EXTENSION)) {
                try {
                    this.addModelToDTC();
                }
                catch (ProcessingException e) {
                    exception = e;
                }
            }
            if (this.config.enableMMR() && this.isMMRShredable()) {
                try {
                    this.addModelToMMR();
                }
                catch (ProcessingException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                this.message.setTransactionState(5);
                throw exception;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                BufferedInputStreamWrapper stream = this.message.getModelStream();
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
            }
            throw throwable;
        }
        try {
            BufferedInputStreamWrapper stream = this.message.getModelStream();
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
        }
        this.message.setTimeCompleted(System.currentTimeMillis());
        this.message.setTransactionState(4);
    }

    private boolean isMMRShredable() {
        if (!this.message.getShredderRequestKey().useMMR()) {
            return false;
        }
        if (IndexingService.MMR_IGNORED_MODELS.contains(this.message.getModelRepositoryPath())) {
            return false;
        }
        return !this.message.getModelRepositoryPath().toUpperCase().endsWith(VDB_EXTENSION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addModelToMMR() throws ProcessingException {
        try {
            try {
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("AddFileCommand.adding_model_to_mmr", (Object)this.message.getModelName()));
                this.ecoreModelShredder.shredModel(this.message.getModelRepositoryPath(), (InputStream)this.message.getModelStream().getInputStream(), this.message.getModelVersion());
            }
            catch (Exception e) {
                ShreddingException se;
                if (!(e instanceof ShreddingException) || !(se = (ShreddingException)e).shouldRetry()) throw new ProcessingException((Throwable)e, DBModelPlugin.Util.getString("AddFileCommand.failed_adding_model_to_mmr", new Object[]{this.message.getModelName()}));
                this.message.setTransactionState(6);
                throw new ProcessingException((Throwable)e, DBModelPlugin.Util.getString("AddFileCommand.failed_adding_model_to_mmr", new Object[]{this.message.getModelName()}));
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            try {
                BufferedInputStreamWrapper stream = this.message.getModelStream();
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        BufferedInputStreamWrapper stream = this.message.getModelStream();
        if (stream == null) return;
        stream.close();
        return;
    }

    /*
     * Loose catch block
     */
    private void addModelToDTC() throws ProcessingException {
        block26: {
            InputStream modelStream;
            block27: {
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("AddFileCommand.adding_model_to_dtc", (Object)this.message.getModelName()));
                modelStream = null;
                try {
                    modelStream = this.message.getModelStream().getInputStream();
                    if (this.message.getModelName().toUpperCase().endsWith(XSD_EXTENSION) && (this.message.getUserName() == null || !this.message.getUserName().equalsIgnoreCase("setupmm"))) {
                        String resourcePath = this.message.getModelRepositoryPath();
                        modelStream = XsdToXmiUtil.transformXsdToXmiStream((InputStream)modelStream, (URI)URI.createURI((String)resourcePath), (URI)URI.createURI((String)resourcePath), (String)resourcePath);
                    }
                }
                catch (IOException e) {
                    try {
                        if (modelStream != null) {
                            modelStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new ProcessingException((Throwable)e);
                }
                SAXParser parser = null;
                if (parser == null) {
                    try {
                        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                        saxFactory.setNamespaceAware(true);
                        parser = saxFactory.newSAXParser();
                    }
                    catch (Exception e) {
                        try {
                            if (modelStream != null) {
                                modelStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        throw new ProcessingException((Throwable)e, DBModelPlugin.Util.getString("ModelProcessor.Unable_to_initialize_SAXParser_instance"));
                    }
                }
                MMUUIDXMIModelProcessorHandler handler = new MMUUIDXMIModelProcessorHandler(this.generator, this.helper, this.insertMappingHelper, this.message, this.target);
                if (parser == null) break block27;
                InputSource source = new InputSource(modelStream);
                parser.parse(source, (DefaultHandler)handler);
                Object var7_12 = null;
                this.target.flush();
                try {
                    BufferedInputStreamWrapper stream = this.message.getModelStream();
                    if (stream != null) {
                        stream.close();
                    }
                    break block26;
                }
                catch (IOException e) {
                    DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
                }
                break block26;
                {
                    catch (SAXException e1) {
                        Exception e = e1.getException();
                        if (e != null) {
                            e.printStackTrace();
                        }
                        throw new ProcessingException((Throwable)e1, DBModelPlugin.Util.getString("ModelProcessor.model_parsing_error", new Object[]{this.message.getModelName()}));
                    }
                    catch (IOException e1) {
                        throw new ProcessingException((Throwable)e1, DBModelPlugin.Util.getString("ModelProcessor.model_reading_error", new Object[]{this.message.getModelName()}));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    this.target.flush();
                    try {
                        BufferedInputStreamWrapper stream = this.message.getModelStream();
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("AddFileCommand.Unable_to_close_the_input_stream_for_the_input_model_that_was_being_indexed_by_the_Indexing_Service_7"));
                    }
                    throw throwable;
                }
            }
            try {
                if (modelStream != null) {
                    modelStream.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new ProcessingException(DBModelPlugin.Util.getString("ModelProcessor.Parser_was_null"));
        }
    }

    public void setMMRShredder(EcoreModelShredder ecoreModelShredder) {
        this.ecoreModelShredder = ecoreModelShredder;
    }
}

