/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.file;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.XMLConnectionImpl;
import com.metamatrix.connector.xml.base.XMLConnectorStateImpl;
import com.metamatrix.connector.xml.file.FileExecutor;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public class FileConnectorState
extends XMLConnectorStateImpl {
    private String m_fileName;
    private String m_directoryPath;
    public static final String FILE_NAME = "FileName";
    public static final String DIRECTORY_PATH = "FilePath";

    public FileConnectorState() {
        this.setFileName("");
        this.setDirectoryPath("");
        this.setErrorOnRecreateDoc(false);
    }

    public Properties getState() {
        Properties props = super.getState();
        props.setProperty(FILE_NAME, this.getFileName());
        props.setProperty(DIRECTORY_PATH, this.getDirectoryPath());
        return props;
    }

    public void setState(Properties props) throws ConnectorException {
        super.setState(props);
        this.setFileName(props.getProperty(FILE_NAME));
        this.setDirectoryPath(props.getProperty(DIRECTORY_PATH));
    }

    public final void setFileName(String fileName) {
        this.m_fileName = fileName != null ? fileName : "";
    }

    public final String getFileName() {
        return this.m_fileName;
    }

    public final void setDirectoryPath(String directoryPath) {
        this.m_directoryPath = directoryPath != null ? directoryPath : "";
    }

    public final String getDirectoryPath() {
        return this.m_directoryPath;
    }

    public DocumentProducer makeExecutor(XMLExecution execution) throws ConnectorException {
        return new FileExecutor(this, execution);
    }

    public Connection getConnection(CachingConnector connector, SecurityContext context, ConnectorEnvironment environment) throws ConnectorException {
        return new XMLConnectionImpl(connector, context, environment);
    }
}

