/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.io.FilePermission;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class BundleLocationCondition {
    private static final String CONDITION_TYPE = "org.osgi.service.condpermadmin.BundleLocationCondition";

    public static Condition getCondition(Bundle bundle, ConditionInfo info) {
        if (!CONDITION_TYPE.equals(info.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.osgi.service.condpermadmin.BundleLocationCondition\"");
        }
        String[] args = info.getArgs();
        if (args.length != 1) {
            throw new IllegalArgumentException("Illegal number of args: " + args.length);
        }
        String location = args[0];
        FilePermission locationPat = new FilePermission(location, "read");
        FilePermission sourcePat = new FilePermission(bundle.getLocation().toString(), "read");
        return locationPat.implies(sourcePat) ? Condition.TRUE : Condition.FALSE;
    }

    private BundleLocationCondition() {
    }
}

