/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;

public class ElementSymbol
extends SingleElementSymbol
implements Expression {
    private GroupSymbol groupSymbol;
    private Object metadataID;
    private Class type;
    private boolean isExternalReference = false;
    private boolean displayFullyQualified;
    private String vdbName;
    private boolean fixedReference;

    protected ElementSymbol(String name, String canonicalName, int hashcode, boolean displayFullyQualified) {
        super(name, canonicalName, hashcode);
        this.setDisplayFullyQualified(displayFullyQualified);
    }

    public ElementSymbol(String name) {
        this(name, true);
    }

    public ElementSymbol(String name, boolean displayFullyQualified) {
        super(name);
        this.setDisplayFullyQualified(displayFullyQualified);
    }

    public void setDisplayFullyQualified(boolean displayFullyQualified) {
        this.displayFullyQualified = displayFullyQualified;
    }

    public boolean getDisplayFullyQualified() {
        return this.displayFullyQualified;
    }

    public void setIsExternalReference(boolean isExternalReference) {
        this.isExternalReference = isExternalReference;
    }

    public boolean isExternalReference() {
        return this.isExternalReference;
    }

    public void setGroupSymbol(GroupSymbol symbol) {
        this.groupSymbol = symbol;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setVirtualDatabaseName(String vdbName) {
        this.vdbName = vdbName;
    }

    public String getVirtualDatabaseName() {
        return this.vdbName;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isResolved() {
        return this.metadataID != null && this.type != null;
    }

    public Object clone() {
        ElementSymbol copy = new ElementSymbol(this.getName(), this.getCanonical(), this.getHash(), this.getDisplayFullyQualified());
        if (this.getGroupSymbol() != null) {
            copy.setGroupSymbol((GroupSymbol)this.getGroupSymbol().clone());
        }
        copy.setMetadataID(this.getMetadataID());
        copy.setType(this.getType());
        copy.setVirtualDatabaseName(this.getVirtualDatabaseName());
        copy.setIsExternalReference(this.isExternalReference());
        copy.setFixedReference(this.isFixedReference());
        return copy;
    }

    public boolean isFixedReference() {
        return this.fixedReference;
    }

    public void setFixedReference(boolean fixedReference) {
        this.fixedReference = fixedReference;
    }
}

