/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CriteriaSelector
implements LanguageObject {
    public static final int COMPARE_EQ = 1;
    public static final int COMPARE_NE = 2;
    public static final int COMPARE_LT = 3;
    public static final int COMPARE_GT = 4;
    public static final int COMPARE_LE = 5;
    public static final int COMPARE_GE = 6;
    public static final int LIKE = 7;
    public static final int IN = 8;
    public static final int IS_NULL = 9;
    public static final int BETWEEN = 10;
    public static final int NO_TYPE = 0;
    private int selectorType = 0;
    private List elements;

    public CriteriaSelector() {
    }

    public CriteriaSelector(int selectorType, List elements) {
        this.selectorType = selectorType;
        this.elements = elements;
    }

    public int getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(int type) {
        this.selectorType = type;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void addElement(ElementSymbol element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(element);
    }

    public boolean hasElements() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        CriteriaSelector copy = new CriteriaSelector();
        copy.setSelectorType(this.selectorType);
        if (this.hasElements()) {
            Iterator stmtIter = this.elements.iterator();
            while (stmtIter.hasNext()) {
                copy.addElement((ElementSymbol)((ElementSymbol)stmtIter.next()).clone());
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CriteriaSelector other = (CriteriaSelector)obj;
        return this.getSelectorType() == other.getSelectorType() && EquivalenceUtil.areEqual(this.getElements(), other.getElements());
    }

    public int hashCode() {
        int myHash = 0;
        if (this.hasElements()) {
            myHash = HashCodeUtil.hashCode(myHash, this.getElements());
        }
        myHash = HashCodeUtil.hashCode(myHash, this.getSelectorType());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

