/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamicCommand
extends Command {
    private Expression sql;
    private List asColumns;
    private GroupSymbol intoGroup;
    private int updatingModelCount;
    private LinkedHashMap using;
    private boolean asClauseSet;

    public DynamicCommand() {
    }

    public DynamicCommand(Expression sql, List columns, GroupSymbol intoGroup, LinkedHashMap using) {
        this.sql = sql;
        this.asColumns = columns;
        this.intoGroup = intoGroup;
        this.using = using;
    }

    public Object clone() {
        Iterator<Object> i;
        DynamicCommand clone = new DynamicCommand();
        clone.setSql((Expression)this.getSql().clone());
        if (this.asColumns != null) {
            ArrayList<Object> cloneColumns = new ArrayList<Object>(this.asColumns.size());
            i = this.asColumns.iterator();
            while (i.hasNext()) {
                cloneColumns.add(((ElementSymbol)i.next()).clone());
            }
            clone.setAsColumns(cloneColumns);
        }
        if (this.intoGroup != null) {
            clone.setIntoGroup((GroupSymbol)this.intoGroup.clone());
        }
        if (this.using != null) {
            LinkedHashMap<ElementSymbol, Expression> cloneUsing = new LinkedHashMap<ElementSymbol, Expression>(this.using.size());
            i = this.using.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                ElementSymbol cloneSymbol = (ElementSymbol)((ElementSymbol)entry.getKey()).clone();
                Expression cloneExpression = (Expression)((Expression)entry.getValue()).clone();
                cloneUsing.put(cloneSymbol, cloneExpression);
            }
            clone.setUsing(cloneUsing);
        }
        clone.setUpdatingModelCount(this.getUpdatingModelCount());
        this.copyMetadataState(clone);
        clone.setIsResolved(this.isResolved());
        clone.setAsClauseSet(this.isAsClauseSet());
        return clone;
    }

    public int getType() {
        return 10;
    }

    public List getProjectedSymbols() {
        if (this.intoGroup != null) {
            return Command.getUpdateCommandSymbol();
        }
        if (this.asColumns != null) {
            return this.asColumns;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean areResultsCachable() {
        return false;
    }

    public void setUpdatingModelCount(int count) {
        if (count < 0) {
            count = 0;
        } else if (count > 2) {
            count = 2;
        }
        this.updatingModelCount = count;
    }

    public int getUpdatingModelCount() {
        return this.updatingModelCount;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return this.updatingModelCount;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getAsColumns() {
        if (this.asColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.asColumns;
    }

    public void setAsColumns(List columns) {
        this.asColumns = columns;
    }

    public GroupSymbol getIntoGroup() {
        return this.intoGroup;
    }

    public void setIntoGroup(GroupSymbol intoGroup) {
        this.intoGroup = intoGroup;
    }

    public Expression getSql() {
        return this.sql;
    }

    public void setSql(Expression sql) {
        this.sql = sql;
    }

    public LinkedHashMap getUsing() {
        return this.using;
    }

    public void setUsing(LinkedHashMap using) {
        this.using = using;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicCommand)) {
            return false;
        }
        DynamicCommand other = (DynamicCommand)obj;
        return this.updatingModelCount == other.updatingModelCount && EquivalenceUtil.areEqual(this.getAsColumns(), other.getAsColumns()) && EquivalenceUtil.areEqual(this.getSql(), other.getSql()) && EquivalenceUtil.areEqual(this.getIntoGroup(), other.getIntoGroup()) && EquivalenceUtil.areEqual(this.getUsing(), other.getUsing());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.sql);
        myHash = HashCodeUtil.hashCode(myHash, this.asColumns);
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isAsClauseSet() {
        return this.asClauseSet;
    }

    public void setAsClauseSet(boolean asClauseSet) {
        this.asClauseSet = asClauseSet;
    }
}

