/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import java.text.StringCharacterIterator;

public class VDBNameValidator {
    static String[] reservedVDBNames = new String[]{"System", "Admin", "Help"};
    static String[] reservedSourceNames = new String[]{"System"};

    public static boolean isValid(String vdbName) {
        if (vdbName == null || vdbName.length() == 0) {
            return false;
        }
        if (VDBNameValidator.containsInvalidChars(vdbName)) {
            return false;
        }
        for (int i = 0; i < reservedVDBNames.length; ++i) {
            if (!vdbName.equalsIgnoreCase(reservedVDBNames[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSourceValid(String sourceName) {
        if (sourceName == null || sourceName.length() == 0) {
            return false;
        }
        if (VDBNameValidator.containsInvalidChars(sourceName)) {
            return false;
        }
        return !VDBNameValidator.isSourceNameReserved(sourceName);
    }

    public static boolean isSourceNameReserved(String sourceName) {
        for (int i = 0; i < reservedSourceNames.length; ++i) {
            if (!sourceName.equalsIgnoreCase(reservedVDBNames[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsInvalidChars(String vdbName) {
        StringCharacterIterator charIterator = new StringCharacterIterator(vdbName);
        char c = charIterator.first();
        if (c != '\uffff') {
            if (!Character.isLetter(c)) {
                return true;
            }
        } else {
            return true;
        }
        do {
            if ((c = charIterator.next()) != '\uffff') continue;
            return false;
        } while (!(!Character.isLetterOrDigit(c) & c != '_'));
        return true;
    }
}

