/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.DeepPostOrderNavigator;
import com.metamatrix.query.sql.navigator.PostOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.sql.visitor.EvaluatableVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class EvaluateExpressionVisitor
extends LanguageVisitor {
    private boolean elementReplacement = false;
    private CommandContext context;
    private boolean changeExpressions = true;
    private boolean wouldChangeExpression = false;
    private LookupEvaluator dataMgr;

    public void setElementReplacement(boolean replacement) {
        this.elementReplacement = replacement;
    }

    public void setContext(CommandContext context) {
        this.context = context;
    }

    public void setChangeExpressions(boolean change) {
        this.changeExpressions = change;
    }

    public boolean runningWouldChangeExpressions() {
        return this.wouldChangeExpression;
    }

    private void changeDetected() {
        this.wouldChangeExpression = true;
        if (!this.changeExpressions) {
            this.setAbort(true);
        }
    }

    private void checkExpression(Expression exp) {
        if (!this.wouldChangeExpression) {
            this.evaluateExpression(exp);
        }
    }

    public void visit(BetweenCriteria obj) {
        Expression exp = obj.getExpression();
        Expression lowerExp = obj.getLowerExpression();
        Expression upperExp = obj.getUpperExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(exp));
            obj.setLowerExpression(this.evaluateExpression(lowerExp));
            obj.setUpperExpression(this.evaluateExpression(upperExp));
        } else {
            this.checkExpression(exp);
            this.checkExpression(lowerExp);
            this.checkExpression(upperExp);
        }
    }

    public void visit(CaseExpression obj) {
        Expression expr = obj.getExpression();
        int whenCount = obj.getWhenCount();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
            ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
            ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
            for (int i = 0; i < whenCount; ++i) {
                whens.add(this.evaluateExpression(obj.getWhenExpression(i)));
                thens.add(this.evaluateExpression(obj.getThenExpression(i)));
            }
            obj.setWhen(whens, thens);
            if (obj.getElseExpression() != null) {
                obj.setElseExpression(this.evaluateExpression(obj.getElseExpression()));
            }
        } else {
            this.checkExpression(expr);
            for (int i = 0; i < whenCount; ++i) {
                this.checkExpression(obj.getWhenExpression(i));
                this.checkExpression(obj.getThenExpression(i));
            }
            if (obj.getElseExpression() != null) {
                this.checkExpression(obj.getElseExpression());
            }
        }
    }

    public void visit(CompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        Expression rightExp = obj.getRightExpression();
        if (this.changeExpressions) {
            obj.setLeftExpression(this.evaluateExpression(leftExp));
            obj.setRightExpression(this.evaluateExpression(rightExp));
        } else {
            this.checkExpression(leftExp);
            this.checkExpression(rightExp);
        }
    }

    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
        } else {
            this.checkExpression(expr);
        }
    }

    public void visit(MatchCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        Expression rightExp = obj.getRightExpression();
        if (this.changeExpressions) {
            obj.setLeftExpression(this.evaluateExpression(leftExp));
            obj.setRightExpression(this.evaluateExpression(rightExp));
        } else {
            this.checkExpression(leftExp);
            this.checkExpression(rightExp);
        }
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        if (this.changeExpressions) {
            ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
            for (int i = 0; i < whenCount; ++i) {
                thens.add(this.evaluateExpression(obj.getThenExpression(i)));
            }
            obj.setWhen(obj.getWhen(), thens);
            if (obj.getElseExpression() != null) {
                obj.setElseExpression(this.evaluateExpression(obj.getElseExpression()));
            }
        } else {
            for (int i = 0; i < whenCount; ++i) {
                this.checkExpression(obj.getThenExpression(i));
            }
            if (obj.getElseExpression() != null) {
                this.checkExpression(obj.getElseExpression());
            }
        }
    }

    public void visit(SetCriteria obj) {
        Expression expr = obj.getExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
            ArrayList<Expression> valuesList = new ArrayList<Expression>(obj.getNumberOfValues());
            Iterator valuesIter = obj.getValues().iterator();
            while (valuesIter.hasNext()) {
                Expression exp = (Expression)valuesIter.next();
                valuesList.add(this.evaluateExpression(exp));
            }
            obj.setValues(valuesList);
        } else {
            this.checkExpression(expr);
            Iterator valuesIter = obj.getValues().iterator();
            while (valuesIter.hasNext()) {
                Expression exp = (Expression)valuesIter.next();
                this.checkExpression(exp);
            }
        }
    }

    public void visit(DependentSetCriteria obj) {
        Expression expr = obj.getExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
        } else {
            this.checkExpression(expr);
        }
    }

    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        obj.setLeftExpression(this.evaluateExpression(leftExp));
        if (this.changeExpressions) {
            obj.setLeftExpression(this.evaluateExpression(leftExp));
        } else {
            this.checkExpression(leftExp);
        }
    }

    public void visit(SubquerySetCriteria obj) {
        Expression expr = obj.getExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
        } else {
            this.checkExpression(expr);
        }
    }

    public void visit(Insert obj) {
        Iterator valuesIter = obj.getValues().iterator();
        if (this.changeExpressions) {
            ArrayList<Expression> valuesList = new ArrayList<Expression>(obj.getValues().size());
            while (valuesIter.hasNext()) {
                Expression exp = (Expression)valuesIter.next();
                valuesList.add(this.evaluateExpression(exp));
            }
            obj.setValues(valuesList);
        } else {
            while (valuesIter.hasNext()) {
                Expression exp = (Expression)valuesIter.next();
                this.checkExpression(exp);
            }
        }
    }

    public void visit(Update obj) {
        if (this.changeExpressions) {
            Iterator changeIter = obj.getChangeList().iterator();
            ArrayList<CompareCriteria> changeList = new ArrayList<CompareCriteria>(obj.getChangeList().size());
            while (changeIter.hasNext()) {
                CompareCriteria crit = (CompareCriteria)changeIter.next();
                this.visit(crit);
                changeList.add(crit);
            }
            obj.setChangeList(changeList);
        }
    }

    public void visit(Select obj) {
        Iterator sybIter = obj.getSymbols().iterator();
        if (this.changeExpressions) {
            ArrayList<Expression> symbolsList = new ArrayList<Expression>(obj.getSymbols().size());
            while (sybIter.hasNext()) {
                Expression exp = (Expression)sybIter.next();
                Expression evaluatedExp = null;
                if (exp instanceof AliasSymbol) {
                    AliasSymbol alias = (AliasSymbol)exp;
                    evaluatedExp = new AliasSymbol(alias.getName(), (SingleElementSymbol)this.evaluateExpression((Expression)alias.getSymbol()));
                } else {
                    evaluatedExp = this.evaluateExpression(exp);
                }
                symbolsList.add(evaluatedExp);
            }
            obj.setSymbols(symbolsList);
        } else {
            while (sybIter.hasNext()) {
                Expression exp = (Expression)sybIter.next();
                if (exp instanceof AliasSymbol) {
                    AliasSymbol alias = (AliasSymbol)exp;
                    this.checkExpression(this.evaluateExpression((Expression)alias.getSymbol()));
                    continue;
                }
                this.checkExpression(exp);
            }
        }
    }

    public void visit(AggregateSymbol obj) {
        Expression expr = obj.getExpression();
        if (expr != null) {
            if (this.changeExpressions) {
                obj.setExpression(this.evaluateExpression(expr));
            } else {
                this.checkExpression(expr);
            }
        }
    }

    public void visit(ExpressionSymbol obj) {
        Expression expr = obj.getExpression();
        if (this.changeExpressions) {
            obj.setExpression(this.evaluateExpression(expr));
        } else {
            this.checkExpression(expr);
        }
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        if (this.changeExpressions) {
            for (int i = 0; i < argLength; ++i) {
                Expression exp = obj.getArg(i);
                args[i] = this.evaluateExpression(exp);
            }
            obj.setArgs(args);
        } else {
            for (int i = 0; i < argLength; ++i) {
                Expression exp = obj.getArg(i);
                this.checkExpression(exp);
            }
        }
    }

    public void visit(Limit obj) {
        if (this.changeExpressions) {
            if (obj.getOffset() != null) {
                obj.setOffset(this.evaluateExpression(obj.getOffset()));
            }
            obj.setRowLimit(this.evaluateExpression(obj.getRowLimit()));
        } else {
            if (obj.getOffset() != null) {
                this.checkExpression(obj.getOffset());
            }
            this.checkExpression(obj.getRowLimit());
        }
    }

    public void visit(StoredProcedure proc) {
        List params = proc.getParameters();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Expression paramExp;
            SPParameter param = (SPParameter)iter.next();
            if (param.getParameterType() != 1 && param.getParameterType() != 3 || (paramExp = param.getExpression()) instanceof Reference) continue;
            if (this.changeExpressions) {
                param.setExpression(this.evaluateExpression(paramExp));
                continue;
            }
            this.checkExpression(paramExp);
        }
    }

    public void visit(CompoundCriteria obj) {
        List crit = obj.getCriteria();
        if (this.changeExpressions) {
            ArrayList<Criteria> newCrit = new ArrayList<Criteria>(crit.size());
            Iterator iter = crit.iterator();
            while (iter.hasNext()) {
                newCrit.add(this.replaceDependentCriteria((Criteria)iter.next()));
            }
            obj.setCriteria(newCrit);
        } else {
            Iterator iter = crit.iterator();
            while (iter.hasNext()) {
                this.checkDependentCriteria((Criteria)iter.next());
            }
        }
    }

    public void visit(JoinPredicate obj) {
        List joinCrit = obj.getJoinCriteria();
        ArrayList<Criteria> newCrit = new ArrayList<Criteria>(joinCrit.size());
        Iterator iter = joinCrit.iterator();
        if (this.changeExpressions) {
            while (iter.hasNext()) {
                newCrit.add(this.replaceDependentCriteria((Criteria)iter.next()));
            }
            obj.setJoinCriteria(newCrit);
        } else {
            while (iter.hasNext()) {
                this.checkDependentCriteria((Criteria)iter.next());
            }
        }
    }

    public void visit(Query obj) {
        if (this.changeExpressions) {
            obj.setCriteria(this.replaceDependentCriteria(obj.getCriteria()));
            obj.setHaving(this.replaceDependentCriteria(obj.getHaving()));
        } else {
            this.checkDependentCriteria(obj.getCriteria());
            this.checkDependentCriteria(obj.getHaving());
        }
    }

    private void checkDependentCriteria(Criteria crit) {
        if (!this.wouldChangeExpression) {
            this.replaceDependentCriteria(crit);
        }
    }

    public Criteria replaceDependentCriteria(Criteria crit) {
        if (crit != null && crit instanceof DependentSetCriteria) {
            this.changeDetected();
            if (!this.changeExpressions) {
                return crit;
            }
            DependentSetCriteria dsc = (DependentSetCriteria)crit;
            ValueIterator iter = dsc.getValueIterator();
            if (iter == null) {
                Assertion.failed((String)QueryPlugin.Util.getString("EvaluateExpressionVisitor.Cant_get_iterator", (Object)dsc.getValueExpression().toString()));
            }
            try {
                LinkedHashSet<Constant> vals = new LinkedHashSet<Constant>();
                while (iter.hasNext()) {
                    Object val = iter.next();
                    if (val == null) continue;
                    vals.add(new Constant(val));
                }
                if (vals.size() > 0) {
                    SetCriteria sc = new SetCriteria();
                    sc.setExpression(dsc.getExpression());
                    sc.setValues(vals);
                    return sc;
                }
                return new CompareCriteria((Expression)new Constant((Object)new Integer(0)), 1, (Expression)new Constant((Object)new Integer(1)));
            }
            catch (MetaMatrixComponentException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
        return crit;
    }

    private Expression evaluateExpression(Expression expr) {
        Object value;
        if (this.elementReplacement) {
            if (expr instanceof Reference) {
                this.changeDetected();
                if (!this.changeExpressions) {
                    return expr;
                }
                Reference ref = (Reference)expr;
                if (!EvaluatableVisitor.isEvaluatable((LanguageObject)expr, (boolean)false, (boolean)true, (boolean)false)) {
                    return ref.getExpression();
                }
            } else if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)expr).isEmpty()) {
                return expr;
            }
        }
        if (expr instanceof Constant || !EvaluatableVisitor.isEvaluatable((LanguageObject)expr, (boolean)false, (boolean)true, (boolean)false)) {
            return expr;
        }
        this.changeDetected();
        if (!this.changeExpressions) {
            return expr;
        }
        try {
            value = ExpressionEvaluator.evaluate((Expression)expr, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST, (LookupEvaluator)this.dataMgr, (CommandContext)this.context);
        }
        catch (MetaMatrixException err) {
            throw new MetaMatrixRuntimeException((Throwable)err);
        }
        return new Constant(value, expr.getType());
    }

    public static final boolean willBecomeConstant(LanguageObject obj) {
        return EvaluatableVisitor.isEvaluatable((LanguageObject)obj, (boolean)false, (boolean)false, (boolean)true);
    }

    public static final boolean isFullyEvaluatable(LanguageObject obj, boolean duringPlanning) {
        return EvaluatableVisitor.isEvaluatable((LanguageObject)obj, (boolean)duringPlanning, (boolean)true, (boolean)true);
    }

    public static final boolean replaceExpressions(LanguageObject obj, boolean deep, boolean elementReplacement, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, MetaMatrixComponentException {
        return EvaluateExpressionVisitor.replaceExpressions(obj, deep, elementReplacement, dataMgr, context, true);
    }

    static final boolean replaceExpressions(LanguageObject obj, boolean deep, boolean elementReplacement, LookupEvaluator dataMgr, CommandContext context, boolean changeExpressions) throws ExpressionEvaluationException, MetaMatrixComponentException {
        EvaluateExpressionVisitor visitor = new EvaluateExpressionVisitor();
        visitor.setContext(context);
        visitor.setElementReplacement(elementReplacement);
        visitor.setChangeExpressions(changeExpressions);
        visitor.dataMgr = dataMgr;
        try {
            if (deep) {
                DeepPostOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            } else {
                PostOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            }
        }
        catch (MetaMatrixRuntimeException err) {
            Throwable e = err.getChild();
            if (e == null) {
                throw err;
            }
            if (e instanceof ExpressionEvaluationException) {
                throw (ExpressionEvaluationException)e;
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e;
            }
            throw new MetaMatrixComponentException(e, e.getMessage());
        }
        return visitor.runningWouldChangeExpressions();
    }

    public static final boolean wouldChangeExpressions(LanguageObject obj, boolean deep, boolean elementReplacement) throws ExpressionEvaluationException, MetaMatrixComponentException {
        return EvaluateExpressionVisitor.replaceExpressions(obj, deep, elementReplacement, null, null, false);
    }
}

