/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.ComponentNotAvailableException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.exception.SourceFailureDetails;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.CodeTableCache;
import com.metamatrix.dqp.internal.process.ConnectorRequest;
import com.metamatrix.dqp.internal.process.DataTierTupleSource;
import com.metamatrix.dqp.internal.process.QueryTupleSource;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.processor.NullTupleSource;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTierManager
implements ProcessorDataManager,
MessageListener {
    private RequestManager requestMgr;
    private DataService dataService;
    private MetadataService metadataService;
    private VDBService vdbService;
    private TransactionService txnService;
    private BufferService bufferService;
    private int maxCodeTableRecords;
    private Map processors = new HashMap();
    private CodeTableCache codeTableCache;
    private static int execCount = 0;

    public DataTierManager(RequestManager requestMgr, DataService dataService, MetadataService metadataService, VDBService vdbService, TransactionService txnService, BufferService bufferService, WorkerPool processPool, int maxCodeTables, int maxCodeTableRecords) {
        this.requestMgr = requestMgr;
        this.dataService = dataService;
        this.metadataService = metadataService;
        this.vdbService = vdbService;
        this.maxCodeTableRecords = maxCodeTableRecords;
        this.txnService = txnService;
        this.bufferService = bufferService;
        this.codeTableCache = new CodeTableCache(maxCodeTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessor(Object processorID, QueryProcessor processor) {
        Map map = this.processors;
        synchronized (map) {
            LinkedList<QueryProcessor> list = (LinkedList<QueryProcessor>)this.processors.get(processorID);
            if (list == null) {
                list = new LinkedList<QueryProcessor>();
                this.processors.put(processorID, list);
            }
            list.addFirst(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProcessor(Object processorID) {
        Map map = this.processors;
        synchronized (map) {
            LinkedList list = (LinkedList)this.processors.get(processorID);
            if (list != null) {
                list.removeFirst();
                if (list.isEmpty()) {
                    this.processors.remove(processorID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryProcessor getProcessor(Object processorID) {
        Map map = this.processors;
        synchronized (map) {
            LinkedList list = (LinkedList)this.processors.get(processorID);
            if (list != null) {
                return (QueryProcessor)list.getFirst();
            }
            return null;
        }
    }

    public void registerRequest(Object processorID, Command command, String modelName, int nodeID) throws MetaMatrixComponentException {
        RequestMessage request = this.requestMgr.getRequest((RequestID)processorID);
        if (request != null) {
            AtomicRequestMessage aqr = new AtomicRequestMessage(request);
            aqr.markSubmissionStart();
            aqr.setCommand(command);
            aqr.setNodeID(nodeID);
            aqr.setExecCount(execCount++);
            aqr.setModelName(modelName);
            aqr.setCursorType(request.getCursorType());
            aqr.setFetchSize(this.bufferService.getBufferManager().getConnectorBatchSize());
            String binding = modelName;
            if (!modelName.startsWith("mmuuid")) {
                List bindings = this.vdbService.getConnectorBindingNames(request.getVdbName(), request.getVdbVersion(), modelName);
                if (bindings == null || bindings.isEmpty()) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_binding", new Object[]{modelName, request.getVdbName(), request.getVdbVersion()}));
                }
                binding = (String)bindings.get(0);
            }
            aqr.setConnectorBindingID(binding);
            this.registerRequest(aqr);
        } else {
            LogManager.logWarning((String)"DQP", (String)DQPPlugin.Util.getString("DataTierManager.Could_not_register_the_request_for_{0}_as_request_has_been_removed_from_QueryService.", new Object[]{processorID}));
        }
    }

    public void registerRequest(AtomicRequestMessage request) throws MetaMatrixComponentException {
        ConnectorID connectorID = request.getConnectorID();
        String connectorBindingID = request.getConnectorBindingID();
        try {
            ConnectorRequest info;
            if (connectorID == null || connectorID.getID() == null) {
                if (connectorBindingID == null) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_id"));
                }
                connectorID = this.dataService.selectConnector(connectorBindingID);
            }
            boolean execute = true;
            if (request.getType() == 5) {
                info = this.requestMgr.getConnectorRequest(request.getRequestID(), request.getNodeID());
                if (info != null && info.canImplicitlyClosed()) {
                    request.setType(4);
                } else if (request.isTransactional()) {
                    request.setType(6);
                } else {
                    execute = false;
                }
            }
            if (request.getType() == 1) {
                info = new ConnectorRequest(request, connectorID);
                this.requestMgr.addConnectorRequest(request.getRequestID(), request.getNodeID(), info);
            } else if (request.getType() == 4) {
                this.requestMgr.removeConnectorRequest(request.getRequestID(), request.getNodeID());
            }
            if (execute) {
                this.dataService.executeRequest(request, connectorID, (MessageListener)this);
            }
        }
        catch (Exception ex) {
            String connectorName = this.getConnectorName(request.getRequestID(), connectorBindingID, connectorID);
            String message = DQPPlugin.Util.getString("DataTierManager.cannot_register_request", (Object)connectorName, (Object)connectorID, (Object)ex.getMessage());
            MetaMatrixComponentException exx = new MetaMatrixComponentException((Throwable)ex, message);
            if (request.supportsPartialResults()) {
                this.deliverExceptionResult(request, (MetaMatrixException)((Object)exx));
                this.enqueueRequest(request.getRequestID());
            }
            throw exx;
        }
    }

    private String getConnectorName(RequestID requestId, String connectorBindingID, ConnectorID connectorID) {
        List infos;
        String connectorName = null;
        if (connectorBindingID == null && connectorID != null && (infos = this.requestMgr.getAllConnectorInfo(requestId)) != null) {
            Iterator iter = infos.iterator();
            while (iter.hasNext()) {
                ConnectorRequest info = (ConnectorRequest)iter.next();
                if (!connectorID.equals((Object)info.getConnectorID())) continue;
                connectorBindingID = info.getConnectorBindingID();
                break;
            }
        }
        if (connectorBindingID != null) {
            try {
                connectorName = this.vdbService.getConnectorName(connectorBindingID);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return connectorName;
    }

    public void deliverMessage(Message message, String messageKey) {
        ResultsMessage response = (ResultsMessage)message;
        RequestID requestID = response.getRequestID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        if (request == null) {
            if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
                LogManager.logDetail((String)"DQP", (String)DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_request_has_been_removed_from_QueryService.", (Object)requestID));
            }
            return;
        }
        if (request.isTransactional()) {
            TransactionContext requestTxnContxt = request.getTransactionContext();
            TransactionContext responseTxnContxt = response.getTransactionContext();
            if (responseTxnContxt != null && responseTxnContxt.hasResult()) {
                block38: {
                    Object[] params;
                    try {
                        MMTransactionManager txnMgr = this.txnService.getTransactionManager();
                        txnMgr.resumeTransaction(requestTxnContxt, null);
                        txnMgr.addTransactionResult(responseTxnContxt);
                        txnMgr.suspendTransaction(requestTxnContxt);
                    }
                    catch (XATransactionException e) {
                        params = new Object[]{requestID};
                        LogManager.logError((String)"DQP", (Throwable)e, (String)DQPPlugin.Util.getString("DataTierManager.Unable_to_add_txn_result_for_request_{0}", params));
                        if (response.getException() == null) {
                            response.setException((Throwable)e);
                        }
                    }
                    catch (MetaMatrixComponentException e) {
                        params = new Object[]{requestID};
                        LogManager.logError((String)"DQP", (Throwable)e, (String)DQPPlugin.Util.getString("DataTierManager.Unable_to_add_txn_result_for_request_{0}", params));
                        if (response.getException() != null) break block38;
                        response.setException((Throwable)e);
                    }
                }
                response.setTransactionContext(null);
            }
        }
        int nodeID = response.getPlanNodeID();
        boolean requestEnqueued = false;
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)6)) {
            LogManager.logTrace((String)"DQP", (Object[])new Object[]{"DataTierManager - deliver response, requestID =", requestID, ", nodeID =", new Integer(nodeID)});
        }
        if (response.getException() != null) {
            if (this.codeTableCache.isCodeTableResponse(requestID, nodeID)) {
                this.handleCodeTableError(requestID, nodeID, response.getException());
                requestEnqueued = true;
            } else if (!request.supportsPartialResults()) {
                this.notifyProcessorOfError(requestID, response.getException());
            } else {
                ConnectorRequest info = this.requestMgr.getConnectorRequest(requestID, nodeID);
                if (info != null) {
                    this.deliverExceptionResult(info.getAtomicRequest(), response.getException());
                } else {
                    String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_partial_results_for_{0}_as_the_atomic_query_request_could_not_be_obtained_for_nodeID_{1}", new Object[]{requestID, new Integer(nodeID)});
                    if (this.requestMgr.isRequestCancelled(requestID)) {
                        LogManager.logDetail((String)"DQP", (String)msg);
                    } else {
                        LogManager.logWarning((String)"DQP", (String)msg);
                    }
                }
            }
            this.requestMgr.removeConnectorRequest(requestID, nodeID);
        } else {
            boolean isLastBatch;
            if (LogManager.isMessageToBeRecorded((String)"DQP", (int)6)) {
                LogManager.logTrace((String)"DQP", (Object[])new Object[]{"first=", new Integer(response.getFirstRow()), ", final=", new Integer(response.getFinalRow()), ", isPartial=", response.isPartialResults()});
            }
            boolean bl = isLastBatch = response.getFinalRow() >= 0;
            if (this.codeTableCache.isCodeTableResponse(requestID, nodeID)) {
                boolean codeTableLoadable = this.isCodeTableLoadable(response.getLastRow());
                if (!codeTableLoadable) {
                    this.requestMgr.removeConnectorRequest(requestID, nodeID);
                    Object[] params = new Object[]{requestID, new Integer(nodeID)};
                    String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_load_code_table_for_requestID_{0}_of_and_nodeID_of_{1}_because_result_sizes_exceeds_the_allowed_parameter_-_MaxCodeTableRecords.", params);
                    LogManager.logError((String)"DQP", (String)msg);
                    MetaMatrixComponentException me = new MetaMatrixComponentException("ERR.018.005.0100", DQPPlugin.Util.getString("ERR.018.005.0100", (Object)requestID, (Object)new Integer(nodeID)));
                    this.handleCodeTableError(requestID, nodeID, (MetaMatrixException)((Object)me));
                    requestEnqueued = true;
                } else {
                    this.codeTableCache.loadTable(requestID, nodeID, response.getResults());
                    if (!isLastBatch) {
                        ConnectorRequest info = this.requestMgr.getConnectorRequest(requestID, nodeID);
                        AtomicRequestMessage aqr = DataTierManager.createAtomicRequest(info.getAtomicRequest(), info.getConnectorID(), 2);
                        try {
                            this.registerRequest(aqr);
                        }
                        catch (MetaMatrixComponentException e) {
                            String msg = DQPPlugin.Util.getString("DataTierManager.Failed_to_register_request.");
                            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
                            this.requestMgr.removeConnectorRequest(requestID, nodeID);
                            this.handleCodeTableError(requestID, nodeID, (MetaMatrixException)((Object)e));
                            requestEnqueued = true;
                        }
                    } else {
                        Set requests = this.codeTableCache.markCacheLoaded(requestID, nodeID);
                        this.notifyWaitingCodeTableRequests(requests);
                        requestEnqueued = true;
                    }
                }
            } else if (response.getFirstRow() <= 1) {
                QueryTupleSource ts = null;
                ConnectorRequest info = this.requestMgr.getConnectorRequest(requestID, nodeID);
                if (info != null) {
                    info.setImplicitlyClosed(response.supportsImplicitClose());
                    AtomicRequestMessage original = info.getAtomicRequest();
                    original.setProcessingTimestamp(response.getProcessingTimestamp());
                    AtomicRequestMessage aqr = DataTierManager.createAtomicRequest(original, info.getConnectorID(), 2);
                    if (isLastBatch) {
                        ts = new QueryTupleSource(response.getResults(), response.getCommand().getProjectedSymbols(), aqr, this);
                    } else {
                        DataTierTupleSource dtts = new DataTierTupleSource(original.getCommand().getProjectedSymbols(), aqr, this);
                        info.setTupleSource(dtts);
                        ts = dtts;
                        dtts.addBatch(response.getResults(), false);
                    }
                }
                if (ts != null) {
                    this.deliverTupleSourceToProcessor(requestID, nodeID, (TupleSource)ts);
                } else {
                    this.failedToDeliver(requestID, nodeID);
                }
            } else {
                LogManager.logTrace((String)"DQP", (String)"Delivering more batch=");
                ConnectorRequest info = this.requestMgr.getConnectorRequest(requestID, nodeID);
                if (info != null) {
                    info.getTupleSource().addBatch(response.getResults(), isLastBatch);
                } else {
                    this.failedToDeliver(requestID, nodeID);
                }
            }
        }
        if (!requestEnqueued) {
            this.enqueueRequest(requestID);
        }
    }

    private void failedToDeliver(RequestID requestID, int nodeID) {
        Object[] params = new Object[]{requestID};
        String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_a_matching_atomic_request_could_not_be_found.", params);
        if (this.requestMgr.isRequestCancelled(requestID) || this.requestMgr.getConnectorRequest(requestID, nodeID) == null) {
            LogManager.logDetail((String)"DQP", (String)msg);
        } else {
            LogManager.logWarning((String)"DQP", (String)msg);
            MetaMatrixComponentException exception = new MetaMatrixComponentException(msg);
            this.notifyProcessorOfError(requestID, (MetaMatrixException)((Object)exception));
        }
    }

    private void handleCodeTableError(RequestID requestID, int nodeID, MetaMatrixException e) {
        this.notifyProcessorOfError(requestID, e);
        Set requests = this.codeTableCache.errorLoadingCache(requestID, nodeID);
        this.notifyWaitingCodeTableRequests(requests);
    }

    private void notifyWaitingCodeTableRequests(Collection requests) {
        if (requests != null) {
            Iterator reqIter = requests.iterator();
            while (reqIter.hasNext()) {
                this.enqueueRequest((RequestID)reqIter.next());
            }
        }
    }

    private void enqueueRequest(RequestID requestID) {
        try {
            this.requestMgr.markHasData(requestID, new WorkItem(requestID));
        }
        catch (QueueSuspendedException queueSuspendedException) {
            // empty catch block
        }
    }

    private void deliverExceptionResult(AtomicRequestMessage aqr, MetaMatrixException exception) {
        RequestID requestID = aqr.getRequestID();
        String connectorBindingName = this.vdbService.getConnectorName(aqr.getConnectorBindingID());
        Query query = (Query)aqr.getCommand();
        ArrayList groupSymbols = new ArrayList();
        GroupCollectorVisitor.getGroups((LanguageObject)query, groupSymbols);
        GroupSymbol group = (GroupSymbol)groupSymbols.get(0);
        SourceFailureDetails sourceFailure = new SourceFailureDetails(group.getName(), connectorBindingName, exception);
        this.requestMgr.addSourceFailureDetails(sourceFailure, requestID);
        List elements = query.getProjectedSymbols();
        NullTupleSource source = new NullTupleSource(elements);
        this.deliverTupleSourceToProcessor(requestID, aqr.getNodeID(), (TupleSource)source);
    }

    private static AtomicRequestMessage createAtomicRequest(AtomicRequestMessage original, ConnectorID connectorID, int type) {
        AtomicRequestMessage aqr = new AtomicRequestMessage((RequestMessage)original);
        aqr.setCommand(original.getCommand());
        aqr.setConnectorBindingID(original.getConnectorBindingID());
        aqr.setType(type);
        aqr.setConnectorID(connectorID);
        aqr.setNodeID(original.getNodeID());
        aqr.setExecCount(original.getExecCount());
        return aqr;
    }

    private void notifyProcessorOfError(Object requestID, MetaMatrixException e) {
        QueryProcessor processor = this.getProcessor(requestID);
        if (processor != null) {
            processor.errorOccurred(e);
        } else {
            String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_the_QueryProcessor_could_not_be_obtained.", requestID);
            if (this.requestMgr.isRequestCancelled(requestID)) {
                LogManager.logDetail((String)"DQP", (String)msg);
            } else {
                LogManager.logWarning((String)"DQP", (String)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getProcessors(Object processorID) {
        Map map = this.processors;
        synchronized (map) {
            return (LinkedList)this.processors.get(processorID);
        }
    }

    private void deliverTupleSourceToProcessor(RequestID requestID, int nodeID, TupleSource ts) {
        List processors = this.getProcessors(requestID);
        if (processors != null) {
            QueryProcessor processor;
            if (LogManager.isMessageToBeRecorded((String)"DQP", (int)6)) {
                LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Delivering response for ", requestID, "to processor with nodeID =", new Integer(nodeID)});
            }
            for (int i = 0; i < processors.size() && !(processor = (QueryProcessor)processors.get(i)).connectTupleSource(ts, nodeID); ++i) {
            }
        } else {
            String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_the_QueryProcessor_could_not_be_obtained.", (Object)requestID);
            if (this.requestMgr.isRequestCancelled(requestID)) {
                LogManager.logDetail((String)"DQP", (String)msg);
            } else {
                this.requestMgr.removeConnectorRequest(requestID, nodeID);
                LogManager.logWarning((String)"DQP", (String)msg);
            }
        }
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, MetaMatrixComponentException {
        int existsCode = this.codeTableCache.cacheExists(codeTableName, returnElementName, keyElementName, context);
        if (existsCode == 0) {
            return this.codeTableCache.lookupValue(codeTableName, returnElementName, keyElementName, keyValue);
        }
        if (existsCode == 2) {
            this.registerCodeTableRequest(context, codeTableName, returnElementName, keyElementName);
        } else if (existsCode == 3) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_load_code_table_because_code_table_entries_exceeds_the_allowed_parameter_-_MaxCodeTables.");
            LogManager.logError((String)"DQP", (String)msg);
            throw new MetaMatrixComponentException("ERR.018.005.0099", DQPPlugin.Util.getString("ERR.018.005.0099"));
        }
        throw BlockedException.INSTANCE;
    }

    private void registerCodeTableRequest(CommandContext context, String codeTableName, String returnElementName, String keyElementName) throws MetaMatrixComponentException {
        RequestID requestID = (RequestID)context.getProcessorID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        Query query = null;
        String modelName = null;
        QueryMetadataInterface metadata = null;
        try {
            metadata = this.metadataService.lookupMetadata(request.getVdbName(), request.getVdbVersion());
            query = new Query();
            Select select = new Select();
            select.addSymbol((SelectSymbol)new ElementSymbol(keyElementName));
            select.addSymbol((SelectSymbol)new ElementSymbol(returnElementName));
            query.setSelect(select);
            From from = new From();
            from.addGroup(new GroupSymbol(codeTableName));
            query.setFrom(from);
            QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)metadata);
            GroupSymbol group = (GroupSymbol)query.getFrom().getGroups().get(0);
            Object modelID = metadata.getModelID(group.getMetadataID());
            modelName = metadata.getFullName(modelID);
        }
        catch (QueryMetadataException e) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_get_metadata.");
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
            throw new ComponentNotAvailableException((Throwable)e, msg);
        }
        catch (QueryResolverException e) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_resolve_query.");
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
            throw new ComponentNotAvailableException((Throwable)e, msg);
        }
        int codeTableNodeID = this.requestMgr.getCodeTableNodeID(requestID);
        this.codeTableCache.setRequestID(codeTableName, returnElementName, keyElementName, requestID, codeTableNodeID);
        this.registerRequest(context.getProcessorID(), (Command)query, modelName, codeTableNodeID);
    }

    private boolean isCodeTableLoadable(int lastRow) {
        return lastRow <= this.maxCodeTableRecords;
    }

    public void clearCodeTables() {
        this.codeTableCache.clearAll();
    }
}

