/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class BP1104
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1104(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        MessageEntry request = entryContext.getRequest();
        String headers = request.getHTTPHeaders();
        String contentType = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("Content-Type".toUpperCase());
        String httpStatus = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
        if (contentType != null && contentType.indexOf("text/xml") != -1) {
            this.result = "notApplicable";
        } else if (!"415".equals(httpStatus)) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail("\nRequest message:\nHeaders:\n" + entryContext.getRequest().getHTTPHeaders() + "\nMessage:\n" + entryContext.getRequest().getMessage() + "\n\nResponse message:\nHeaders:\n" + entryContext.getResponse().getHTTPHeaders() + "\nMessage:\n" + entryContext.getResponse().getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

