/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import com.metamatrix.query.validator.ValidateCriteriaVisitor;
import com.metamatrix.query.validator.ValidationVisitor;
import com.metamatrix.query.validator.ValidatorReport;
import java.util.Iterator;
import java.util.Map;

public class Validator {
    public static final ValidatorReport validate(LanguageObject object, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return Validator.validate(object, metadata, true);
    }

    public static final ValidatorReport validate(LanguageObject object, QueryMetadataInterface metadata, boolean validateCriteria) throws MetaMatrixComponentException {
        ValidatorReport report1 = Validator.validate(object, metadata, new ValidationVisitor(), false);
        if (validateCriteria) {
            ValidatorReport report2 = Validator.validate(object, metadata, (AbstractValidationVisitor)new ValidateCriteriaVisitor(), true);
            report1.addItems(report2.getItems());
        }
        return report1;
    }

    public static final ValidatorReport validate(LanguageObject object, QueryMetadataInterface metadata, AbstractValidationVisitor visitor, boolean validateOnlyEmbedded) throws MetaMatrixComponentException {
        if (object instanceof Command) {
            Command command = (Command)object;
            int cmdType = command.getType();
            if (cmdType == 7) {
                CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
                Map tempMetadata = command.getTemporaryMetadata();
                if (tempMetadata != null) {
                    metadata = new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata));
                }
                Validator.executeValidation((LanguageObject)procCommand, metadata, visitor);
                return visitor.getReport();
            }
            Iterator iter = CommandCollectorVisitor.getCommands(object, validateOnlyEmbedded).iterator();
            while (iter.hasNext()) {
                Command subCommand = (Command)iter.next();
                Validator.validate((LanguageObject)subCommand, metadata, visitor, validateOnlyEmbedded);
            }
            Map tempMetadata = command.getTemporaryMetadata();
            if (tempMetadata != null && !tempMetadata.isEmpty()) {
                metadata = new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata));
            }
        }
        Validator.executeValidation(object, metadata, visitor);
        return visitor.getReport();
    }

    private static final void executeValidation(LanguageObject object, QueryMetadataInterface metadata, AbstractValidationVisitor visitor) throws MetaMatrixComponentException {
        visitor.reset();
        visitor.setMetadata(metadata);
        if (visitor instanceof ValidateCriteriaVisitor) {
            PreOrderNavigator nav = new PreOrderNavigator((LanguageVisitor)visitor){

                public void visit(Update obj) {
                    this.preVisitVisitor((LanguageObject)obj);
                    this.visitNode((LanguageObject)obj.getGroup());
                    this.visitNode((LanguageObject)obj.getCriteria());
                    this.visitNode((LanguageObject)obj.getOption());
                    this.postVisitVisitor((LanguageObject)obj);
                }
            };
            object.acceptVisitor((LanguageVisitor)nav);
        } else {
            PreOrderNavigator.doVisit((LanguageObject)object, (LanguageVisitor)visitor);
        }
        MetaMatrixComponentException e = visitor.getException();
        if (e != null) {
            throw e;
        }
    }
}

