/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuleChooseJoinStrategy
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)7, (int)3);
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode joinNode = (PlanNode)nodeIter.next();
            RuleChooseJoinStrategy.makeMerge(joinNode, metadata);
        }
        return plan;
    }

    static void makeMerge(PlanNode joinNode, QueryMetadataInterface metadata) {
        JoinType jtype = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals((Object)JoinType.JOIN_CROSS) || jtype.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            return;
        }
        PlanNode leftChild = joinNode.getFirstChild();
        if ((leftChild = FrameUtil.findJoinSourceNode((PlanNode)leftChild)) == null) {
            return;
        }
        PlanNode rightChild = joinNode.getLastChild();
        if ((rightChild = FrameUtil.findJoinSourceNode((PlanNode)rightChild)) == null) {
            return;
        }
        Set leftGroups = leftChild.getGroups();
        Set rightGroups = rightChild.getGroups();
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        ArrayList<Criteria> nonEquiJoinCriteria = new ArrayList<Criteria>();
        Iterator iter = crits.iterator();
        while (iter.hasNext()) {
            Criteria theCrit = (Criteria)iter.next();
            HashSet critGroups = new HashSet(GroupsUsedByElementsVisitor.getGroups((LanguageObject)theCrit));
            if (leftGroups.containsAll(critGroups) || rightGroups.containsAll(critGroups)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (!(theCrit instanceof CompareCriteria)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            CompareCriteria crit = (CompareCriteria)theCrit;
            if (crit.getOperator() != 1) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            Expression leftExpr = crit.getLeftExpression();
            Expression rightExpr = crit.getRightExpression();
            HashSet leftExprGroups = new HashSet(GroupsUsedByElementsVisitor.getGroups((LanguageObject)leftExpr));
            HashSet rightExprGroups = new HashSet(GroupsUsedByElementsVisitor.getGroups((LanguageObject)rightExpr));
            if (leftGroups.containsAll(leftExprGroups)) {
                if (rightGroups.containsAll(rightExprGroups)) {
                    leftExpressions.add(leftExpr);
                    rightExpressions.add(rightExpr);
                    continue;
                }
                if (!rightExprGroups.isEmpty()) continue;
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (rightGroups.containsAll(leftExprGroups)) {
                if (leftGroups.containsAll(rightExprGroups)) {
                    leftExpressions.add(rightExpr);
                    rightExpressions.add(leftExpr);
                    continue;
                }
                if (!rightExprGroups.isEmpty()) continue;
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            nonEquiJoinCriteria.add(theCrit);
        }
        if (!leftExpressions.isEmpty()) {
            joinNode.setProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS, leftExpressions);
            joinNode.setProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS, rightExpressions);
            joinNode.setProperty((Object)NodeConstants.Info.JOIN_STRATEGY, (Object)JoinStrategyType.MERGE);
            joinNode.setProperty((Object)NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, nonEquiJoinCriteria);
        }
    }

    public String toString() {
        return "ChooseJoinStrategy";
    }
}

