/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public interface SessionServiceInterface
extends ServiceInterface {
    public static final String NAME = "SessionService";

    public MetaMatrixSessionInfo createSession(String var1, Credentials var2, Serializable var3, String var4, String var5, String[] var6) throws MetaMatrixAuthenticationException, SessionServiceException, ServiceException, RemoteException;

    public void unbindProductFromSession(MetaMatrixSessionID var1, String var2) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public void closeSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public boolean terminateSession(MetaMatrixSessionID var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, RemoteException;

    public boolean terminateSessions(Collection var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, RemoteException;

    public boolean removeSessions(Collection var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, RemoteException;

    public boolean isSessionValid(MetaMatrixSessionID var1) throws SessionServiceException, ServiceException, RemoteException;

    public MetaMatrixSessionInfo getSessionInfo(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public String getLastSessionTime() throws SessionServiceException, ServiceStateException, RemoteException;

    public Collection getActiveSessions() throws SessionServiceException, ServiceException, RemoteException;

    public Collection getAllSessions() throws SessionServiceException, ServiceException, RemoteException;

    public int getActiveSessionsCount() throws SessionServiceException, ServiceException, RemoteException;

    public int getAllSessionsCount() throws SessionServiceException, ServiceException, RemoteException;

    public int getActiveConnectionsCountForProduct(String var1) throws SessionServiceException, ServiceException, RemoteException;

    public int getAllConnectionsCountForProduct(String var1) throws SessionServiceException, ServiceException, RemoteException;

    public Collection getActiveSessionsForUser(String var1) throws InvalidUserException, SessionServiceException, ServiceException, RemoteException;

    public List getSessionsForUser(String var1) throws InvalidUserException, SessionServiceException, ServiceException, RemoteException;

    public Set getLoggedOnPrincipals() throws SessionServiceException, ServiceException, RemoteException;

    public MetaMatrixPrincipal getPrincipal(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public SessionToken validateSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public void updateSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public void updateSession(MetaMatrixSessionID var1, int var2) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public void setIsSubscriber(MetaMatrixSessionID var1, boolean var2) throws InvalidSessionException, SessionServiceException, ServiceException, RemoteException;

    public Collection getSessionsLoggedInToVDB(String var1, String var2) throws SessionServiceException, ServiceStateException, RemoteException;

    public void reinitializeSessionCleanup(Properties var1) throws SessionServiceException, ServiceStateException, RemoteException;

    public void pingServer(MetaMatrixSessionID var1) throws ServiceStateException, RemoteException;
}

