/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.exception.security.MetaBaseResourceNotResolvedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.DataAccessResource;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;

public class BasicAuthorizationPermission
extends AuthorizationPermission
implements Cloneable {
    public static final String RECURSIVE = "*";
    public static final String SEPARATOR_WITH_RECURSIVE = ".*";

    BasicAuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String contentModifier, String factoryClassName) {
        super(resource, realm, actions, contentModifier, factoryClassName);
    }

    BasicAuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realmName, String factoryClassName) {
        super(resource, realmName, factoryClassName);
    }

    BasicAuthorizationPermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String factoryClassName) {
        super(resource, realm, actions, factoryClassName);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new BasicAuthorizationPermission(this.getResource(), this.getRealm(), this.getActions(), this.getContentModifier(), this.getFactoryClassName());
    }

    public boolean implies(AuthorizationPermission request) throws MetaBaseResourceNotResolvedException {
        if (!(request instanceof BasicAuthorizationPermission)) {
            return false;
        }
        if (this.getActions().equals(StandardAuthorizationActions.NONE) || request.getActions().equals(StandardAuthorizationActions.NONE)) {
            return false;
        }
        if (!this.getRealm().equals(request.getRealm())) {
            return false;
        }
        LogManager.logTrace("AUTHORIZATION", "implies(): Realms are equal");
        if (!this.getActions().implies(request.getActions())) {
            return false;
        }
        LogManager.logTrace("AUTHORIZATION", "implies(): Actions are implied");
        BasicAuthorizationPermission that = (BasicAuthorizationPermission)request;
        DataAccessResource thisResource = (DataAccessResource)this.getResource();
        return thisResource.implies(that.getResource());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicAuthorizationPermission) {
            return BasicAuthorizationPermission.compare(this, (BasicAuthorizationPermission)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0037"));
        }
        if (!(o instanceof BasicAuthorizationPermission)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0038", o.getClass()));
        }
        return BasicAuthorizationPermission.compare(this, (BasicAuthorizationPermission)o);
    }

    public static String removeRecursion(String resourceName) {
        return resourceName.substring(0, resourceName.indexOf(SEPARATOR_WITH_RECURSIVE));
    }

    public static boolean isRecursiveResource(String resourceName) {
        return resourceName.endsWith(SEPARATOR_WITH_RECURSIVE);
    }
}

