/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.dqp.client.ResultsMetadata;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import java.util.Map;

class ResultsMetadataImpl
implements ResultsMetadata {
    private Map[] columnMetadata;

    ResultsMetadataImpl(MetaDataMessage message) {
        this.columnMetadata = message.getMetadataMap();
    }

    public int getColumnCount() {
        return this.columnMetadata.length;
    }

    public String getVirtualDatabaseName(int index) {
        return this.getString(index, ResultsMetadataConstants.VIRTUAL_DATABASE_NAME);
    }

    public String getVirtualDatabaseVersion(int index) {
        return this.getString(index, ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION);
    }

    public String getTableName(int index) {
        return this.getString(index, ResultsMetadataConstants.GROUP_NAME);
    }

    public String getColumnName(int index) {
        return this.getString(index, ResultsMetadataConstants.ELEMENT_NAME);
    }

    public String getColumnTypeName(int index) {
        return this.getString(index, ResultsMetadataConstants.DATA_TYPE);
    }

    public boolean isAutoIncrement(int index) {
        return this.getBoolean(index, ResultsMetadataConstants.AUTO_INCREMENTING);
    }

    public boolean isCaseSensitive(int index) {
        return this.getBoolean(index, ResultsMetadataConstants.CASE_SENSITIVE);
    }

    public boolean isSearchable(int index) {
        int searchability = this.getInt(index, ResultsMetadataConstants.SEARCHABLE);
        return searchability != ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE;
    }

    public boolean isCurrency(int index) {
        return this.getBoolean(index, ResultsMetadataConstants.CURRENCY);
    }

    public boolean isNullable(int index) {
        int nullability = this.getInt(index, ResultsMetadataConstants.NULLABLE);
        return nullability != ResultsMetadataConstants.NULL_TYPES.NOT_NULL;
    }

    public boolean isSigned(int index) {
        return this.getBoolean(index, ResultsMetadataConstants.SIGNED);
    }

    public int getColumnDisplaySize(int index) {
        return this.getInt(index, ResultsMetadataConstants.DISPLAY_SIZE);
    }

    public String getColumnLabel(int index) {
        return this.getString(index, ResultsMetadataConstants.ELEMENT_LABEL);
    }

    public int getPrecision(int index) {
        return this.getInt(index, ResultsMetadataConstants.PRECISION);
    }

    public int getScale(int index) {
        return this.getInt(index, ResultsMetadataConstants.SCALE);
    }

    public boolean isReadOnly(int index) {
        return !this.getBoolean(index, ResultsMetadataConstants.WRITABLE);
    }

    public String getColumnClassName(int index) {
        return MMJDBCSQLTypeInfo.getJavaClassName(MMJDBCSQLTypeInfo.getSQLType(this.getColumnTypeName(index)));
    }

    private String getString(int index, Object key) {
        return (String)this.columnMetadata[index - 1].get(key);
    }

    private boolean getBoolean(int index, Object key) {
        return (Boolean)this.columnMetadata[index - 1].get(key);
    }

    private int getInt(int index, Object key) {
        return ((Number)this.columnMetadata[index - 1].get(key)).intValue();
    }
}

