/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SqlResourceBundle {
    public static final String DEFAULT_LANGUAGE = "oracle";
    private static final String DELIMITER = "_";
    private final ResourceBundle bundle;
    private final String bundleName;
    private final Map simpleStrings;
    private String stringDelimiter;
    private String stringDelimiterEscapeCharacter;

    public static SqlResourceBundle getBundle(String bundleName) throws MissingResourceException {
        if (bundleName == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_SQL_resource_bundle_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        return SqlResourceBundle.findBundle(bundleName, DEFAULT_LANGUAGE, null);
    }

    public static SqlResourceBundle getBundle(String bundleName, String dbmsLanguage) throws MissingResourceException {
        if (bundleName == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_SQL_resource_bundle_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (dbmsLanguage == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_DBMS_language_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        return SqlResourceBundle.findBundle(bundleName, dbmsLanguage, null);
    }

    public static SqlResourceBundle getBundle(String bundleName, ClassLoader loader) throws MissingResourceException {
        if (bundleName == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_SQL_resource_bundle_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (loader == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_class_loader_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        return SqlResourceBundle.findBundle(bundleName, DEFAULT_LANGUAGE, loader);
    }

    public static SqlResourceBundle getBundle(String bundleName, String dbmsLanguage, ClassLoader loader) throws MissingResourceException {
        if (bundleName == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_SQL_resource_bundle_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (dbmsLanguage == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_DBMS_language_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (loader == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_class_loader_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        return SqlResourceBundle.findBundle(bundleName, dbmsLanguage, loader);
    }

    protected SqlResourceBundle(ResourceBundle bundle, String bundleName) {
        if (bundle == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_resource_bundle_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (bundleName == null) {
            String msg = CorePlugin.Util.getString("SqlResourceBundle.The_name_of_the_SQL_resource_bundle_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.bundle = bundle;
        this.bundleName = bundleName;
        this.simpleStrings = new HashMap();
        this.initializeStringDelimiter();
    }

    protected void initializeStringDelimiter() {
        this.stringDelimiter = this.getString("StringDelimiter");
        this.stringDelimiterEscapeCharacter = this.getString("StringDelimiterEscapeCharacter");
        if (this.stringDelimiter.startsWith("<Missing message")) {
            this.stringDelimiter = null;
        }
        if (this.stringDelimiterEscapeCharacter.startsWith("<Missing message")) {
            this.stringDelimiterEscapeCharacter = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public String getString(String key) {
        try {
            String value = (String)this.simpleStrings.get(key);
            if (value == null) {
                value = this.bundle.getString(key);
                this.simpleStrings.put(key, value);
            }
            return value;
        }
        catch (NullPointerException e) {
            return "<No message available>";
        }
        catch (MissingResourceException e) {
            return "<Missing message for key \"" + key + "\" in: " + this.bundleName + '>';
        }
    }

    public String getString(String key, Object[] parameters) {
        return this.doGetString(key, Arrays.asList(parameters));
    }

    public String getString(String key, List parameters) {
        return this.doGetString(key, new ArrayList(parameters));
    }

    public String doGetString(String key, List parameters) {
        String text = this.getString(key);
        if (text == null) {
            return '<' + key + '>';
        }
        if (parameters == null || parameters.size() == 0) {
            return text;
        }
        if (this.stringDelimiter != null) {
            ListIterator<String> iter = parameters.listIterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                if (param == null) continue;
                if (param instanceof String) {
                    param = StringUtil.replaceAll((String)param, this.stringDelimiter, this.stringDelimiterEscapeCharacter + this.stringDelimiter);
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.stringDelimiter);
                    sb.append(param);
                    sb.append(this.stringDelimiter);
                    iter.set(sb.toString());
                    continue;
                }
                iter.set(param.toString());
            }
        }
        return MessageFormat.format(text, parameters.toArray());
    }

    protected static SqlResourceBundle findBundle(String bundleName, String dbmsLanguage, ClassLoader loader) throws MissingResourceException {
        ArgCheck.isNotNull(bundleName);
        ResourceBundle result = null;
        try {
            String baseName = dbmsLanguage != null ? bundleName + DELIMITER + dbmsLanguage : bundleName;
            result = loader != null ? ResourceBundle.getBundle(baseName, Locale.getDefault(), loader) : ResourceBundle.getBundle(baseName);
            return new SqlResourceBundle(result, baseName);
        }
        catch (MissingResourceException e) {
            try {
                result = loader != null ? ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader) : ResourceBundle.getBundle(bundleName);
                return new SqlResourceBundle(result, bundleName);
            }
            catch (MissingResourceException e2) {
                String baseName = dbmsLanguage != null ? bundleName + DELIMITER + dbmsLanguage : bundleName;
                Object[] params = new Object[]{bundleName, dbmsLanguage};
                String msg = CorePlugin.Util.getString("SqlResourceBundle.unable_to_find_bundle", params);
                throw new MissingResourceException(msg, baseName, null);
            }
        }
    }

    public static class CommonKeys {
        public static final String STRING_DELIMITER = "StringDelimiter";
        public static final String STRING_DELIMITER_ESCAPE_CHARACTER = "StringDelimiterEscapeCharacter";
    }

    public static class DbmsLanguages {
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SQL_SERVER = "sqlserver";
        public static final String DERBY = "derby";
        public static final String SYBASE = "sybase";
    }
}

