/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.PerformanceTracker;
import java.util.HashMap;
import java.util.Iterator;

public class PerformanceTrackerManager {
    private HashMap trackers = new HashMap(10);
    private static final PerformanceTrackerManager instance = new PerformanceTrackerManager();

    public static final PerformanceTrackerManager getInstance() {
        return instance;
    }

    public PerformanceTracker getTracker(String id) {
        return this.getTracker(id, true);
    }

    public PerformanceTracker getTracker(String id, boolean doTime) {
        PerformanceTracker tracker = null;
        boolean createTracker = false;
        if (this.trackers.isEmpty()) {
            createTracker = true;
        } else {
            tracker = (PerformanceTracker)this.trackers.get(id);
            if (tracker == null) {
                createTracker = true;
            }
        }
        if (createTracker) {
            tracker = new PerformanceTracker(id, doTime);
            this.trackers.put(id, tracker);
        }
        return tracker;
    }

    public void addTracker(PerformanceTracker tracker) {
        this.trackers.put(tracker.getID(), tracker);
    }

    public void removeTracker(PerformanceTracker tracker) {
        this.trackers.remove(tracker.getID());
    }

    public void removeTracker(String trackerID) {
        this.trackers.remove(trackerID);
    }

    public void reset(String trackerID) {
        PerformanceTracker tracker = this.getTracker(trackerID);
        if (tracker != null) {
            tracker.reset();
        }
    }

    public void resetAll() {
        Iterator iter = this.trackers.values().iterator();
        while (iter.hasNext()) {
            PerformanceTracker tracker = (PerformanceTracker)iter.next();
            tracker.reset();
        }
    }

    public void clear() {
        this.trackers.clear();
    }

    public void start(String trackerID, String methodID) {
        PerformanceTracker tracker = this.getTracker(trackerID);
        if (tracker != null) {
            tracker.start(methodID);
        }
    }

    public void stop(String trackerID, String methodID) {
        PerformanceTracker tracker = this.getTracker(trackerID);
        if (tracker != null) {
            tracker.start(methodID);
        }
    }

    public void print(String trackerID) {
        PerformanceTracker tracker = this.getTracker(trackerID);
        if (tracker != null) {
            tracker.print();
        }
    }

    public void print(boolean clear) {
        Iterator iter = this.trackers.keySet().iterator();
        while (iter.hasNext()) {
            String trackerID = (String)iter.next();
            this.print(trackerID);
        }
        if (clear) {
            this.resetAll();
        }
    }
}

