/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.log;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.log.TransactionLogMessage;
import com.metamatrix.common.xa.log.TransactionLogWriter;
import java.util.Map;
import java.util.Properties;

public final class TransactionLogManager {
    public static final String SYSTEM_TXN_STORE_TXN = "metamatrix.transaction.log.storeTXN";
    public static final String SYSTEM_TXN_STORE_MMCMD = "metamatrix.transaction.log.storeMMCMD";
    public static final String SYSTEM_TXN_STORE_SRCCMD = "metamatrix.transaction.log.storeSRCCMD";
    public static final String SYSTEM_LOG_MAX_THREADS = "metamatrix.transaction.log.maxThreads";
    public static final String SYSTEM_LOG_THREAD_TTL = "metamatrix.transaction.log.threadTTL";
    protected static final String DEFAULT_LOG_MAX_THREADS = "1";
    protected static final String DEFAULT_LOG_THREAD_TTL = "600000";
    private static TransactionLogManager INSTANCE = new TransactionLogManager();
    private boolean storeTXN;
    private boolean storeMMCMD;
    private boolean storeSRCCMD;
    private LinkedQueue queue = new LinkedQueue();
    private WorkerPool workerPool;
    private boolean isInitialized = false;
    private boolean isStopped = false;

    protected void finalize() {
        if (this.isManagerStopped()) {
            TransactionLogManager.stop();
        }
    }

    private TransactionLogManager() {
    }

    private void init() {
        Properties currentConfigProperties = new Properties();
        try {
            Properties globalProperties = CurrentConfiguration.getProperties();
            currentConfigProperties.putAll((Map<?, ?>)globalProperties);
            currentConfigProperties.putAll((Map<?, ?>)CurrentConfiguration.getResourceProperties((String)"TransactionLogging"));
        }
        catch (ConfigurationException e) {
            LogManager.logWarning("TXN_LOG", (Throwable)e, CommonXAPlugin.Util.getString("ERR.003.001.0027"));
            currentConfigProperties.putAll((Map<?, ?>)System.getProperties());
        }
        String propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_TXN);
        if (propvalue != null) {
            this.storeTXN = Boolean.valueOf(propvalue);
        }
        if ((propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_MMCMD)) != null) {
            this.storeMMCMD = Boolean.valueOf(propvalue);
        }
        if ((propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_SRCCMD)) != null) {
            this.storeSRCCMD = Boolean.valueOf(propvalue);
        }
        if (!(this.storeTXN || this.storeMMCMD || this.storeSRCCMD)) {
            this.isInitialized = true;
            return;
        }
        this.initializeQueueWorkers(currentConfigProperties);
        this.isInitialized = true;
    }

    private void initializeQueueWorkers(Properties config) {
        String maxThreadsString = System.getProperty(SYSTEM_LOG_MAX_THREADS, DEFAULT_LOG_MAX_THREADS);
        String threadTTLString = System.getProperty(SYSTEM_LOG_THREAD_TTL, DEFAULT_LOG_THREAD_TTL);
        this.workerPool = new WorkerPool("TransactionLog", this.queue, new LogQueueWorkerFactory(config), Integer.parseInt(maxThreadsString), Integer.parseInt(threadTTLString));
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    protected static synchronized TransactionLogManager getInstance() {
        if (!INSTANCE.isInitialized()) {
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public static void stop() {
        TransactionLogManager manager = TransactionLogManager.getInstance();
        LogManager.logCritical("TXN_LOG", CommonXAPlugin.Util.getString("MSG.003.031.0006"));
        manager.workerPool.suspend();
        while (manager.workerPool.hasWork()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException err) {}
        }
        if (manager.workerPool != null) {
            manager.workerPool.shutdown();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        manager.isStopped = manager.workerPool.isStopped();
    }

    public static boolean isStopped() {
        return TransactionLogManager.getInstance().isManagerStopped();
    }

    protected boolean isManagerStopped() {
        return this.isStopped;
    }

    private void addMessageToQueue(TransactionLogMessage msg) throws QueueSuspendedException {
        block4: {
            if (this.workerPool == null) {
                while (true) {
                    try {
                        this.queue.put(msg);
                        break block4;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            this.workerPool.addWork(msg);
        }
    }

    public static void log(String txnUid, short txnPoint, short status, String sessionUid, String principal, String vdbName, String vdbVersion) {
        if (!TransactionLogManager.getInstance().storeTXN) {
            return;
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(txnUid, txnPoint, status, sessionUid, principal, vdbName, vdbVersion);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning("TXN_LOG", (Throwable)e, e.getMessage());
        }
    }

    public static void log(String requestId, String txnUid, short cmdPoint, short status, String sessionUid, String applicationName, String principal, String vdbName, String vdbVersion, Object command, int rowCount) {
        if (!TransactionLogManager.getInstance().storeMMCMD) {
            return;
        }
        String sqlString = null;
        if (command != null) {
            sqlString = command.toString();
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(requestId, txnUid, cmdPoint, status, sessionUid, applicationName, principal, vdbName, vdbVersion, sqlString, rowCount);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning("TXN_LOG", (Throwable)e, e.getMessage());
        }
    }

    public static void log(String requestId, long nodeID, String subTxnUid, short status, String modelName, String cbName, short cmdPoint, String sessionUid, String principal, Object sql, int rowCount) {
        if (!TransactionLogManager.getInstance().storeSRCCMD) {
            return;
        }
        String sqlString = null;
        if (sql != null) {
            sqlString = sql.toString();
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(requestId, nodeID, subTxnUid, status, modelName, cbName, cmdPoint, sessionUid, principal, sqlString, rowCount);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning("TXN_LOG", (Throwable)e, e.getMessage());
        }
    }

    public static boolean isTxnLogged() {
        return TransactionLogManager.getInstance().storeTXN;
    }

    public static boolean isMMCmdLogged() {
        return TransactionLogManager.getInstance().storeMMCMD;
    }

    public static boolean isSrcCmdLogged() {
        return TransactionLogManager.getInstance().storeSRCCMD;
    }

    protected static class LogQueueWorkerFactory
    implements QueueWorkerFactory {
        private Properties config;

        public LogQueueWorkerFactory(Properties config) {
            this.config = config;
        }

        public QueueWorker createWorker() {
            return new LogQueueWorker(this.config);
        }
    }

    protected static class LogQueueWorker
    extends QueueWorker {
        private TransactionLogWriter dbLogger;
        private Properties config;

        public LogQueueWorker(Properties config) {
            this.config = config;
        }

        public void initialize() throws QueueWorkerException {
            this.dbLogger = new TransactionLogWriter();
            this.dbLogger.initialize(this.config);
            LogManager.logInfo("TXN_LOG", CommonXAPlugin.Util.getString("MSG.003.031.0003"));
        }

        public void cleanup() throws QueueWorkerException {
            this.dbLogger.shutdown();
        }

        public void process(Object o) throws QueueWorkerException {
            if (!(o instanceof TransactionLogMessage)) {
                throw new QueueWorkerException(CommonXAPlugin.Util.getString("ERR.003.001.0030", o));
            }
            this.dbLogger.print((TransactionLogMessage)o);
        }
    }
}

