/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.common.types.basic.AnyToStringTransform;

public class ObjectToAnyTransform
extends AnyToStringTransform {
    private Class targetClass;

    public ObjectToAnyTransform(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getSourceType() {
        return DataTypeManager.DefaultDataClasses.OBJECT;
    }

    public Class getTargetType() {
        return this.targetClass;
    }

    public Object transform(Object value) throws TransformationException {
        if (value == null || this.targetClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), this.getTargetType());
        if (transform == null || transform instanceof ObjectToAnyTransform) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TransformationException(CommonPlugin.Util.getString("ObjectToAnyTransform.Invalid_value", params));
        }
        try {
            return transform.transform(value);
        }
        catch (TransformationException e) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TransformationException(e, CommonPlugin.Util.getString("ObjectToAnyTransform.Invalid_value", params));
        }
    }

    public boolean isNarrowing() {
        return true;
    }
}

