/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.LogMessage;
import com.metamatrix.common.log.MessageLevel;
import com.metamatrix.common.log.format.DelimitedLogMessageFormat;
import com.metamatrix.common.log.format.LogMessageFormat;
import com.metamatrix.core.util.StringUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends OutputStream {
    protected static int INITIAL_BUFFER_SIZE = 32;
    protected byte[] buf;
    protected int count;
    private FileWriter fileWriter;
    private LogMessageFormat formatter = new DelimitedLogMessageFormat();
    private int msgLevel;
    private String msgContext;

    public LoggingOutputStream(int msgLevel, String msgContext, int initialBufferSize, FileWriter additionalOutput) {
        if (msgContext == null || msgContext.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.014.0013"));
        }
        if (!MessageLevel.isMessageLevelValid(msgLevel)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.014.0014", new Object[]{String.valueOf(msgLevel), String.valueOf(MessageLevel.getValidLowerMessageLevel()), String.valueOf(MessageLevel.getValidUpperMessageLevel())}));
        }
        if (initialBufferSize < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.014.0015", new Object[]{String.valueOf(initialBufferSize)}));
        }
        this.msgLevel = msgLevel;
        this.msgContext = msgContext;
        this.buf = new byte[initialBufferSize];
        this.fileWriter = additionalOutput;
    }

    public LoggingOutputStream(int msgLevel, String msgContext, FileWriter additionalOutput) {
        this(msgLevel, msgContext, INITIAL_BUFFER_SIZE, additionalOutput);
    }

    public void write(int b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void flush() throws IOException {
        String message = this.toString();
        if (message != null && !"\n".equals(message) && !"\r\n".equals(message)) {
            int i;
            StringBuffer sb = new StringBuffer(message);
            int startIndex = 0;
            int stopIndex = sb.length();
            int endingCount = 0;
            while (sb.charAt(stopIndex - 1) == '\n') {
                sb.deleteCharAt(--stopIndex);
                ++endingCount;
            }
            while (sb.charAt(startIndex) == '\n') {
                sb.deleteCharAt(startIndex);
                ++startIndex;
                LogManager.log(this.msgLevel, this.msgContext, "");
            }
            String messageText = sb.toString();
            LogManager.log(this.msgLevel, this.msgContext, messageText);
            for (i = 0; i != endingCount; ++i) {
                LogManager.log(this.msgLevel, this.msgContext, "");
            }
            if (this.fileWriter != null) {
                for (i = 0; i != startIndex; ++i) {
                    this.fileWriter.write(this.formatter.formatMessage(new LogMessage(this.msgContext, this.msgLevel, new Object[]{""})));
                    this.fileWriter.write(StringUtil.getLineSeparator());
                }
                this.fileWriter.write(this.formatter.formatMessage(new LogMessage(this.msgContext, this.msgLevel, new Object[]{messageText})));
                for (i = 0; i != endingCount; ++i) {
                    this.fileWriter.write(StringUtil.getLineSeparator());
                    this.fileWriter.write(this.formatter.formatMessage(new LogMessage(this.msgContext, this.msgLevel, new Object[]{""})));
                }
                this.fileWriter.write(StringUtil.getLineSeparator());
                this.fileWriter.flush();
            }
        }
        this.count = 0;
    }

    public String toString() {
        if (this.count != 0) {
            return new String(this.buf, 0, this.count);
        }
        return null;
    }

    public void close() throws IOException {
        this.flush();
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.fileWriter = null;
        }
    }
}

