/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.service;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.service.AbstractMessageClientInterceptor;
import java.util.Properties;

public class MessageClientInterceptor
extends AbstractMessageClientInterceptor {
    private Properties connectionProperties;
    private ServerConnectionFactory serverConnectionFactory;
    private String connectionType;
    private String serviceType;
    private ServerConnection serverConnection;
    private String clientApplicationName;
    private int activeUseCount = 0;

    public MessageClientInterceptor(Properties connectionProperties, ServerConnectionFactory serverConnectionFactory, String connectionType, String serviceType, String subSelector, String clientApplicationName) {
        super(subSelector);
        this.connectionProperties = connectionProperties;
        this.serverConnectionFactory = serverConnectionFactory;
        this.connectionType = connectionType;
        this.serviceType = serviceType;
        this.clientApplicationName = clientApplicationName;
        this.connectionProperties.put("serviceType", this.serviceType);
        this.connectionProperties.put("ApplicationName", this.clientApplicationName);
    }

    private void openConnection() throws ConnectionException, CommunicationException {
        if (this.serverConnection == null) {
            this.serverConnection = this.serverConnectionFactory.establishConnection(this.connectionType, this.connectionProperties);
        }
    }

    public void closeConnection() throws CommunicationException {
        if (this.activeUseCount == 0 && this.serverConnection != null) {
            this.serverConnection.shutdown();
            this.serverConnection = null;
        }
    }

    private void addUse() {
        ++this.activeUseCount;
    }

    private void removeUse() {
        --this.activeUseCount;
    }

    protected void endingInvocation() {
        this.removeUse();
    }

    protected void startingInvocation() {
        this.addUse();
    }

    protected ServerConnection getServerConnection() throws ConnectionException, CommunicationException {
        this.openConnection();
        return this.serverConnection;
    }

    public void setServerConnection(ServerConnection serverConnection) {
        this.serverConnection = serverConnection;
    }
}

