/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.api.HostInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MMURL
implements Enumeration {
    public static final String DOT_DELIMITER = ".";
    public static final String DOUBLE_SLASH_DELIMITER = "//";
    public static final String COMMA_DELIMITER = ",";
    public static final String COLON_DELIMITER = ":";
    public static final String BACKSLASH_DELIMITER = "\\";
    public static final String DEFAULT_PROTOCOL = "mm://";
    public static final String SECURE_PROTOCOL = "mms://";
    public static final String FORMAT_SERVER = CommonPlugin.Util.getString("MMURL.FORMAT_SERVER");
    public static final String INVALID_FORMAT_SERVER = CommonPlugin.Util.getString("MMURL.INVALID_FORMAT", new Object[]{FORMAT_SERVER});
    private String appServerURL;
    private List hosts = new ArrayList();
    private int index = 0;
    private boolean usingSSL = false;

    public MMURL(String serverURL) {
        this.appServerURL = serverURL;
        if (!this.hasValidURLProtocol(serverURL)) {
            throw new IllegalArgumentException(INVALID_FORMAT_SERVER);
        }
        this.usingSSL = this.isSecureProtocol(this.appServerURL);
        this.parseURL(serverURL, INVALID_FORMAT_SERVER);
    }

    public MMURL(String host, int port, boolean secure) {
        this.usingSSL = secure;
        this.hosts.add(new HostInfo(host, port));
    }

    public static boolean isValidServerURL(String serverURL) {
        boolean valid = true;
        try {
            new MMURL(serverURL);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    private boolean isSecureProtocol(String url) {
        return url.toLowerCase().startsWith(SECURE_PROTOCOL);
    }

    private boolean hasValidURLProtocol(String url) {
        return url != null && url.startsWith(DEFAULT_PROTOCOL) || url.startsWith(SECURE_PROTOCOL);
    }

    public List getHostInfo() {
        return this.hosts;
    }

    public String getHosts() {
        StringBuffer hostList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = (HostInfo)iterator.next();
                hostList.append(element.getHostName());
                if (!iterator.hasNext()) continue;
                hostList.append(COMMA_DELIMITER);
            }
        }
        return hostList.toString();
    }

    public String getPorts() {
        StringBuffer portList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = (HostInfo)iterator.next();
                portList.append(element.getPortNumber());
                if (!iterator.hasNext()) continue;
                portList.append(COMMA_DELIMITER);
            }
        }
        return portList.toString();
    }

    private void parseURL(String url, String exceptionMessage) {
        String serverURL;
        int urlProtocolIndex = url.indexOf(DOUBLE_SLASH_DELIMITER);
        if (urlProtocolIndex > 0) {
            serverURL = url.substring(urlProtocolIndex + 2);
            if (serverURL == null || serverURL.equals("")) {
                throw new IllegalArgumentException(exceptionMessage);
            }
        } else {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.parseServerURL(serverURL, exceptionMessage);
    }

    private void parseServerURL(String serverURL, String exceptionMessage) {
        StringTokenizer st = new StringTokenizer(serverURL, COMMA_DELIMITER);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), COLON_DELIMITER);
            try {
                String host = st2.nextToken().trim();
                String port = st2.nextToken().trim();
                HostInfo hostInfo = new HostInfo(host, port);
                hostInfo.setSSL(this.usingSSL);
                this.hosts.add(hostInfo);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException(exceptionMessage);
            }
            catch (NullPointerException ne) {
                throw new IllegalArgumentException(exceptionMessage);
            }
        }
    }

    public String getAppServerURL() {
        if (this.appServerURL == null) {
            StringBuffer sb = new StringBuffer();
            if (this.usingSSL) {
                sb.append(SECURE_PROTOCOL);
            } else {
                sb.append(DEFAULT_PROTOCOL);
            }
            Iterator iter = this.hosts.iterator();
            while (iter.hasNext()) {
                HostInfo host = (HostInfo)iter.next();
                sb.append(host.getHostName());
                sb.append(COLON_DELIMITER);
                sb.append(host.getPortNumber());
                if (!iter.hasNext()) continue;
                sb.append(COMMA_DELIMITER);
            }
            this.appServerURL = sb.toString();
        }
        return this.appServerURL;
    }

    public boolean hasMoreElements() {
        return this.hosts != null && this.hosts.size() > 0;
    }

    public Object nextElement() {
        if (this.hosts != null && this.hosts.size() > this.index) {
            return this.hosts.get(this.index++);
        }
        return null;
    }

    public String toString() {
        return this.getAppServerURL();
    }

    public boolean equals(Object obj) {
        boolean same;
        if (obj == null) {
            same = false;
        } else if (obj == this) {
            same = true;
        } else if (!(obj instanceof MMURL)) {
            same = false;
        } else {
            MMURL url = (MMURL)obj;
            same = this.appServerURL.equals(url.getAppServerURL());
        }
        return same;
    }

    public int hashCode() {
        return this.appServerURL.hashCode();
    }
}

