/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XSDValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXMLValidator
implements IXMLValidator {
    protected String uri;
    protected URIResolver uriResolver = null;
    protected List errors = new ArrayList();
    protected List ignoredNamespaceList = new ArrayList();
    protected InputStream inputStream = null;
    protected String currentErrorKey = null;
    protected Object[] currentMessageArguments = null;
    protected boolean isChildOfDoc = false;
    protected XMLGrammarPool grammarPool = null;
    protected Stack startElementLocations = new Stack();
    protected Set adjustLocationErrorKeySet = new TreeSet();

    public DefaultXMLValidator() {
        this.ignoredNamespaceList.add("http://www.w3.org/1999/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2000/10/XMLSchema");
        this.ignoredNamespaceList.add("http://www.w3.org/2001/XMLSchema");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.4.b");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.3");
    }

    public void setFile(String uri) {
        this.uri = uri;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setGrammarPool(XMLGrammarPool grammarPool) {
        this.grammarPool = grammarPool;
    }

    public void run() {
        try {
            StringReader reader1 = null;
            InputSource validateInputSource = new InputSource(this.uri);
            if (this.inputStream != null) {
                String string = this.createStringForInputStream(this.inputStream);
                reader1 = new StringReader(string);
                validateInputSource.setByteStream(this.inputStream);
                validateInputSource.setCharacterStream(reader1);
            }
            XMLReader reader = this.createXMLReader();
            reader.parse(validateInputSource);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            LoggerFactory.getInstance().getLogger().log("An exception occurred while performing WSDL XML conformance validation for file " + this.uri + ".", 0, e);
        }
    }

    final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception e) {
            LoggerFactory.getInstance().getLogger().log("The WSDL valdiator was unable to create to create a string representation of an input stream. WSDL XML validation may not have run correctly.", 0, e);
        }
        return fileString.toString();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List getErrors() {
        return this.errors;
    }

    public void addError(String message, int line, int column, String uri) {
        if (this.currentErrorKey != null && this.adjustLocationErrorKeySet.contains(this.currentErrorKey)) {
            LocationCoordinate adjustedCoordinates = (LocationCoordinate)this.startElementLocations.peek();
            line = adjustedCoordinates.getLineNumber();
            column = adjustedCoordinates.getColumnNumner();
        }
        this.errors.add(new ValidationMessageImpl(message, line, column, 1, uri, this.currentErrorKey, this.currentMessageArguments));
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected XMLReader createXMLReader() throws Exception {
        SAXParser reader = null;
        try {
            reader = new SAXParser((XMLParserConfiguration)new XMLValidatorParserConfiguration());
            XMLConformanceDefaultHandler conformanceDefaultHandler = new XMLConformanceDefaultHandler();
            reader.setErrorHandler((ErrorHandler)conformanceDefaultHandler);
            reader.setContentHandler((ContentHandler)conformanceDefaultHandler);
            if (this.grammarPool != null) {
                reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)this.grammarPool);
            }
            reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", (Object)new MyEntityResolver(this.uriResolver));
            reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (Exception e) {
            LoggerFactory.getInstance().getLogger().log("Error creating XML reader for WSDL XML conformance validation.", 0, e);
        }
        return reader;
    }

    protected class LocationCoordinate {
        private int lineNo = -1;
        private int columnNo = -1;

        public LocationCoordinate(int lineNumber, int columnNumber) {
            this.lineNo = lineNumber;
            this.columnNo = columnNumber;
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        public int getColumnNumner() {
            return this.columnNo;
        }
    }

    protected class MyEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriResolver;

        public MyEntityResolver(URIResolver uriResolver) {
            this.uriResolver = uriResolver;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            IURIResolutionResult result;
            String uri;
            String publicId;
            if (DefaultXMLValidator.this.isChildOfDoc) {
                return new XMLInputSource(rid);
            }
            boolean nsUsed = false;
            String ns = rid.getNamespace();
            if (ns != null && DefaultXMLValidator.this.ignoredNamespaceList.contains(ns)) {
                return new XMLInputSource(rid);
            }
            String systemId = rid.getLiteralSystemId();
            if (systemId == null) {
                systemId = ns;
                nsUsed = true;
            }
            if ((publicId = rid.getPublicId()) == null) {
                publicId = systemId;
            }
            if (!(publicId == null && systemId == null || (uri = (result = this.uriResolver.resolve("", publicId, systemId)).getPhysicalLocation()) == null || uri.equals(""))) {
                boolean createEntityResult = true;
                if (nsUsed) {
                    XSDValidator xsdVal = new XSDValidator();
                    xsdVal.validate(uri, this.uriResolver, null);
                    if (!xsdVal.isValid()) {
                        createEntityResult = false;
                    }
                }
                if (createEntityResult) {
                    try {
                        URL entityURL = new URL(uri);
                        XMLInputSource is = new XMLInputSource(rid.getPublicId(), systemId, result.getLogicalLocation());
                        is.setByteStream(entityURL.openStream());
                        if (is != null) {
                            return is;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
    }

    protected class XMLConformanceDefaultHandler
    extends DefaultHandler {
        private Locator locator = null;

        protected XMLConformanceDefaultHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        public void error(SAXParseException arg0) throws SAXException {
            String tempURI = arg0.getSystemId();
            if (DefaultXMLValidator.this.inputStream != null && arg0.getSystemId() == null) {
                tempURI = DefaultXMLValidator.this.uri;
            }
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), tempURI);
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void warning(SAXParseException arg0) throws SAXException {
            DefaultXMLValidator.this.addError(arg0.getMessage(), arg0.getLineNumber(), arg0.getColumnNumber(), arg0.getSystemId());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = false;
            }
            super.endElement(uri, localName, qName);
            DefaultXMLValidator.this.startElementLocations.pop();
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            DefaultXMLValidator.this.startElementLocations.push(new LocationCoordinate(this.locator.getLineNumber(), this.locator.getColumnNumber()));
            if (localName.equals("documentation") && (uri.equals("http://schemas.xmlsoap.org/wsdl/") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema"))) {
                DefaultXMLValidator.this.isChildOfDoc = true;
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    protected class XMLValidatorParserConfiguration
    extends StandardParserConfiguration {
        protected XMLValidatorParserConfiguration() {
        }

        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(this){
                final /* synthetic */ XMLValidatorParserConfiguration this$1;
                {
                    this.this$1 = xMLValidatorParserConfiguration;
                }

                public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).currentErrorKey = key;
                    XMLValidatorParserConfiguration.access$0((XMLValidatorParserConfiguration)this.this$1).currentMessageArguments = arguments;
                    super.reportError(domain, key, arguments, severity);
                }
            };
        }

        static /* synthetic */ DefaultXMLValidator access$0(XMLValidatorParserConfiguration xMLValidatorParserConfiguration) {
            return xMLValidatorParserConfiguration.DefaultXMLValidator.this;
        }
    }
}

