/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.xa;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.ConnectionStrategy;
import com.metamatrix.connector.jdbc.JDBCSourceConnection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.xa.api.XAConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.transaction.xa.XAResource;

public class JDBCSourceXAConnection
extends JDBCSourceConnection
implements XAConnection {
    private javax.sql.XAConnection xaConn;
    private boolean useExclusiveMode;
    private boolean isInTxn;
    private Map idToConnections;
    private Object txnID;

    public JDBCSourceXAConnection(Connection conn, ConnectorEnvironment environment, boolean useExclusiveMode, ConnectionStrategy connectionStrategy) throws ConnectorException, SQLException {
        this(conn, environment, useExclusiveMode, connectionStrategy, null);
    }

    public JDBCSourceXAConnection(Connection conn, ConnectorEnvironment environment, boolean useExclusiveMode, ConnectionStrategy connectionStrategy, ConnectionListener connectionListener) throws ConnectorException, SQLException {
        super(conn, environment, connectionStrategy, connectionListener);
        this.useExclusiveMode = useExclusiveMode;
    }

    public XAResource getXAResource() throws ConnectorException {
        try {
            return this.xaConn.getXAResource();
        }
        catch (SQLException err) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)err));
        }
    }

    public void release() {
        if (!this.useExclusiveMode || !this.isInTxn) {
            this.forceRelease();
        }
    }

    void setXAConnection(javax.sql.XAConnection xaConn) {
        this.xaConn = xaConn;
    }

    javax.sql.XAConnection getXAConnection() {
        return this.xaConn;
    }

    void forceRelease() {
        this.setInTxn(false);
        if (this.idToConnections != null) {
            this.idToConnections.remove(this.txnID);
        }
        try {
            super.closeSource();
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        this.physicalConnection = null;
        super.release();
    }

    boolean isInTxn() {
        return this.isInTxn;
    }

    void setInTxn(boolean inTxn) {
        this.isInTxn = inTxn;
    }

    void setTransactionMap(Map idToConnections, Object txnID) {
        this.idToConnections = idToConnections;
        this.txnID = txnID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSource() throws ConnectorException {
        try {
            try {
                super.closeSource();
            }
            catch (ConnectorException connectorException) {
                Object var3_2 = null;
                try {
                    this.xaConn.close();
                    return;
                }
                catch (SQLException err) {
                    throw new ConnectorException((Throwable)err);
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {}
            catch (SQLException err) {
                throw new ConnectorException((Throwable)err);
            }
            this.xaConn.close();
            throw throwable;
        }
        try {}
        catch (SQLException err) {
            throw new ConnectorException((Throwable)err);
        }
        this.xaConn.close();
    }

    protected Connection getPhysicalConnection() throws ConnectorException {
        if (this.physicalConnection != null) {
            return this.physicalConnection;
        }
        try {
            this.physicalConnection = this.xaConn.getConnection();
        }
        catch (SQLException err) {
            throw new ConnectorException((Throwable)err);
        }
        return this.physicalConnection;
    }
}

