/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1011
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1011(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Element soapMessageElement;
            if (entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            Binding[] bindings = this.validator.analyzerContext.getCandidateInfo().getBindings();
            Document messageDoc = null;
            QName messagePartElementQName = null;
            if (!entryContext.getMessageEntry().getMessage().equals("") && (soapMessageElement = this.validator.getSoapBodyChild(messageDoc = entryContext.getMessageEntryDocument())) != null) {
                messagePartElementQName = new QName(soapMessageElement.getNamespaceURI(), soapMessageElement.getLocalName());
            }
            if (messageDoc == null || this.validator.isFault(messageDoc)) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation[] docBindingOperations = this.validator.getMatchingBindingOps("document", bindings);
            BindingOperation[] potentialDocLitOps = this.validator.getDocLitOperations(entryContext.getEntry().getEntryType(), messagePartElementQName, docBindingOperations);
            if (potentialDocLitOps.length != 0) {
                try {
                    this.validator.messageIsDocLitSchemaValid(entryContext);
                }
                catch (Exception e) {
                    throw new AssertionFailException(e.getMessage());
                }
                throw new AssertionPassException();
            }
            BindingOperation[] rpcBindingOperations = this.validator.getMatchingBindingOps("rpc", bindings);
            BindingOperation rcpOpMatch = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), messageDoc, rpcBindingOperations);
            if (rcpOpMatch != null) {
                rcpOpMatch = this.validator.getOperationPartsMatch(entryContext.getEntry().getEntryType(), messageDoc, rpcBindingOperations);
            }
            if (rcpOpMatch == null) {
                StringBuffer rpcOperationList = new StringBuffer();
                int i = 0;
                while (i < rpcBindingOperations.length) {
                    rpcOperationList.append(String.valueOf(rpcBindingOperations[i].toString()) + "\n");
                    ++i;
                }
                StringBuffer docOperationList = new StringBuffer();
                int i2 = 0;
                while (i2 < docBindingOperations.length) {
                    docOperationList.append(String.valueOf(docBindingOperations[i2].toString()) + "\n");
                    ++i2;
                }
                throw new AssertionFailException("--MESSAGE:\n" + entryContext.getMessageEntry().getMessage() + "\n--CANDIDATE RPC STYLE OPERATIONS (" + (rpcBindingOperations.length != 0 ? String.valueOf(rpcBindingOperations.length) + "):\n" + rpcOperationList : "NONE)") + "\n--CANDIDATE DOCUMENT STYLE OPERATIONS (" + (docBindingOperations.length != 0 ? String.valueOf(docBindingOperations.length) + "):\n" + docOperationList : "NONE)"));
            }
        }
        catch (AssertionPassException assertionPassException) {
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

