/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.xa;

import com.metamatrix.connector.jdbc.JDBCConnector;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.xa.JDBCSingleIdentityDSConnectionFactory;
import com.metamatrix.connector.jdbc.xa.JDBCSourceXAConnection;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.DisabledConnectionPool;
import com.metamatrix.data.pool.SourceConnectionFactory;
import com.metamatrix.data.xa.api.TransactionContext;
import com.metamatrix.data.xa.api.XAConnector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JDBCXAConnector
extends JDBCConnector
implements XAConnector {
    private ConnectionPool xaPool;
    private Object recoverableResource;
    private Map idToConnections;
    private boolean useExclusiveMode;

    public void stop() {
        if (this.xaPool != null) {
            this.xaPool.shutDown();
            this.xaPool = null;
        }
        super.stop();
    }

    public void start() throws ConnectorException {
        if (this.xaPool == null) {
            Properties appEnvProps = this.environment.getProperties();
            String scfClassName = appEnvProps.getProperty("ExtensionConnectionFactoryClass", "com.metamatrix.connector.jdbc.JDBCSingleIdentityConnectionFactory");
            String url = appEnvProps.getProperty("URL");
            if (url == null || url.trim().length() == 0) {
                throw new ConnectorException("Missing required property: URL");
            }
            JDBCXAConnector.parseURL(url, appEnvProps);
            String useExclusiveModeStr = appEnvProps.getProperty("UseConnectionExclusive".toLowerCase(), "true");
            this.useExclusiveMode = Boolean.valueOf(useExclusiveModeStr);
            if (this.useExclusiveMode) {
                this.idToConnections = Collections.synchronizedMap(new HashMap());
                JDBCPlugin.Util.log(1, JDBCPlugin.Util.getString("JDBCXAConnector.Connector_use_exclusive_mode_1"));
            }
            try {
                Class<?> scfClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(scfClassName);
                SourceConnectionFactory factory = (SourceConnectionFactory)scfClass.newInstance();
                appEnvProps.setProperty("isXA", "true");
                factory.initialize(this.environment);
                appEnvProps.setProperty("isXA", "false");
                this.recoverableResource = ((JDBCSingleIdentityDSConnectionFactory)factory).getRecoverableResource();
                this.xaPool = this.connectionPoolEnabled ? new ConnectionPool(factory) : new DisabledConnectionPool(factory);
                this.xaPool.initialize(appEnvProps);
            }
            catch (ClassNotFoundException e1) {
                throw new ConnectorException((Throwable)e1);
            }
            catch (InstantiationException e2) {
                throw new ConnectorException((Throwable)e2);
            }
            catch (IllegalAccessException e3) {
                throw new ConnectorException((Throwable)e3);
            }
            catch (ConnectionPoolException e4) {
                throw new ConnectorException((Throwable)e4);
            }
        }
        Connection conn = this.getXAConnection(null, null);
        conn.release();
        super.start();
    }

    public Connection getXAConnection(SecurityContext context, TransactionContext transactionContext) throws ConnectorException {
        Connection existConn;
        JDBCSourceXAConnection conn = null;
        if (transactionContext != null && this.useExclusiveMode && (existConn = (Connection)this.idToConnections.get(transactionContext.getTransactionId())) != null) {
            return existConn;
        }
        conn = (JDBCSourceXAConnection)this.xaPool.obtain(context);
        conn.setConnectionPool(this.xaPool);
        if (transactionContext != null && this.useExclusiveMode) {
            conn.setTransactionMap(this.idToConnections, transactionContext.getTransactionId());
            this.idToConnections.put(transactionContext.getTransactionId(), conn);
        }
        return conn;
    }

    public Object getRecoverableResource() throws ConnectorException {
        return this.recoverableResource;
    }

    static void parseURL(String url, Properties connectionProps) {
        List urlParts = StringUtil.split((String)url, (String)";");
        List protoHost = StringUtil.split((String)((String)urlParts.get(0)), (String)"//");
        List hostPort = StringUtil.split((String)((String)protoHost.get(1)), (String)":");
        connectionProps.setProperty("serverName", (String)hostPort.get(0));
        connectionProps.setProperty("portNumber", (String)hostPort.get(1));
        for (int i = 1; i < urlParts.size(); ++i) {
            String nameVal = (String)urlParts.get(i);
            List aProp = StringUtil.split((String)nameVal, (String)"=");
            if (aProp.size() <= 1) continue;
            String propName = (String)aProp.get(0);
            if (propName.equalsIgnoreCase("databaseName")) {
                connectionProps.setProperty("databaseName", (String)aProp.get(1));
                continue;
            }
            connectionProps.setProperty(propName.toLowerCase(), (String)aProp.get(1));
        }
    }
}

