/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.internal.ui.sqleditor.component;

import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeFactory;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeUtils;
import com.metamatrix.query.internal.ui.sqleditor.component.OptionDisplayNode;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InsertDisplayNode
extends DisplayNode {
    public InsertDisplayNode(DisplayNode parentNode, Insert insert) {
        this.parentNode = parentNode;
        this.languageObject = insert;
        this.createChildNodes();
    }

    public boolean supportsGroup() {
        return true;
    }

    public boolean supportsElement() {
        return true;
    }

    public boolean supportsCriteria() {
        return true;
    }

    public DisplayNode getClauseDisplayNode(int clauseType) {
        if (clauseType < 6 || clauseType > 13) {
            return null;
        }
        Iterator iter = this.childNodeList.iterator();
        while (iter.hasNext()) {
            DisplayNode node = (DisplayNode)iter.next();
            switch (clauseType) {
                case 13: {
                    if (!(node instanceof OptionDisplayNode)) break;
                    return node;
                }
            }
        }
        return null;
    }

    public DisplayNode getClauseAtIndex(int index) {
        List nodes = DisplayNodeUtils.getDisplayNodesAtIndex((List)this.displayNodeList, (int)index);
        int nNodes = nodes.size();
        if (nNodes == 0) {
            return null;
        }
        if (nNodes == 1) {
            return DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(0)));
        }
        if (nNodes == 2) {
            DisplayNode clause1 = DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(0)));
            DisplayNode clause2 = DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(1)));
            if (clause2 != null) {
                return clause2;
            }
            return clause1;
        }
        return null;
    }

    private void createChildNodes() {
        this.childNodeList = new ArrayList();
        Insert insert = (Insert)this.getLanguageObject();
        if (insert.getQuery() != null) {
            this.createChildNodesForInsertIntoSubquery();
            return;
        }
        GroupSymbol group = insert.getGroup();
        if (group != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)group));
        }
        Iterator varIter = insert.getVariables().iterator();
        while (varIter.hasNext()) {
            Expression element = (Expression)varIter.next();
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)element));
        }
        Iterator valIter = insert.getValues().iterator();
        while (valIter.hasNext()) {
            Expression value = (Expression)valIter.next();
            if (value == null) {
                this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"ERROR"));
                continue;
            }
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)value));
        }
        Option option = insert.getOption();
        if (option != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)option));
        }
        this.createDisplayNodeList();
    }

    private void createDisplayNodeList() {
        int i;
        this.displayNodeList = new ArrayList();
        int childIndex = 0;
        int indent = this.getIndentLevel();
        ++indent;
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"INSERT"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"INTO"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        Insert insert = (Insert)this.getLanguageObject();
        List childNodes = this.getChildren();
        int totalChildNodes = childNodes.size();
        GroupSymbol group = insert.getGroup();
        if (group != null) {
            DisplayNode groupChild = (DisplayNode)childNodes.get(childIndex);
            ++childIndex;
            if (groupChild.hasDisplayNodes()) {
                this.displayNodeList.addAll(groupChild.getDisplayNodeList());
            } else {
                this.displayNodeList.add(groupChild);
            }
            this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        }
        if (DisplayNodeUtils.isClauseCROn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
            this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"\n"));
        }
        if (!insert.getVariables().isEmpty()) {
            if (DisplayNodeUtils.isClauseIndentOn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
                this.displayNodeList.addAll(DisplayNodeUtils.getIndentNodes((DisplayNode)this, (int)indent));
            }
            int varNum = insert.getVariables().size();
            for (i = 0; i < varNum; ++i) {
                DisplayNode varChild = (DisplayNode)childNodes.get(i + childIndex);
                if (i == 0) {
                    this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"("));
                }
                if (varChild.hasDisplayNodes()) {
                    this.displayNodeList.addAll(varChild.getDisplayNodeList());
                } else {
                    this.displayNodeList.add(varChild);
                }
                if (i == varNum - 1) continue;
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)", "));
            }
            if (varNum > 0) {
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)")"));
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
                childIndex += varNum;
            }
        }
        if (DisplayNodeUtils.isClauseCROn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
            this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"\n"));
        }
        if (insert.getValues() != null) {
            this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"VALUES"));
            this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
            if (DisplayNodeUtils.isClauseCROn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"\n"));
                if (DisplayNodeUtils.isClauseIndentOn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
                    this.displayNodeList.addAll(DisplayNodeUtils.getIndentNodes((DisplayNode)this, (int)indent));
                }
            }
            int valNum = insert.getValues().size();
            for (i = 0; i < valNum; ++i) {
                DisplayNode valChild = (DisplayNode)childNodes.get(i + childIndex);
                if (i == 0) {
                    this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"("));
                }
                if (valChild.hasDisplayNodes()) {
                    this.displayNodeList.addAll(valChild.getDisplayNodeList());
                } else {
                    this.displayNodeList.add(valChild);
                }
                if (i == valNum - 1) continue;
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)", "));
            }
            if (valNum > 0) {
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)")"));
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
                childIndex += valNum;
            }
        }
        if (childIndex < totalChildNodes) {
            DisplayNode childNode = (DisplayNode)childNodes.get(childIndex);
            if (childNode.hasDisplayNodes()) {
                this.displayNodeList.addAll(childNode.getDisplayNodeList());
            } else {
                this.displayNodeList.add(childNode);
            }
        }
    }

    private void createChildNodesForInsertIntoSubquery() {
        this.childNodeList = new ArrayList();
        Insert insert = (Insert)this.getLanguageObject();
        GroupSymbol group = insert.getGroup();
        if (group != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)group));
        }
        Command command = insert.getQuery();
        this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)command));
        Option option = insert.getOption();
        if (option != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)option));
        }
        this.createDisplayNodeListForInsertIntoSubquery();
    }

    private void createDisplayNodeListForInsertIntoSubquery() {
        this.displayNodeList = new ArrayList();
        int indent = this.getIndentLevel();
        ++indent;
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"INSERT"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"INTO"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        Insert insert = (Insert)this.getLanguageObject();
        GroupSymbol group = insert.getGroup();
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)group));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        Command query = insert.getQuery();
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"\n"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)query));
    }
}

