/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.optimizer.xml.ReferenceBindingReplacerVisitor;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueryUtil {
    static Command getQuery(QueryNode queryNode) throws QueryPlannerException {
        Command query = queryNode.getCommand();
        if (query == null) {
            try {
                query = QueryParser.getQueryParser().parseCommand(queryNode.getQuery());
            }
            catch (QueryParserException e) {
                throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0054", new Object[]{queryNode.getGroupName(), queryNode.getQuery()}));
            }
        }
        return query;
    }

    static Command parseQuery(String queryStr) throws QueryPlannerException {
        Command query = null;
        try {
            query = QueryParser.getQueryParser().parseCommand(queryStr);
        }
        catch (QueryParserException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0054", new Object[]{queryStr}));
        }
        return query;
    }

    static void resolveQuery(Command query, TempMetadataAdapter metadata) throws MetaMatrixComponentException, QueryPlannerException {
        try {
            QueryResolver.resolveCommand((Command)query, (Map)Collections.EMPTY_MAP, (boolean)true, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }

    static void rewriteQuery(Command query, QueryMetadataInterface metadata, CommandContext context) throws QueryPlannerException {
        try {
            QueryRewriter.rewrite(query, null, metadata, context);
        }
        catch (QueryValidatorException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }

    static QueryNode getQueryNode(String groupName, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryNode queryNode = null;
        try {
            GroupSymbol gs = new GroupSymbol(groupName);
            ResolveGroupsVisitor.resolveGroups((LanguageObject)gs, (QueryMetadataInterface)metadata);
            queryNode = metadata.getVirtualPlan(gs.getMetadataID());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, "ERR.015.004.0029", QueryExecPlugin.Util.getString("ERR.015.004.0029", (Object)groupName));
        }
        return queryNode;
    }

    static Query wrapQuery(FromClause fromClause, String groupName) {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllInGroupSymbol(groupName + ".*"));
        Query query = new Query();
        query.setSelect(select);
        From from = new From();
        from.addClause(fromClause);
        query.setFrom(from);
        return query;
    }

    public static GroupSymbol createResolvedGroup(String groupName, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        GroupSymbol group = new GroupSymbol(groupName);
        return QueryUtil.createResolvedGroup(group, metadata);
    }

    public static GroupSymbol createResolvedGroup(GroupSymbol group, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)group, (QueryMetadataInterface)metadata);
            return group;
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    static Command getQueryFromQueryNode(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        Command command = QueryUtil.getQuery(queryNode);
        return command;
    }

    static void handleBindings(LanguageObject object, QueryNode planNode, XMLPlannerEnvironment planEnv) throws QueryResolverException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List parsedBindings = QueryUtil.parseBindings(planNode, planEnv);
        if (!parsedBindings.isEmpty()) {
            ReferenceBindingReplacerVisitor.replaceReferences((LanguageObject)object, (List)parsedBindings);
        }
    }

    static List parseBindings(QueryNode planNode, XMLPlannerEnvironment planEnv) throws MetaMatrixComponentException {
        List bindingsCol = planNode.getBindings();
        if (bindingsCol == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ElementSymbol> parsedBindings = new ArrayList<ElementSymbol>(bindingsCol.size());
        Iterator bindings = bindingsCol.iterator();
        while (bindings.hasNext()) {
            try {
                ElementSymbol binding = (ElementSymbol)QueryParser.getQueryParser().parseExpression((String)bindings.next());
                parsedBindings.add(binding);
            }
            catch (QueryParserException err) {
                throw new MetaMatrixComponentException((Throwable)err);
            }
        }
        return parsedBindings;
    }

    static Map createSymbolMap(GroupSymbol oldGroup, String newGroup, Collection projectedElements) {
        HashMap<Object, Object> symbolMap = new HashMap<Object, Object>();
        symbolMap.put(oldGroup, new GroupSymbol(newGroup));
        Iterator i = projectedElements.iterator();
        while (i.hasNext()) {
            ElementSymbol element = (ElementSymbol)i.next();
            symbolMap.put(element, new ElementSymbol(newGroup + "." + element.getShortName()));
        }
        return symbolMap;
    }

    static List getReferences(Command query, boolean embeddedOnly) {
        ArrayList<Reference> boundList = new ArrayList<Reference>();
        LinkedList<Object> commands = null;
        commands = embeddedOnly ? new LinkedList<Command>() : new LinkedList(CommandCollectorVisitor.getNonEmbeddedCommands((LanguageObject)query));
        commands.add(query);
        Iterator cmds = commands.iterator();
        while (cmds.hasNext()) {
            Command command = (Command)cmds.next();
            Iterator refs = ReferenceCollectorVisitor.getReferences((LanguageObject)command).iterator();
            while (refs.hasNext()) {
                Reference ref = (Reference)refs.next();
                Expression expr = ref.getExpression();
                if (!(expr instanceof ElementSymbol)) continue;
                ElementSymbol elem = (ElementSymbol)expr;
                if (!query.getExternalGroupContexts().getGroups().contains(elem.getGroupSymbol())) continue;
                boundList.add(ref);
            }
        }
        return boundList;
    }
}

