/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.api.AsynchQueryExecution;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.BatchedExecution;
import com.metamatrix.data.api.BatchedUpdatesExecution;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.xa.api.XAConnection;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorRequestStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.PollingRequestTask;
import com.metamatrix.dqp.internal.datamgr.impl.TransactionState;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class ConnectorWorker
extends QueueWorker {
    private ConnectorRequestStateManager stateMgr;
    private MetadataService metadataService;
    private TrackingService tracker;
    private int maxResultRows;
    private boolean exceptionOnMaxRows = true;
    private TransactionService transactionService;
    private ClassLoader connectorClassLoader;
    private Lock transactionLock;
    private LockKey lockKey;
    private WorkerPool workerPool;
    private static Map transactionLocks = new HashMap();
    static /* synthetic */ Class class$com$metamatrix$dqp$message$AtomicRequestMessage;

    public ConnectorWorker(ConnectorRequestStateManager stateMgr, ApplicationEnvironment connectorMgrEnv, MetadataService metadataService, TrackingService tracker, TransactionService transactionService, ClassLoader connectorClassLoader, WorkerPool workerPool) {
        String exceptionOnMaxRowsString;
        this.stateMgr = stateMgr;
        this.metadataService = metadataService;
        this.tracker = tracker;
        this.transactionService = transactionService;
        this.connectorClassLoader = connectorClassLoader;
        this.workerPool = workerPool;
        String maxResultRowsString = connectorMgrEnv.getApplicationProperties().getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                this.maxResultRows = Integer.parseInt(maxResultRowsString);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{"MaxResultRows"};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_parse_property", params);
                LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)msg);
            }
        }
        if ((exceptionOnMaxRowsString = connectorMgrEnv.getApplicationProperties().getProperty("ExceptionOnMaxRows")) != null) {
            Boolean bool = Boolean.valueOf(exceptionOnMaxRowsString);
            this.exceptionOnMaxRows = bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Object request) throws QueueWorkerException {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$dqp$message$AtomicRequestMessage == null ? (class$com$metamatrix$dqp$message$AtomicRequestMessage = ConnectorWorker.class$("com.metamatrix.dqp.message.AtomicRequestMessage")) : class$com$metamatrix$dqp$message$AtomicRequestMessage), (Object)request, (String)DQPPlugin.Util.getString("ERR.018.003.0021"));
        AtomicRequestMessage atomicReq = (AtomicRequestMessage)request;
        ClassLoader contextloader = this.getContextClassLoader();
        try {
            this.setContextClassLoader(this.connectorClassLoader);
            switch (atomicReq.getType()) {
                case 1: 
                case 2: {
                    this.processBatchRequest(atomicReq);
                    return;
                }
                case 4: {
                    this.processCloseRequest(atomicReq);
                    return;
                }
                case 6: {
                    this.processCloseTransactionRequest(atomicReq);
                    return;
                }
                case 3: {
                    this.processCancelRequest(atomicReq);
                    return;
                }
                default: {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ConnectorWorker.invalidAtomicType", atomicReq.getType()));
                }
            }
        }
        catch (Throwable t) {
            LogManager.logError((String)"CONNECTOR", (Throwable)t, (String)t.getMessage());
            return;
        }
        finally {
            this.setContextClassLoader(contextloader);
        }
    }

    private void processBatchRequest(AtomicRequestMessage atomicReq) throws ConnectorException {
        try {
            if (this.stateMgr.startProcessing(atomicReq)) {
                if (atomicReq.getType() == 1) {
                    QueryMetadataInterface queryMetadata = this.metadataService.lookupMetadata(atomicReq.getVdbName(), atomicReq.getVdbVersion());
                    this.processNewRequest(atomicReq, queryMetadata);
                } else if (atomicReq.getType() == 2) {
                    this.processMoreRequest(atomicReq);
                }
            } else {
                this.reportInvalidRequest(atomicReq);
            }
        }
        catch (Throwable t) {
            this.handleError(atomicReq, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(AtomicRequestMessage atomicReq, Throwable t) throws ConnectorException {
        this.logSRCCommand(atomicReq, (short)4, -1);
        if (this.stateMgr.isCancelled(atomicReq)) {
            LogManager.logDetail((String)"CONNECTOR", (Throwable)t, (String)t.getMessage());
        } else {
            LogManager.logError((String)"CONNECTOR", (Throwable)t, (String)t.getMessage());
        }
        try {
            this.closeProcessing(atomicReq, true);
        }
        finally {
            this.sendError(atomicReq, t);
        }
    }

    private void reportInvalidRequest(AtomicRequestMessage atomicReq) {
        String msg = DQPPlugin.Util.getString("ConnectorWorker.requestID_does_not_exist", (Object)atomicReq.getRequestID());
        LogManager.logDetail((String)"CONNECTOR", (String)msg);
        this.sendError(atomicReq, (Throwable)new ConnectorException(msg));
    }

    private void processCloseTransactionRequest(AtomicRequestMessage atomicReq) throws ConnectorException {
        if (this.stateMgr.isActive(atomicReq)) {
            this.processCloseTransactionRequest(atomicReq, false);
        } else {
            this.reportInvalidRequest(atomicReq);
        }
    }

    private void processCloseTransactionRequest(AtomicRequestMessage atomicReq, boolean forceRollback) throws ConnectorException {
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Processing Close transaction Request:", atomicReq.getCommand()});
        if (atomicReq.isTransactional()) {
            try {
                if (this.stateMgr.getTransactionState(atomicReq) == TransactionState.TRANSACTION_SUSPENDED) {
                    this.resumeTransaction(atomicReq);
                }
                if (this.stateMgr.isCancelled(atomicReq) || forceRollback) {
                    this.rollbackTransaction(atomicReq);
                } else {
                    this.commitSubTransaction(atomicReq);
                    this.logSRCCommand(atomicReq, (short)2, this.stateMgr.getRowsProcessed(atomicReq));
                }
            }
            catch (XATransactionException e) {
                this.sendError(atomicReq, e);
            }
            catch (MetaMatrixComponentException e) {
                this.sendError(atomicReq, e);
            }
        }
    }

    private void processCloseRequest(AtomicRequestMessage atomicReq) throws ConnectorException {
        boolean canClose = this.stateMgr.closeProcessing(atomicReq);
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Processing Close Request:", atomicReq.getCommand()});
        if (canClose) {
            this.closeProcessing(atomicReq, false);
        }
    }

    private void processNewRequest(AtomicRequestMessage atomicReq, QueryMetadataInterface queryMetadata) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Processing NEW request:", atomicReq.getCommand()});
        Execution execution = this.stateMgr.createExecution(atomicReq, queryMetadata);
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Obtained execution"});
        ICommand translatedCommand = this.stateMgr.getTranslatedCommand(atomicReq);
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        this.logSRCCommand(atomicReq, (short)1, -1);
        this.startSubTransaction(atomicReq, executionMode);
        BasicBatch aBatch = null;
        switch (executionMode) {
            case 0: {
                ((SynchQueryExecution)execution).execute((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 1: 
            case 4: {
                int count = ((UpdateExecution)execution).execute(translatedCommand);
                aBatch = new BasicBatch();
                aBatch.addRow(Arrays.asList(new Integer(count)));
                aBatch.setLast();
                break;
            }
            case 3: {
                List updates = ((IBatchedUpdates)translatedCommand).getUpdateCommands();
                ICommand[] updatesArray = updates.toArray(new ICommand[updates.size()]);
                int[] count = ((BatchedUpdatesExecution)execution).execute(updatesArray);
                aBatch = new BasicBatch();
                for (int i = 0; i < count.length; ++i) {
                    aBatch.addRow(Arrays.asList(new Integer(count[i])));
                }
                aBatch.setLast();
                break;
            }
            case 2: {
                ((ProcedureExecution)execution).execute((IProcedure)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 5: {
                ((AsynchQueryExecution)execution).executeAsynch((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            default: {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.Unable_to_open_connector_execution");
                throw new MetaMatrixComponentException(msg);
            }
        }
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Executed command"});
        if (executionMode == 0 || executionMode == 2 || executionMode == 5) {
            aBatch = this.getNextBatch((BatchedExecution)execution, translatedCommand);
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Obtained first batch, row count:" + aBatch.getRowCount()});
            boolean exceededMax = this.checkMaxResultRows(aBatch.getRowCount());
            if (exceededMax) {
                aBatch = this.setBatchAtMaxRows((Batch)aBatch, this.maxResultRows);
            }
        }
        this.handleBatch(atomicReq, execution, (Batch)aBatch, aBatch.getRowCount());
    }

    private boolean checkMaxResultRows(int rowCount) throws ConnectorException {
        boolean exceededMax = false;
        if (this.maxResultRows != 0 && rowCount > this.maxResultRows) {
            if (this.exceptionOnMaxRows) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.MaxResultRowsExceed", this.maxResultRows);
                throw new ConnectorException(msg);
            }
            exceededMax = true;
        }
        return exceededMax;
    }

    private Batch setBatchAtMaxRows(Batch origBatch, int maxRowsAllowed) {
        List[] origResults = origBatch.getResults();
        List[] newResults = new List[maxRowsAllowed];
        System.arraycopy(origResults, 0, newResults, 0, maxRowsAllowed);
        List<List> newResultsList = Arrays.asList(newResults);
        BasicBatch newBatch = new BasicBatch(newResultsList);
        newBatch.setLast();
        return newBatch;
    }

    private void handleBatch(AtomicRequestMessage atomicReq, Execution execution, Batch aBatch, int rowCount) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        if (this.stateMgr.isCancelled(atomicReq) || this.stateMgr.isCloseRequested(atomicReq)) {
            this.stateMgr.endProcessing(atomicReq);
            this.closeProcessing(atomicReq, false);
        } else {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Sending results from connector"});
            boolean lastBatch = aBatch.isLast();
            if (lastBatch) {
                this.commitSubTransaction(atomicReq);
            } else {
                this.suspendSubTransaction(atomicReq);
            }
            if (lastBatch) {
                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Obtained last batch, total row count:" + rowCount});
            }
            this.stateMgr.addRowsProcessed(atomicReq, aBatch.getRowCount());
            this.stateMgr.endProcessing(atomicReq);
            if (aBatch.getRowCount() == 0 && !aBatch.isLast() && execution instanceof AsynchQueryExecution && atomicReq.getType() == 2) {
                this.schedulePollingTask((AsynchQueryExecution)execution, atomicReq);
            } else {
                try {
                    this.sendResults(atomicReq, aBatch, atomicReq.getCommand().getProjectedSymbols(), rowCount);
                }
                catch (Throwable t) {
                    this.handleError(atomicReq, t);
                }
            }
        }
    }

    private void schedulePollingTask(AsynchQueryExecution execution, AtomicRequestMessage request) {
        PollingRequestTask task = new PollingRequestTask(request, this.workerPool);
        long delay = execution.getPollInterval();
        this.stateMgr.scheduleTask((TimerTask)task, delay);
    }

    private void processMoreRequest(AtomicRequestMessage atomicReq) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Processing MORE request"});
        Execution execution = this.stateMgr.getExecution(atomicReq);
        if (execution == null) {
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.could_not_retrieve_execution", (Object)requestID));
        }
        this.resumeTransaction(atomicReq);
        this.verifyIsQuery(atomicReq, execution);
        Batch aBatch = ((BatchedExecution)execution).nextBatch();
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{requestID, "Obtained batch, row count:" + aBatch.getRowCount()});
        int rowsSoFar = this.stateMgr.getRowsProcessed(atomicReq);
        int rowCnt = rowsSoFar + aBatch.getRowCount();
        boolean exceededMax = this.checkMaxResultRows(rowCnt);
        if (exceededMax) {
            int maxAllowedForBatch = this.maxResultRows - rowsSoFar;
            aBatch = this.setBatchAtMaxRows(aBatch, maxAllowedForBatch);
            rowCnt = rowsSoFar + aBatch.getRowCount();
        }
        this.handleBatch(atomicReq, execution, aBatch, rowCnt);
    }

    private void startSubTransaction(AtomicRequestMessage request, int executionMode) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        if (request.isTransactional()) {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"startingSubTransaction(" + request.getTransactionContext() + ")"});
            Connection conn = this.stateMgr.getConnection(request, false);
            if (conn.getCapabilities().supportsXATransactions()) {
                this.stateMgr.changeTransactionState(request, TransactionState.TRANSACTION_INPROGRESS);
                XAResource xaRes = ((XAConnection)conn).getXAResource();
                this.acquireTransactionLock(request.getTransactionContext(), xaRes);
                this.getTransactionManager().importTransaction(request.getTransactionContext(), xaRes);
                this.getTransactionManager().enlistResource(xaRes);
            } else if (executionMode != 0) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.transactionNotSupported");
                throw new ConnectorException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendSubTransaction(AtomicRequestMessage request) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        if (request.isTransactional()) {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"susendSubTransaction(" + request.getTransactionContext() + ")"});
            Connection conn = this.stateMgr.getConnection(request, false);
            if (conn.getCapabilities().supportsXATransactions()) {
                try {
                    this.stateMgr.changeTransactionState(request, TransactionState.TRANSACTION_SUSPENDED);
                    TransactionContext txnCtx = this.stateMgr.getTransactionContext(request);
                    this.getTransactionManager().suspendTransaction(txnCtx);
                }
                finally {
                    this.releaseTransactionLock();
                }
            }
        }
    }

    private void resumeTransaction(AtomicRequestMessage request) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        if (request.isTransactional()) {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"resumeTransaction(" + request.getTransactionContext() + ")"});
            Connection conn = this.stateMgr.getConnection(request, false);
            if (conn.getCapabilities().supportsXATransactions()) {
                this.stateMgr.changeTransactionState(request, TransactionState.TRANSACTION_INPROGRESS);
                TransactionContext txnCtx = this.stateMgr.getTransactionContext(request);
                XAResource xaRes = ((XAConnection)conn).getXAResource();
                this.acquireTransactionLock(txnCtx, xaRes);
                this.getTransactionManager().resumeTransaction(txnCtx, xaRes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitSubTransaction(AtomicRequestMessage request) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        TransactionState state = this.stateMgr.getTransactionState(request);
        if (request.isTransactional() && state != TransactionState.TRANSACTION_ROLLEDBACK && state != TransactionState.TRANSACTION_COMMITED) {
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"commitSubTransaction(" + request.getTransactionContext() + ")"});
            Connection conn = this.stateMgr.getConnection(request, false);
            if (conn != null && conn.getCapabilities().supportsXATransactions()) {
                try {
                    this.stateMgr.changeTransactionState(request, TransactionState.TRANSACTION_COMMITED);
                    TransactionContext txnCtx = this.stateMgr.getTransactionContext(request);
                    XAResource xaRes = ((XAConnection)conn).getXAResource();
                    this.getTransactionManager().delistResource(xaRes);
                    this.getTransactionManager().terminateSubTransaction(txnCtx, true);
                }
                finally {
                    this.releaseTransactionLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackTransaction(AtomicRequestMessage request) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        block7: {
            TransactionState state = this.stateMgr.getTransactionState(request);
            if (request.isTransactional() && state != TransactionState.TRANSACTION_ROLLEDBACK && state != TransactionState.TRANSACTION_COMMITED) {
                LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{"Rolling back request(" + request.getTransactionContext() + ")"});
                Connection conn = this.stateMgr.getConnection(request, false);
                try {
                    if (conn == null || !conn.getCapabilities().supportsXATransactions()) break block7;
                    this.stateMgr.changeTransactionState(request, TransactionState.TRANSACTION_ROLLEDBACK);
                    XAConnection xaConn = (XAConnection)conn;
                    try {
                        this.getTransactionManager().delistResource(xaConn.getXAResource());
                    }
                    finally {
                        this.getTransactionManager().terminateSubTransaction(request.getTransactionContext(), false);
                    }
                }
                finally {
                    this.releaseTransactionLock();
                }
            }
        }
    }

    private void verifyIsQuery(AtomicRequestMessage atomicReq, Execution execution) throws ConnectorException {
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        if (executionMode != 0 && executionMode != 2 && executionMode != 5) {
            Object[] params = new Object[]{execution.getClass().getName()};
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_expecting_an_Execution_of_type_SynchExecution,_got", params));
        }
    }

    private void processCancelRequest(AtomicRequestMessage atomicReq) throws ConnectorException {
        boolean shouldClose = this.stateMgr.cancelProcessing(atomicReq);
        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Processing CANCEL request"});
        Execution execution = this.stateMgr.getExecution(atomicReq);
        if (execution != null) {
            execution.cancel();
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Cancelled command"});
        }
        if (shouldClose) {
            this.closeProcessing(atomicReq, true);
        }
        String errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled.", new Object[]{atomicReq.getRequestID(), new Integer(atomicReq.getNodeID())});
        LogManager.logDetail((String)"DQP", (String)errorMsg);
        this.sendError(atomicReq, (Throwable)new ConnectorException(errorMsg));
        this.logSRCCommand(atomicReq, (short)3, -1);
    }

    private Batch getNextBatch(BatchedExecution execution, ICommand command) throws ConnectorException {
        if (command instanceof IProcedure) {
            return ConnectorWorker.getNextProcedureBatch((ProcedureExecution)execution, (IProcedure)command);
        }
        return execution.nextBatch();
    }

    static Batch getNextProcedureBatch(ProcedureExecution execution, IProcedure command) throws ConnectorException {
        ArrayList results = new ArrayList();
        List params = command.getParameters();
        int paramCols = 0;
        int resultSetCols = 0;
        if (params != null && !params.isEmpty()) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IParameter param = (IParameter)iter.next();
                if (param.getDirection() == 4) {
                    resultSetCols = param.getMetadataID().getChildIDs().size();
                    continue;
                }
                if (param.getDirection() != 3 && param.getDirection() != 1 && param.getDirection() != 2) continue;
                ++paramCols;
            }
        }
        Batch abatch = execution.nextBatch();
        boolean atLast = false;
        if (abatch.getResults() != null && abatch.getResults().length > 0) {
            for (int i = 0; i < abatch.getResults().length; ++i) {
                results.add(new ArrayList(abatch.getResults()[i]));
            }
            int resultSetSize = ((List)results.get(0)).size();
            if (resultSetSize != resultSetCols) {
                throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_result_set_unexpected_columns", new Object[]{command, new Integer(resultSetCols), new Integer(resultSetSize)}));
            }
            if (paramCols != 0) {
                List<Object> resultsPadding = Arrays.asList(new Object[paramCols]);
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    ((List)iter.next()).addAll(resultsPadding);
                }
            }
        } else {
            atLast = true;
        }
        if (atLast || abatch.isLast()) {
            return ConnectorWorker.prepareLastProcedureBatch(execution, results, params, paramCols, resultSetCols);
        }
        BasicBatch batch = new BasicBatch(results);
        return batch;
    }

    private static Batch prepareLastProcedureBatch(ProcedureExecution execution, List results, List params, int paramCols, int resultSetCols) throws ConnectorException {
        ArrayList<Object> outParamValues = new ArrayList<Object>(params.size());
        if (params != null && !params.isEmpty()) {
            IParameter param;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 3) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 1 && param.getDirection() != 2) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            Iterator i = outParamValues.iterator();
            int index = resultSetCols;
            while (i.hasNext()) {
                Object[] newRow = new Object[paramCols + resultSetCols];
                newRow[index] = i.next();
                results.add(Arrays.asList(newRow));
                ++index;
            }
        }
        BasicBatch batch = new BasicBatch(results);
        batch.setLast();
        return batch;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
    }

    private void sendResults(AtomicRequestMessage request, Batch batch, List elements, int rowsProcessed) throws CommunicationException {
        boolean done = batch.isLast();
        int rowCount = batch.getRowCount();
        if (!done && rowCount == 0) {
            LogManager.logWarning((String)"CONNECTOR", (String)DQPPlugin.Util.getString("ConnectorWorker.zero_size_non_last_batch", (Object)request.getConnectorID()));
        }
        ExecutionContextImpl context = (ExecutionContextImpl)this.stateMgr.getExecutionContext(request);
        ResultsMessage response = new ResultsMessage((RequestMessage)request, batch.getResults(), elements, true);
        response.setFirstRow(rowsProcessed + 1 - rowCount);
        response.setLastRow(rowsProcessed);
        response.setSupportsImplicitClose(!context.keepExecutionAlive());
        if (done) {
            response.setFinalRow(rowsProcessed);
            response.setPartialResults(false);
        } else {
            response.setFinalRow(-1);
            response.setPartialResults(true);
        }
        this.sendResponse(request, response, done);
    }

    private void sendResponse(AtomicRequestMessage request, ResultsMessage response, boolean done) throws CommunicationException {
        try {
            this.basicSendResponse(request, response);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{request.getRequestID().getConnectionID()};
            String msg = DQPPlugin.Util.getString("ConnectorWorker.Error_communicating_results_to_client", params);
            LogManager.logError((String)"CONNECTOR", (Throwable)e, (String)msg);
            throw e;
        }
    }

    private void basicSendResponse(AtomicRequestMessage request, ResultsMessage response) throws CommunicationException {
        request.getClientConnection().send((Message)response, request.getMessageKey());
    }

    private void sendError(AtomicRequestMessage request, Throwable error) {
        if (request != null) {
            ResultsMessage response = new ResultsMessage((RequestMessage)request, true);
            response.setException(error);
            try {
                this.basicSendResponse(request, response);
            }
            catch (CommunicationException e) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.Can__t_communicate_error_to_client");
                LogManager.logError((String)"CONNECTOR", (Throwable)e, (String)msg);
            }
        }
    }

    private void logSRCCommand(AtomicRequestMessage qr, short cmdStatus, int finalRowCnt) {
        if (this.tracker == null || !this.tracker.willRecordSrcCmd()) {
            return;
        }
        Command sqlCmd = null;
        if (cmdStatus == 1) {
            sqlCmd = qr.getCommand();
        }
        String userName = qr.getUserName();
        TransactionID transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTopLevelTxnID();
        }
        String modelName = qr.getModelName();
        SecurityContext context = this.stateMgr.getExecutionContext(qr);
        this.tracker.log(qr.getRequestID().toString(), (long)qr.getNodeID(), transactionID == null ? null : transactionID.asString(), cmdStatus, modelName == null ? "null" : modelName, qr.getConnectorBindingID(), cmdStatus == 1 ? (short)1 : 2, qr.getConnectionID(), userName == null ? "unknown" : userName, sqlCmd, finalRowCnt, (ExecutionContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProcessing(AtomicRequestMessage atomicReq, boolean forceRollback) throws ConnectorException {
        if (this.stateMgr.isActive(atomicReq)) {
            try {
                Execution execution = this.stateMgr.getExecution(atomicReq);
                if (execution != null) {
                    if (forceRollback || this.stateMgr.isCancelled(atomicReq)) {
                        execution.cancel();
                        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Cancelled command"});
                    } else {
                        execution.close();
                        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Closed execution"});
                    }
                }
                this.processCloseTransactionRequest(atomicReq, forceRollback);
            }
            finally {
                this.closeConnection(atomicReq);
            }
        }
    }

    private void closeConnection(AtomicRequestMessage atomicReq) throws ConnectorException {
        Connection connection = this.stateMgr.getConnection(atomicReq, false);
        if (connection != null) {
            connection.release();
            LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{atomicReq.getRequestID(), "Closed connection"});
        }
        this.stateMgr.removeState(atomicReq);
    }

    private MMTransactionManager getTransactionManager() throws MetaMatrixComponentException {
        return this.transactionService.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireTransactionLock(TransactionContext tc, XAResource resource) throws MetaMatrixComponentException {
        this.lockKey = new LockKey(tc, resource);
        Map map = transactionLocks;
        synchronized (map) {
            this.transactionLock = (Lock)transactionLocks.get(this.lockKey);
            if (this.transactionLock == null) {
                this.transactionLock = new Lock();
                transactionLocks.put(this.lockKey, this.transactionLock);
            }
            this.transactionLock.increaseWaitCount();
        }
        try {
            this.transactionLock.acquire();
        }
        catch (InterruptedException err) {
            this.releaseTransactionLock(false);
            throw new MetaMatrixComponentException((Throwable)err);
        }
        map = transactionLocks;
        synchronized (map) {
            this.transactionLock.setHeld();
        }
    }

    private void releaseTransactionLock() {
        this.releaseTransactionLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTransactionLock(boolean held) {
        if (this.lockKey != null) {
            if (held) {
                this.transactionLock.release();
            }
            Map map = transactionLocks;
            synchronized (map) {
                if (!held) {
                    this.transactionLock.decreaseWaitCount();
                }
                if (!this.transactionLock.isHeld() && this.transactionLock.getWaitCount() <= 0) {
                    transactionLocks.remove(this.lockKey);
                }
            }
        }
        this.transactionLock = null;
        this.lockKey = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LockKey {
        private String tid;
        private XAResource resource;

        public LockKey(TransactionContext tc, XAResource resource) {
            this.tid = tc.getTopLevelTxnID().asString();
            this.resource = resource;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LockKey) {
                LockKey key = (LockKey)obj;
                try {
                    return this.tid.equals(key.tid) && this.resource.isSameRM(key.resource);
                }
                catch (XAException err) {
                    return false;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.tid.hashCode();
        }
    }

    private static class Lock {
        private Semaphore semaphore = new Semaphore(1L);
        private int waitCount = 0;
        private boolean held;

        public void acquire() throws InterruptedException {
            this.semaphore.acquire();
        }

        public void increaseWaitCount() {
            ++this.waitCount;
        }

        public void decreaseWaitCount() {
            --this.waitCount;
        }

        public void setHeld() {
            this.held = true;
            --this.waitCount;
        }

        public int getWaitCount() {
            return this.waitCount;
        }

        public void release() {
            this.held = false;
            this.semaphore.release();
        }

        public boolean isHeld() {
            return this.held;
        }
    }
}

