/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.MMUserTransactionServer;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SQLQuery;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionProcessor {
    private Map threadToXid;
    private TransactionService service;
    private MetadataService metadataService;
    private TrackingService trackingService;
    private boolean transactionsAllowed;

    public TransactionProcessor(TransactionService transactionService, MetadataService metadataService, TrackingService trackingService, boolean transactionsAllowed) {
        this.service = transactionService;
        this.metadataService = metadataService;
        this.trackingService = trackingService;
        this.transactionsAllowed = transactionsAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DQPMessage proccessTransactionMessage(TransactionMessage msg) throws MetaMatrixComponentException, XATransactionException, XAException {
        if (!this.transactionsAllowed) {
            String message = DQPPlugin.Util.getString("TransactionProcessor.Transactions_not_allowed_due_to_license_restriction");
            LogManager.logError((String)"DQP", (String)message);
            throw new MetaMatrixComponentException(message);
        }
        switch (msg.getRequestType()) {
            case 7: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)1, (short)5, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().start(msg.getXid(), msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 11: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)4, (short)6, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().end(msg.getXid(), msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 12: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)4, (short)7, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    int result = this.service.getXAServer().prepare(msg.getXid());
                    msg.setParameter(result);
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 8: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)8, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().commit(msg.getXid(), 1 == msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 10: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)9, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().forget(msg.getXid());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 13: {
                try {
                    Xid[] xids = this.service.getXAServer().recover(msg.getParameter());
                    msg.setRecoveredXids(xids);
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 9: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)11, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().rollback(msg.getXid());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 14: {
                try {
                    this.service.getXAServer().setTransactionTimeout(msg.getTxnTimeout());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 1: {
                msg.setTxnRequired(this.checkNeedTxn(msg));
                break;
            }
            case 2: {
                String threadId = msg.getThreadIdentifier();
                String txnID = this.getTransactionID(threadId);
                if (txnID != null) {
                    msg.setException((Throwable)new NotSupportedException(DQPPlugin.Util.getString("TransactionProcessor.Client_thread_already_involved_in_transaction")));
                    break;
                }
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    txnID = uts.begin(msg.getTxnTimeout());
                    this.addUserTransactionBinding(threadId, txnID);
                    msg.setMMXid(txnID);
                    if (!this.trackingService.willRecordTxn()) break;
                    this.trackingService.log(txnID, (short)1, (short)1, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                catch (Throwable e) {
                    this.removeThreadMapping(threadId);
                    msg.setException(e);
                }
                break;
            }
            case 3: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)2, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.commit(xid);
                        break;
                    }
                    msg.setException((Throwable)new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e) {
                    msg.setException(e);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 4: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)3, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.rollback(xid);
                        break;
                    }
                    msg.setException((Throwable)new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e) {
                    msg.setException(e);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 5: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)4, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.setRollbackOnly(xid);
                        break;
                    }
                    msg.setException((Throwable)new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e) {
                    msg.setException(e);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 6: {
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(msg.getThreadIdentifier());
                    int status = 5;
                    if (xid != null) {
                        status = uts.getStatus(xid);
                    } else {
                        msg.setException((Throwable)new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    }
                    msg.setTxnStatus(status);
                    break;
                }
                catch (Throwable e) {
                    msg.setException(e);
                }
            }
        }
        return msg;
    }

    private void removeThreadMapping(String threadId) {
        if (this.threadToXid != null) {
            this.threadToXid.remove(threadId);
        }
    }

    private String getTransactionID(String threadIdentifier) {
        if (this.threadToXid == null) {
            return null;
        }
        return (String)this.threadToXid.get(threadIdentifier);
    }

    private void addUserTransactionBinding(String threadId, String xId) {
        if (this.threadToXid == null) {
            this.threadToXid = new HashMap(11);
        }
        this.threadToXid.put(threadId, xId);
    }

    private boolean checkNeedTxn(TransactionMessage msg) throws MetaMatrixComponentException {
        try {
            QueryMetadataInterface metadata = this.metadataService.lookupMetadata(msg.getVdbName(), msg.getVdbVersion());
            Command command = msg.getCommand();
            QueryParser parser = new QueryParser();
            if (command.getType() == 5) {
                command = parser.parseCommand(((SQLQuery)command).getQuery());
            } else if (command.getType() == 9) {
                List updates = ((BatchedUpdateCommand)command).getUpdateCommands();
                ArrayList<Command> parsedCommands = new ArrayList<Command>(updates.size());
                SQLQuery updateCommand = null;
                for (int i = 0; i < updates.size(); ++i) {
                    updateCommand = (SQLQuery)updates.get(i);
                    parsedCommands.add(parser.parseCommand(updateCommand.getQuery()));
                }
                command = new BatchedUpdateCommand(parsedCommands);
            }
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            if (command.updatingModelCount(metadata) > 1) {
                return true;
            }
        }
        catch (RuntimeException e) {
            String errMsg = DQPPlugin.Util.getString("TransactionProcessor.checkNeedTxn.rtException", (Object)msg.getRequestID());
            LogManager.logError((String)"DQP", (Throwable)e, (String)errMsg);
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        catch (QueryResolverException e) {
            return false;
        }
        catch (QueryParserException e) {
            return false;
        }
        return false;
    }
}

