/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.adaptor.EclipseElementFactory;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.adaptor.FileManager;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.adaptor.StreamManager;
import org.eclipse.core.runtime.adaptor.StreamManagerOutputStream;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.BundleLocalizationImpl;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseBundleInstaller;
import org.eclipse.core.runtime.internal.adaptor.EclipseCommandProvider;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.core.runtime.internal.adaptor.PluginParser;
import org.eclipse.core.runtime.internal.adaptor.URLConverterImpl;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.StateManager;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class EclipseAdaptor
extends AbstractFrameworkAdaptor {
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_EXITONERROR = "eclipse.exitOnError";
    static final String F_LOG = ".log";
    public static final String PLUGIN_CLASS = "Plugin-Class";
    public static final String ECLIPSE_AUTOSTART = "Eclipse-AutoStart";
    public static final String ECLIPSE_AUTOSTART_EXCEPTIONS = "exceptions";
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String OPTION_CONVERTER = "org.eclipse.osgi/eclipseadaptor/converter/debug";
    private static final String OPTION_LOCATION = "org.eclipse.osgi/eclipseadaptor/debug/location";
    public static final byte BUNDLEDATA_VERSION = 16;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    private static EclipseAdaptor instance;
    private byte cacheVersion;
    private long timeStamp = 0L;
    private String installPath = null;
    private boolean exitOnError = true;
    private BundleStopper stopper;
    private FileManager fileManager;
    private boolean reinitialize = false;
    static /* synthetic */ Class class$org$eclipse$osgi$service$datalocation$Location;
    static /* synthetic */ Class class$org$eclipse$osgi$service$environment$EnvironmentInfo;
    static /* synthetic */ Class class$org$eclipse$osgi$service$resolver$PlatformAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$service$pluginconversion$PluginConverter;
    static /* synthetic */ Class class$org$eclipse$osgi$service$urlconversion$URLConverter;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$console$CommandProvider;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$log$FrameworkLog;
    static /* synthetic */ Class class$org$eclipse$osgi$service$localization$BundleLocalization;

    public EclipseAdaptor(String[] args) {
        super(args);
        instance = this;
        this.setDebugOptions();
    }

    public static EclipseAdaptor getDefault() {
        return instance;
    }

    private FrameworkLog createPerformanceLog() {
        int lastSlash;
        String logFileProp = System.getProperty("osgi.logfile");
        if (logFileProp != null && (lastSlash = logFileProp.lastIndexOf(File.separatorChar)) > 0) {
            String logFile = logFileProp.substring(0, lastSlash + 1) + "performance.log";
            return new EclipseLog(new File(logFile));
        }
        return new EclipseLog(new PrintWriter(System.err));
    }

    public void initialize(EventPublisher publisher) {
        Location installLoc;
        if (Boolean.getBoolean(PROP_CLEAN)) {
            this.cleanOSGiCache();
        }
        boolean readOnlyConfiguration = LocationManager.getConfigurationLocation().isReadOnly();
        this.fileManager = this.initFileManager(LocationManager.getOSGiConfigurationDir(), readOnlyConfiguration ? "none" : null, readOnlyConfiguration);
        this.readHeaders();
        super.initialize(publisher);
        if (System.getProperty("org.osgi.framework.bootdelegation") == null && !"none".equals(System.getProperty("osgi.java.profile.bootdelegation"))) {
            System.getProperties().put("org.osgi.framework.bootdelegation", "*");
        }
        if ((installLoc = LocationManager.getInstallLocation()) != null) {
            URL installURL = installLoc.getURL();
            this.installPath = installURL.getPath();
        }
    }

    public void initializeMetadata() {
    }

    protected void initBundleStoreRootDir() {
        File configurationLocation = LocationManager.getOSGiConfigurationDir();
        if (configurationLocation != null) {
            this.bundleStoreRootDir = new File(configurationLocation, "bundles");
            this.bundleStore = this.bundleStoreRootDir.getAbsolutePath();
        } else {
            this.bundleStore = "bundles";
            this.bundleStoreRootDir = new File(this.bundleStore);
        }
        this.properties.put("osgi.bundlestore", this.bundleStoreRootDir.getAbsolutePath());
    }

    protected FrameworkLog createFrameworkLog() {
        if (this.frameworkLog != null) {
            return this.frameworkLog;
        }
        return EclipseStarter.createFrameworkLog();
    }

    private File[] findStateFiles() {
        File lazyFile;
        File stateFile;
        block12: {
            block11: {
                if (this.reinitialize) {
                    return new File[2];
                }
                stateFile = null;
                lazyFile = null;
                try {
                    stateFile = this.fileManager.lookup(".state", false);
                    lazyFile = this.fileManager.lookup(".lazy", false);
                }
                catch (IOException ex) {
                    if (!Debug.DEBUG_GENERAL) break block11;
                    Debug.println("Error reading state file " + ex.getMessage());
                    Debug.printStackTrace(ex);
                }
            }
            if (stateFile == null || !stateFile.isFile()) {
                Location parentConfiguration = null;
                Location currentConfiguration = LocationManager.getConfigurationLocation();
                if (currentConfiguration != null && (parentConfiguration = currentConfiguration.getParentLocation()) != null) {
                    try {
                        File stateLocationDir = new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi");
                        FileManager newFileManager = this.initFileManager(stateLocationDir, "none", true);
                        stateFile = newFileManager.lookup(".state", false);
                        lazyFile = newFileManager.lookup(".lazy", false);
                    }
                    catch (IOException ex) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("Error reading state file " + ex.getMessage());
                            Debug.printStackTrace(ex);
                        }
                        break block12;
                    }
                }
                try {
                    if (this.canWrite()) {
                        stateFile = this.fileManager.lookup(".state", true);
                        lazyFile = this.fileManager.lookup(".lazy", true);
                    }
                }
                catch (IOException ex) {
                    if (!Debug.DEBUG_GENERAL) break block12;
                    Debug.println("Error reading state file " + ex.getMessage());
                    Debug.printStackTrace(ex);
                }
            }
        }
        return new File[]{stateFile, lazyFile};
    }

    protected StateManager createStateManager() {
        File[] stateFiles = this.findStateFiles();
        File stateFile = stateFiles[0];
        File lazyFile = stateFiles[1];
        this.stateManager = new StateManager(stateFile, lazyFile, this.context, this.timeStamp);
        this.stateManager.setInstaller(new EclipseBundleInstaller(this.context));
        State systemState = null;
        if (!this.invalidState && (systemState = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        Bundle[] installedBundles = this.context.getBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        for (int i = 0; i < installedBundles.length; ++i) {
            Bundle toAdd = installedBundles[i];
            try {
                Dictionary toAddManifest = toAdd.getHeaders("");
                if (toAddManifest instanceof CachedManifest) {
                    toAddManifest = ((CachedManifest)toAddManifest).getManifest();
                }
                BundleDescription newDescription = factory.createBundleDescription(systemState, toAddManifest, toAdd.getLocation(), toAdd.getBundleId());
                systemState.addBundle(newDescription);
                continue;
            }
            catch (BundleException be) {
                // empty catch block
            }
        }
        systemState.setTimeStamp(this.timeStamp);
        systemState.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    public void shutdownStateManager() {
        if (!this.canWrite() || this.stateManager.getCachedTimeStamp() == this.stateManager.getSystemState().getTimeStamp()) {
            return;
        }
        try {
            File stateTmpFile = File.createTempFile(".state", ".new", LocationManager.getOSGiConfigurationDir());
            File lazyTmpFile = File.createTempFile(".lazy", ".new", LocationManager.getOSGiConfigurationDir());
            this.stateManager.shutdown(stateTmpFile, lazyTmpFile);
            this.fileManager.lookup(".state", true);
            this.fileManager.lookup(".lazy", true);
            this.fileManager.update(new String[]{".state", ".lazy"}, new String[]{stateTmpFile.getName(), lazyTmpFile.getName()});
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), e));
        }
    }

    private void cleanOSGiCache() {
        File osgiConfig = LocationManager.getOSGiConfigurationDir();
        if (!this.rm(osgiConfig)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders() {
        block7: {
            InputStream bundleDataStream = this.findBundleDataFile();
            if (bundleDataStream == null) {
                return;
            }
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(bundleDataStream));
                try {
                    this.cacheVersion = in.readByte();
                    if (this.cacheVersion == 16) {
                        this.timeStamp = in.readLong();
                        this.initialBundleStartLevel = in.readInt();
                        this.nextId = in.readLong();
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) break block7;
                Debug.println("Error reading framework metadata: " + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new EclipseElementFactory();
        }
        return this.elementFactory;
    }

    public void frameworkStart(BundleContext aContext) throws BundleException {
        EclipseEnvironmentInfo.getDefault();
        this.registerEndorsedXMLParser(aContext);
        PluginConverterImpl converter = new PluginConverterImpl(aContext);
        super.frameworkStart(aContext);
        Bundle bundle = aContext.getBundle();
        Location location = LocationManager.getUserLocation();
        Hashtable<String, String> locationProperties = new Hashtable<String, String>(1);
        if (location != null) {
            locationProperties.put("type", "osgi.user.area");
            aContext.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getInstanceLocation()) != null) {
            locationProperties.put("type", "osgi.instance.area");
            aContext.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getConfigurationLocation()) != null) {
            locationProperties.put("type", "osgi.configuration.area");
            aContext.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, locationProperties);
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            locationProperties.put("type", "osgi.install.area");
            aContext.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, locationProperties);
        }
        this.register((class$org$eclipse$osgi$service$environment$EnvironmentInfo == null ? (class$org$eclipse$osgi$service$environment$EnvironmentInfo = EclipseAdaptor.class$("org.eclipse.osgi.service.environment.EnvironmentInfo")) : class$org$eclipse$osgi$service$environment$EnvironmentInfo).getName(), EclipseEnvironmentInfo.getDefault(), bundle);
        this.register((class$org$eclipse$osgi$service$resolver$PlatformAdmin == null ? (class$org$eclipse$osgi$service$resolver$PlatformAdmin = EclipseAdaptor.class$("org.eclipse.osgi.service.resolver.PlatformAdmin")) : class$org$eclipse$osgi$service$resolver$PlatformAdmin).getName(), this.stateManager, bundle);
        this.register((class$org$eclipse$osgi$service$pluginconversion$PluginConverter == null ? (class$org$eclipse$osgi$service$pluginconversion$PluginConverter = EclipseAdaptor.class$("org.eclipse.osgi.service.pluginconversion.PluginConverter")) : class$org$eclipse$osgi$service$pluginconversion$PluginConverter).getName(), converter, bundle);
        this.register((class$org$eclipse$osgi$service$urlconversion$URLConverter == null ? (class$org$eclipse$osgi$service$urlconversion$URLConverter = EclipseAdaptor.class$("org.eclipse.osgi.service.urlconversion.URLConverter")) : class$org$eclipse$osgi$service$urlconversion$URLConverter).getName(), new URLConverterImpl(), bundle);
        this.register((class$org$eclipse$osgi$framework$console$CommandProvider == null ? (class$org$eclipse$osgi$framework$console$CommandProvider = EclipseAdaptor.class$("org.eclipse.osgi.framework.console.CommandProvider")) : class$org$eclipse$osgi$framework$console$CommandProvider).getName(), new EclipseCommandProvider(aContext), bundle);
        this.register((class$org$eclipse$osgi$framework$log$FrameworkLog == null ? (class$org$eclipse$osgi$framework$log$FrameworkLog = EclipseAdaptor.class$("org.eclipse.osgi.framework.log.FrameworkLog")) : class$org$eclipse$osgi$framework$log$FrameworkLog).getName(), this.getFrameworkLog(), bundle);
        this.registerPerformanceLog(bundle);
        this.register((class$org$eclipse$osgi$service$localization$BundleLocalization == null ? (class$org$eclipse$osgi$service$localization$BundleLocalization = EclipseAdaptor.class$("org.eclipse.osgi.service.localization.BundleLocalization")) : class$org$eclipse$osgi$service$localization$BundleLocalization).getName(), new BundleLocalizationImpl(), bundle);
    }

    private void registerPerformanceLog(Bundle bundle) {
        FrameworkLog service = this.createPerformanceLog();
        String serviceName = (class$org$eclipse$osgi$framework$log$FrameworkLog == null ? (class$org$eclipse$osgi$framework$log$FrameworkLog = EclipseAdaptor.class$("org.eclipse.osgi.framework.log.FrameworkLog")) : class$org$eclipse$osgi$framework$log$FrameworkLog).getName();
        Hashtable serviceProperties = new Hashtable(7);
        Dictionary headers = bundle.getHeaders();
        serviceProperties.put("service.vendor", headers.get("Bundle-Vendor"));
        serviceProperties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        serviceProperties.put("service.pid", bundle.getBundleId() + 46L + service.getClass().getName());
        serviceProperties.put("performance", Boolean.TRUE.toString());
        this.context.registerService(serviceName, (Object)service, serviceProperties);
    }

    private void setDebugOptions() {
        FrameworkDebugOptions options = FrameworkDebugOptions.getDefault();
        if (options == null) {
            return;
        }
        StateManager.DEBUG = options != null;
        StateManager.DEBUG_READER = options.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = options.getBooleanOption(OPTION_MONITOR_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN = options.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = options.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
        PluginConverterImpl.DEBUG = options.getBooleanOption(OPTION_CONVERTER, false);
        BasicLocation.DEBUG = options.getBooleanOption(OPTION_LOCATION, false);
    }

    private void registerEndorsedXMLParser(BundleContext bc) {
        try {
            Class.forName(SAXFACTORYNAME);
            bc.registerService(SAXFACTORYNAME, (Object)new SaxParsingService(), new Hashtable());
            Class.forName(DOMFACTORYNAME);
            bc.registerService(DOMFACTORYNAME, (Object)new DomParsingService(), new Hashtable());
        }
        catch (ClassNotFoundException e) {
            String message = EclipseAdaptorMsg.ECLIPSE_ADAPTOR_ERROR_XML_SERVICE;
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, e, null));
        }
    }

    public boolean canWrite() {
        return !this.fileManager.isReadOnly();
    }

    public void frameworkStop(BundleContext aContext) throws BundleException {
        this.saveMetaData();
        super.frameworkStop(aContext);
        this.printStats();
        PluginParser.releaseXMLParsing();
        this.fileManager.close();
    }

    private void printStats() {
        String constraintResolution;
        String packageAdminResolution;
        FrameworkDebugOptions debugOptions = FrameworkDebugOptions.getDefault();
        if (debugOptions == null) {
            return;
        }
        String registryParsing = debugOptions.getOption("org.eclipse.core.runtime/registry/parsing/timing/value");
        if (registryParsing != null) {
            EclipseAdaptorMsg.debug("Time spent in registry parsing: " + registryParsing);
        }
        if ((packageAdminResolution = debugOptions.getOption("debug.packageadmin/timing/value")) != null) {
            System.out.println("Time spent in package admin resolve: " + packageAdminResolution);
        }
        if ((constraintResolution = debugOptions.getOption("org.eclipse.core.runtime.adaptor/resolver/timing/value")) != null) {
            System.out.println("Time spent resolving the dependency system: " + constraintResolution);
        }
    }

    private InputStream findBundleDataFile() {
        InputStream bundleDataStream;
        StreamManager streamManager;
        block8: {
            if (this.reinitialize) {
                return null;
            }
            streamManager = new StreamManager(this.fileManager);
            bundleDataStream = null;
            try {
                bundleDataStream = streamManager.getInputStream(".bundledata", 0);
            }
            catch (IOException ex) {
                if (!Debug.DEBUG_GENERAL) break block8;
                Debug.println("Error reading framework metadata: " + ex.getMessage());
                Debug.printStackTrace(ex);
            }
        }
        if (bundleDataStream == null) {
            Location currentConfiguration = LocationManager.getConfigurationLocation();
            Location parentConfiguration = null;
            if (currentConfiguration != null && (parentConfiguration = currentConfiguration.getParentLocation()) != null) {
                try {
                    File bundledataLocationDir = new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi");
                    FileManager newFileManager = this.initFileManager(bundledataLocationDir, "none", true);
                    bundleDataStream = streamManager.getInputStream(".bundledata", 0);
                    newFileManager.close();
                }
                catch (MalformedURLException e1) {
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        return bundleDataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BundleData[] getInstalledBundles() {
        InputStream bundleDataStream = this.findBundleDataFile();
        if (bundleDataStream == null) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(bundleDataStream));
            try {
                byte version = in.readByte();
                if (version != 16) {
                    BundleData[] bundleDataArray = null;
                    return bundleDataArray;
                }
                in.readLong();
                in.readInt();
                in.readLong();
                int bundleCount = in.readInt();
                ArrayList<EclipseBundleData> result = new ArrayList<EclipseBundleData>(bundleCount);
                long id = -1L;
                boolean bundleDiscarded = false;
                for (int i = 0; i < bundleCount; ++i) {
                    try {
                        id = in.readLong();
                        if (id == 0L) continue;
                        EclipseBundleData data = (EclipseBundleData)this.getElementFactory().createBundleData(this, id);
                        this.loadMetaDataFor(data, in, version);
                        data.initializeExistingBundle();
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("BundleData created: " + data);
                        }
                        this.processExtension(data, (byte)1);
                        result.add(data);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        bundleDiscarded = true;
                        continue;
                    }
                    catch (BundleException e) {
                        bundleDiscarded = true;
                        continue;
                    }
                    catch (IOException e) {
                        bundleDiscarded = true;
                        if (!Debug.DEBUG_GENERAL) continue;
                        Debug.println("Error reading framework metadata: " + e.getMessage());
                        Debug.printStackTrace(e);
                    }
                }
                if (bundleDiscarded) {
                    System.getProperties().put("eclipse.refreshBundles", "true");
                }
                BundleData[] bundleDataArray = result.toArray(new BundleData[result.size()]);
                return bundleDataArray;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.println("Error reading framework metadata: " + e.getMessage());
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void loadMetaDataFor(EclipseBundleData data, DataInputStream in, byte version) throws IOException {
        File storedPath;
        byte flag = in.readByte();
        if (flag == 0) {
            return;
        }
        data.setLocation(this.readString(in, false));
        data.setFileName(this.readString(in, false));
        data.setSymbolicName(this.readString(in, false));
        data.setVersion(Version.parseVersion(this.readString(in, false)));
        data.setActivator(this.readString(in, false));
        data.setAutoStart(in.readBoolean());
        int exceptionsCount = in.readInt();
        String[] autoStartExceptions = exceptionsCount > 0 ? new String[exceptionsCount] : null;
        for (int i = 0; i < exceptionsCount; ++i) {
            autoStartExceptions[i] = in.readUTF();
        }
        data.setAutoStartExceptions(autoStartExceptions);
        data.hasPackageInfo = in.readBoolean();
        data.buddyList = this.readString(in, false);
        data.registeredBuddyList = this.readString(in, false);
        data.setPluginClass(this.readString(in, false));
        data.setClassPathString(this.readString(in, false));
        data.setNativePaths(this.readString(in, false));
        data.setExecutionEnvironment(this.readString(in, false));
        data.setDynamicImports(this.readString(in, false));
        data.setGeneration(in.readInt());
        data.setStartLevel(in.readInt());
        data.setStatus(in.readInt());
        data.setReference(in.readBoolean());
        data.setManifestTimeStamp(in.readLong());
        data.setManifestType(in.readByte());
        data.setLastModified(in.readLong());
        data.setType(in.readInt());
        if (data.isReference() && !(storedPath = new File(data.getFileName())).isAbsolute()) {
            data.setFileName(new FilePath(this.installPath + data.getFileName()).toString());
        }
    }

    public void saveMetaDataFor(EclipseBundleData data) throws IOException {
        if (!data.isAutoStartable()) {
            --this.timeStamp;
        }
    }

    public void persistInitialBundleStartLevel(int value) {
        --this.timeStamp;
    }

    public void persistNextBundleID(long value) {
    }

    protected void saveMetaDataFor(BundleData data, DataOutputStream out) throws IOException {
        if (data.getBundleID() == 0L || !(data instanceof AbstractBundleData)) {
            out.writeByte(0);
            return;
        }
        EclipseBundleData bundleData = (EclipseBundleData)data;
        out.writeByte(1);
        this.writeStringOrNull(out, bundleData.getLocation());
        String storedFileName = bundleData.isReference() ? new FilePath(this.installPath).makeRelative(new FilePath(bundleData.getFileName())) : bundleData.getFileName();
        this.writeStringOrNull(out, storedFileName);
        this.writeStringOrNull(out, bundleData.getSymbolicName());
        this.writeStringOrNull(out, bundleData.getVersion().toString());
        this.writeStringOrNull(out, bundleData.getActivator());
        out.writeBoolean(bundleData.isAutoStart());
        String[] autoStartExceptions = bundleData.getAutoStartExceptions();
        if (autoStartExceptions == null) {
            out.writeInt(0);
        } else {
            out.writeInt(autoStartExceptions.length);
            for (int i = 0; i < autoStartExceptions.length; ++i) {
                out.writeUTF(autoStartExceptions[i]);
            }
        }
        out.writeBoolean(bundleData.hasPackageInfo);
        this.writeStringOrNull(out, bundleData.buddyList);
        this.writeStringOrNull(out, bundleData.registeredBuddyList);
        this.writeStringOrNull(out, bundleData.getPluginClass());
        this.writeStringOrNull(out, bundleData.getClassPathString());
        this.writeStringOrNull(out, bundleData.getNativePathsString());
        this.writeStringOrNull(out, bundleData.getExecutionEnvironment());
        this.writeStringOrNull(out, bundleData.getDynamicImports());
        out.writeInt(bundleData.getGeneration());
        out.writeInt(bundleData.getStartLevel());
        out.writeInt(bundleData.getPersistentStatus());
        out.writeBoolean(bundleData.isReference());
        out.writeLong(bundleData.getManifestTimeStamp());
        out.writeByte(bundleData.getManifestType());
        out.writeLong(bundleData.getLastModified());
        out.writeInt(bundleData.getType());
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        return intern ? in.readUTF().intern() : in.readUTF();
    }

    private void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetaData() {
        block10: {
            if (!this.canWrite() | this.timeStamp == this.stateManager.getSystemState().getTimeStamp()) {
                return;
            }
            StreamManager streamManager = new StreamManager(this.fileManager);
            try {
                StreamManagerOutputStream fmos = streamManager.getOutputStream(".bundledata");
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fmos));
                boolean error = true;
                try {
                    out.writeByte(16);
                    out.writeLong(this.stateManager.getSystemState().getTimeStamp());
                    out.writeInt(this.initialBundleStartLevel);
                    out.writeLong(this.nextId);
                    Bundle[] bundles = this.context.getBundles();
                    out.writeInt(bundles.length);
                    for (int i = 0; i < bundles.length; ++i) {
                        long id = bundles[i].getBundleId();
                        out.writeLong(id);
                        if (id == 0L) continue;
                        BundleData data = ((AbstractBundle)bundles[i]).getBundleData();
                        this.saveMetaDataFor(data, out);
                    }
                    out.close();
                    error = false;
                    Object var11_10 = null;
                    if (!error) break block10;
                    fmos.abort();
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (error) {
                        fmos.abort();
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            catch (IOException e) {
                this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), e));
                return;
            }
        }
    }

    public BundleWatcher getBundleWatcher() {
        return StatsManager.getDefault();
    }

    protected BundleContext getContext() {
        return this.context;
    }

    public void frameworkStopping(BundleContext aContext) {
        super.frameworkStopping(aContext);
        this.stopper = new BundleStopper(this.context);
        this.stopper.stopBundles();
    }

    private boolean isFatalException(Throwable error) {
        if (error instanceof VirtualMachineError) {
            return true;
        }
        return error instanceof ThreadDeath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRuntimeError(Throwable error) {
        try {
            try {
                this.exitOnError = Boolean.valueOf(System.getProperty(PROP_EXITONERROR, "true"));
                String message = EclipseAdaptorMsg.ECLIPSE_ADAPTOR_RUNTIME_ERROR;
                if (this.exitOnError && this.isFatalException(error)) {
                    message = message + ' ' + EclipseAdaptorMsg.ECLIPSE_ADAPTOR_EXITING;
                }
                FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, error, null);
                this.getFrameworkLog().log(logEntry);
            }
            catch (Throwable t) {
                try {
                    error.printStackTrace();
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                }
                Object var5_7 = null;
                if (!this.exitOnError) return;
                if (!this.isFatalException(error)) return;
                System.exit(13);
                return;
            }
            Object var5_6 = null;
            if (!this.exitOnError) return;
            if (!this.isFatalException(error)) return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!this.exitOnError) throw throwable;
            if (!this.isFatalException(error)) throw throwable;
            System.exit(13);
            throw throwable;
        }
        System.exit(13);
    }

    protected void setLog(FrameworkLog log) {
        this.frameworkLog = log;
    }

    BundleStopper getBundleStopper() {
        return this.stopper;
    }

    private FileManager initFileManager(File baseDir, String lockMode, boolean readOnly) {
        FileManager fManager = new FileManager(baseDir, lockMode, readOnly);
        try {
            fManager.open(!readOnly);
        }
        catch (IOException ex) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + ex.getMessage());
                Debug.printStackTrace(ex);
            }
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, ex.getMessage());
            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, ex, null);
            this.getFrameworkLog().log(logEntry);
        }
        return fManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DomParsingService
    implements ServiceFactory {
        private DomParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return DocumentBuilderFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }

    private class SaxParsingService
    implements ServiceFactory {
        private SaxParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return SAXParserFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

