/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Symbol;
import java.util.List;

public class GroupSymbol
extends Symbol
implements Comparable {
    public static final String TEMP_GROUP_PREFIX = "#";
    private String vdbName;
    private String definition;
    private Object metadataID;
    private transient List resolvedElements;
    private boolean isTempTable;
    private boolean isProcedure;

    protected GroupSymbol(String name, String canonicalName, int hashcode, String definition) {
        super(name, canonicalName, hashcode);
        this.definition = definition;
    }

    public GroupSymbol(String name) {
        super(name);
    }

    public GroupSymbol(String name, String definition) {
        super(name);
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
        this.resolvedElements = null;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setVirtualDatabaseName(String vdbName) {
        this.vdbName = vdbName;
    }

    public String getVirtualDatabaseName() {
        return this.vdbName;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public void setMetadataID(Object metadataID) {
        if (metadataID == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0016"));
        }
        this.metadataID = metadataID;
        this.resolvedElements = null;
    }

    public void setMetadataIDToNull() {
        this.metadataID = null;
        this.resolvedElements = null;
    }

    public boolean isResolved() {
        return this.metadataID != null;
    }

    public boolean isTempGroupSymbol() {
        return this.isTempTable || this.isImplicitTempGroupSymbol();
    }

    public boolean isImplicitTempGroupSymbol() {
        return GroupSymbol.isTempGroupName(this.getName()) || GroupSymbol.isTempGroupName(this.getDefinition());
    }

    public int compareTo(Object other) {
        int diff = other.hashCode() - this.hashCode();
        if (diff == 0) {
            return 0;
        }
        if (diff < 0) {
            return -1;
        }
        return 1;
    }

    public Object clone() {
        GroupSymbol copy = new GroupSymbol(this.getName(), this.getCanonical(), this.getHash(), this.getDefinition());
        if (this.getMetadataID() != null) {
            copy.setMetadataID(this.getMetadataID());
        }
        copy.setVirtualDatabaseName(this.getVirtualDatabaseName());
        if (this.resolvedElements != null) {
            copy.resolvedElements = this.resolvedElements;
        }
        copy.setIsTempTable(this.isTempTable);
        copy.setProcedure(this.isProcedure);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GroupSymbol)) {
            return false;
        }
        GroupSymbol other = (GroupSymbol)obj;
        if (this.getDefinition() == null && other.getDefinition() == null || this.getDefinition() != null && other.getDefinition() != null) {
            return this.getCanonicalName().equals(other.getCanonicalName());
        }
        return false;
    }

    public boolean hasAlias() {
        return this.getDefinition() != null;
    }

    public void setResolvedElements(List resolvedElements) {
        this.resolvedElements = resolvedElements;
    }

    public List getResolvedElements() {
        return this.resolvedElements;
    }

    public void setName(String name) {
        super.setName(name);
        this.resolvedElements = null;
    }

    public void setIsTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public static boolean isTempGroupName(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public void setProcedure(boolean isProcedure) {
        this.isProcedure = isProcedure;
    }
}

