/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.api;

import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class EntitlementMigrationReport
implements Serializable {
    public static final int MIGRATED_INDEX = 0;
    public static final int RESOURCE_INDEX = 1;
    public static final int SOURCE_POLICYID_INDEX = 2;
    public static final int TARGET_POLICYID_INDEX = 3;
    public static final int ACTIONS_INDEX = 4;
    public static final int REASON_INDEX = 5;
    public static final int NUMBER_OF_VALUES = 6;
    private static final List headerValues = new ArrayList();
    private String sourceVDB;
    private String targetVDB;
    private List entries;
    private static final String TAB_CHAR = "\t";

    public EntitlementMigrationReport(String sourceVDB, String targetVDB) {
        this.sourceVDB = sourceVDB;
        this.targetVDB = targetVDB;
        this.entries = new ArrayList();
    }

    public void addResourceEntry(Object migrated, Object resource, Object source_policy, Object target_policy, Object actions, Object reason) {
        this.entries.add(Arrays.asList(migrated, resource, source_policy, target_policy, actions, reason));
    }

    public String getSourceVDBID() {
        return this.sourceVDB;
    }

    public void setSourceVDBID(String sourceVDB) {
        this.sourceVDB = sourceVDB;
    }

    public String getTargetVDBID() {
        return this.targetVDB;
    }

    public void setTargetVDBID(String targetVDB) {
        this.targetVDB = targetVDB;
    }

    public List getEntries() {
        return this.entries;
    }

    public List getHeaderList() {
        return headerValues;
    }

    public void writeReport(String fileName) throws Exception {
        FileWriter writer = new FileWriter(fileName);
        writer.write(this.toString());
        writer.flush();
        writer.close();
    }

    public String toString() {
        String LINE_SEP = System.getProperty("line.separator");
        StringBuffer txt = new StringBuffer();
        String sRow = "";
        String sHeaders = "Migrated\tResource\tSource Policy ID\tTarget Policy ID\tActions\tReason";
        txt.append(sHeaders);
        txt.append(LINE_SEP);
        Iterator it = this.getEntries().iterator();
        while (it.hasNext()) {
            sRow = "";
            List lstEntry = (List)it.next();
            sRow = sRow + lstEntry.get(0) + TAB_CHAR;
            sRow = sRow + lstEntry.get(1) + TAB_CHAR;
            sRow = sRow + lstEntry.get(2) + TAB_CHAR;
            sRow = sRow + lstEntry.get(3) + TAB_CHAR;
            sRow = sRow + lstEntry.get(4) + TAB_CHAR;
            sRow = sRow + lstEntry.get(5);
            txt.append(sRow);
            txt.append(LINE_SEP);
        }
        return txt.toString();
    }

    static {
        headerValues.add("Migrated");
        headerValues.add("Resource");
        headerValues.add("Source PolicyID");
        headerValues.add("Target PolicyID");
        headerValues.add("Actions");
        headerValues.add("Reason Migration Failed");
    }
}

