/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;

public class RunnableState {
    public static final int UNSTARTED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 3;
    public static final int STOPPED = 4;
    public static final int FAILED = 5;
    protected static final String UNSTARTED_LITERAL = "UNSTARTED";
    protected static final String STARTING_LITERAL = "STARTING";
    protected static final String STARTED_LITERAL = "STARTED";
    protected static final String STOPPING_LITERAL = "STOPPING";
    protected static final String STOPPED_LITERAL = "STOPPED";
    protected static final String FAILED_LITERAL = "FAILED";
    private int state = 0;

    protected static String getLiteralForState(int value) {
        switch (value) {
            case 0: {
                return UNSTARTED_LITERAL;
            }
            case 1: {
                return STARTING_LITERAL;
            }
            case 2: {
                return STARTED_LITERAL;
            }
            case 3: {
                return STOPPING_LITERAL;
            }
            case 4: {
                return STOPPED_LITERAL;
            }
            case 5: {
                return FAILED_LITERAL;
            }
        }
        throw new IllegalArgumentException(CorePlugin.Util.getString("RunnableState.Unknown_state_value___7") + value);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) throws IllegalStateException {
        switch (newState) {
            case 0: {
                if (this.state == 0) break;
                throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_to__8") + UNSTARTED_LITERAL);
            }
            case 1: {
                if (this.state == 1) break;
                if (this.state == 2 || this.state == 3) {
                    throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_from__9") + RunnableState.getLiteralForState(this.state) + CorePlugin.Util.getString("RunnableState._to__10") + STARTING_LITERAL);
                }
                this.state = newState;
                break;
            }
            case 2: {
                if (this.state == 2) break;
                if (this.state == 1) {
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_from__11") + RunnableState.getLiteralForState(this.state) + CorePlugin.Util.getString("RunnableState._to__12") + STARTED_LITERAL);
            }
            case 3: {
                if (this.state == 3) break;
                if (this.state == 2) {
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_from__13") + RunnableState.getLiteralForState(this.state) + CorePlugin.Util.getString("RunnableState._to__14") + STOPPING_LITERAL);
            }
            case 4: {
                if (this.state == 4) break;
                if (this.state == 3) {
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_from__15") + RunnableState.getLiteralForState(this.state) + CorePlugin.Util.getString("RunnableState._to__16") + STOPPED_LITERAL);
            }
            case 5: {
                if (this.state == 5) break;
                if (this.state == 1 || this.state == 2 || this.state == 3) {
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CorePlugin.Util.getString("RunnableState.Unable_to_change_the_state_from__17") + RunnableState.getLiteralForState(this.state) + CorePlugin.Util.getString("RunnableState._to__18") + FAILED_LITERAL);
            }
            default: {
                throw new IllegalArgumentException(CorePlugin.Util.getString("RunnableState.Unknown_state_value___19") + newState);
            }
        }
    }

    public boolean isState(int state) {
        return this.state == state;
    }

    public boolean isInTransition() {
        return this.state == 1 || this.state == 3;
    }

    public boolean isRunning() {
        return this.state == 2;
    }
}

