/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.net.SocketHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketUtil {
    static final String TRUSTSTORE_PASSWORD = "com.metamatrix.ssl.trustStorePassword";
    static final String TRUSTSTORE_FILENAME = "com.metamatrix.ssl.trustStore";
    static final String KEYSTORE_ALGORITHM = "com.metamatrix.ssl.algorithm";
    static final String PROTOCOL = "com.metamatrix.ssl.protocol";
    static final String KEYSTORE_TYPE = "com.metamatrix.ssl.keyStoreType";
    static final String KEYSTORE_PASSWORD = "com.metamatrix.ssl.keyStorePassword";
    static final String KEYSTORE_FILENAME = "com.metamatrix.ssl.keyStore";
    static final String JAVAX_TRUSTSTORE_FILENAME = "javax.net.ssl.trustStore";
    static final String JAVAX_KEYSTORE_FILENAME = "javax.net.ssl.keyStore";
    static final String JAVAX_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    static final String JAVAX_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    static final String DEFAULT_ALGORITHM = "SunX509";
    static final String DEFAULT_KEYSTORE_PROTOCOL = "SSLv3";
    static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    static final String DEFAULT_KEYSTORE = "metamatrix.keystore";
    static final String DEFAULT_TRUSTSTORE = "metamatrix.truststore";
    static final String DEFAULT_PASSWORD = "changeit";
    static final String NONE = "none";

    public static Socket createSocket(boolean ssl) throws IOException {
        if (!ssl) {
            return new Socket();
        }
        String truststore = System.getProperty(TRUSTSTORE_FILENAME);
        boolean anon = NONE.equalsIgnoreCase(truststore);
        SSLSocket socket = null;
        if (anon) {
            SSLContext context = SocketHelper.getAnonSSLContext();
            socket = (SSLSocket)context.getSocketFactory().createSocket();
            SocketHelper.addCipherSuite(socket, "TLS_DH_anon_WITH_AES_128_CBC_SHA");
        } else {
            socket = (SSLSocket)SocketUtil.getClientSocketFactory().createSocket();
        }
        return socket;
    }

    static SSLSocketFactory getClientSocketFactory() throws IOException {
        String keystore = System.getProperty(KEYSTORE_FILENAME);
        String keystorePassword = System.getProperty(KEYSTORE_PASSWORD);
        String keystoreType = System.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        String keystoreProtocol = System.getProperty(PROTOCOL, DEFAULT_KEYSTORE_PROTOCOL);
        String keystoreAlgorithm = System.getProperty(KEYSTORE_ALGORITHM, DEFAULT_ALGORITHM);
        String truststore = System.getProperty(TRUSTSTORE_FILENAME, keystore);
        String truststorePassword = System.getProperty(TRUSTSTORE_PASSWORD, keystorePassword);
        SSLSocketFactory factory = null;
        if (keystore != null) {
            factory = SocketUtil.getClientSocketFactory(keystore, keystorePassword, truststore, truststorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol);
        } else if (truststore != null) {
            factory = SocketUtil.getClientSocketFactory(null, null, truststore, truststorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol);
        } else {
            keystore = System.getProperty(JAVAX_KEYSTORE_FILENAME);
            truststore = System.getProperty(JAVAX_TRUSTSTORE_FILENAME);
            if (keystore != null || truststore != null) {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                InputStream ksStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_KEYSTORE);
                InputStream tsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_TRUSTSTORE);
                if (keystorePassword == null) {
                    keystorePassword = System.getProperty(JAVAX_KEYSTORE_PASSWORD, DEFAULT_PASSWORD);
                }
                if (truststorePassword == null) {
                    truststorePassword = System.getProperty(JAVAX_TRUSTSTORE_PASSWORD, DEFAULT_PASSWORD);
                }
                factory = ksStream != null && tsStream != null ? SocketUtil.getClientSocketFactory(DEFAULT_KEYSTORE, keystorePassword, DEFAULT_TRUSTSTORE, truststorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol) : (ksStream == null && tsStream != null ? SocketUtil.getClientSocketFactory(DEFAULT_TRUSTSTORE, truststorePassword, DEFAULT_TRUSTSTORE, truststorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol) : (ksStream != null && tsStream == null ? SocketUtil.getClientSocketFactory(DEFAULT_KEYSTORE, keystorePassword, DEFAULT_KEYSTORE, keystorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol) : (SSLSocketFactory)SSLSocketFactory.getDefault()));
            }
        }
        return factory;
    }

    static SSLSocketFactory getClientSocketFactory(String keystore, String password, String truststore, String truststorePassword, String algorithm, String keystoreType, String protocol) throws IOException {
        SSLContext context = SocketHelper.getSSLContext(keystore, password, truststore, truststorePassword, algorithm, keystoreType, protocol);
        return context.getSocketFactory();
    }
}

