/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.xa;

import com.metamatrix.connector.jdbc.xa.JDBCSourceXAConnection;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.xa.api.XAResourceMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private static Map connections = XAResourceMap.getXAResourceMap();
    private XAResource xaResource;
    private JDBCSourceXAConnection connection;
    private String resourceName;

    XAResourceWrapper(XAResource xaResource, JDBCSourceXAConnection connection, String resourceName) {
        this.connection = connection;
        this.xaResource = xaResource;
        this.resourceName = resourceName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XAResourceWrapper)) {
            return false;
        }
        XAResourceWrapper other = (XAResourceWrapper)obj;
        return this.resourceName.equals(other.resourceName) && this.connection == other.connection;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException xe) {
            xe.printStackTrace();
            throw xe;
        }
        finally {
            try {
                this.removeFromMap(xid);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        this.xaResource.end(xid, flag);
    }

    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource instanceof XAResourceWrapper) {
            resource = ((XAResourceWrapper)resource).xaResource;
        }
        boolean sameRM = this.xaResource.isSameRM(resource);
        return sameRM;
    }

    public int prepare(Xid xid) throws XAException {
        int result = this.xaResource.prepare(xid);
        if (result == 3) {
            this.removeFromMap(xid);
        }
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaResource.rollback(xid);
        }
        finally {
            this.removeFromMap(xid);
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return this.xaResource.setTransactionTimeout(timeout);
    }

    public void start(Xid xid, int flag) throws XAException {
        this.xaResource.start(xid, flag);
        this.connection.setInTxn(true);
        this.addToMap(xid);
    }

    public String toString() {
        return this.xaResource.toString() + "::" + this.resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(Xid xid) {
        MMXid xidKey = new MMXid(xid);
        Set connSet = null;
        Map map = connections;
        synchronized (map) {
            connSet = (Set)connections.get(xidKey);
            if (connSet == null) {
                return;
            }
            ArrayList<JDBCSourceXAConnection> removeList = new ArrayList<JDBCSourceXAConnection>();
            Iterator connItr = connSet.iterator();
            while (connItr.hasNext()) {
                boolean release = true;
                JDBCSourceXAConnection conn = (JDBCSourceXAConnection)((Object)connItr.next());
                if (conn != null) {
                    try {
                        if (!this.isSameRM(conn.getXAResource())) {
                            release = false;
                        }
                    }
                    catch (ConnectorException e) {
                    }
                    catch (XAException e) {
                        // empty catch block
                    }
                }
                if (!release) continue;
                conn.forceRelease();
                removeList.add(conn);
            }
            Iterator i = removeList.iterator();
            while (i.hasNext()) {
                connSet.remove(i.next());
            }
            if (connSet.isEmpty()) {
                connections.remove(xidKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(Xid xid) {
        MMXid xidKey = new MMXid(xid);
        Map map = connections;
        synchronized (map) {
            HashSet<JDBCSourceXAConnection> connSet = (HashSet<JDBCSourceXAConnection>)connections.get(xidKey);
            if (connSet == null) {
                connSet = new HashSet<JDBCSourceXAConnection>();
                connections.put(xidKey, connSet);
            }
            connSet.add(this.connection);
        }
    }

    static class MMXid {
        private int formatID;
        private byte[] globalTransactionId;
        private byte[] branchQualifier;
        private int hashCode;

        public MMXid(Xid xid) {
            this.formatID = xid.getFormatId();
            this.globalTransactionId = xid.getGlobalTransactionId();
            this.branchQualifier = xid.getBranchQualifier();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof MMXid)) {
                return false;
            }
            MMXid that = (MMXid)obj;
            if (this.formatID != that.formatID) {
                return false;
            }
            if (!this.areByteArraysEqual(this.globalTransactionId, that.globalTransactionId)) {
                return false;
            }
            return this.areByteArraysEqual(this.branchQualifier, that.branchQualifier);
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            return HashCodeUtil.hashCode((int)HashCodeUtil.hashCode((int)this.formatID, (Object)new String(this.globalTransactionId)), (Object)new String(this.branchQualifier));
        }

        private boolean areByteArraysEqual(byte[] firstByteArray, byte[] secondByteArray) {
            if (firstByteArray == null || secondByteArray == null) {
                return false;
            }
            if (firstByteArray.length != secondByteArray.length) {
                return false;
            }
            for (int i = 0; i < firstByteArray.length; ++i) {
                if (firstByteArray[i] == secondByteArray[i]) continue;
                return false;
            }
            return true;
        }
    }
}

